/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.spout;

import backtype.storm.spout.ISpoutOutputCollector;
import backtype.storm.spout.SpoutOutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.IRichSpout;
import backtype.storm.tuple.Fields;
import backtype.storm.utils.RotatingMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import storm.trident.operation.TridentCollector;
import storm.trident.spout.ITridentSpout;
import storm.trident.topology.TransactionAttempt;
import storm.trident.util.TridentUtils;

public class RichSpoutBatchExecutor
implements ITridentSpout {
    public static final String MAX_BATCH_SIZE_CONF = "topology.spout.max.batch.size";
    IRichSpout _spout;

    public RichSpoutBatchExecutor(IRichSpout spout2) {
        this._spout = spout2;
    }

    @Override
    public Map getComponentConfiguration() {
        return this._spout.getComponentConfiguration();
    }

    @Override
    public Fields getOutputFields() {
        return TridentUtils.getSingleOutputStreamFields(this._spout);
    }

    public ITridentSpout.BatchCoordinator getCoordinator(String txStateId, Map conf, TopologyContext context2) {
        return new RichSpoutCoordinator();
    }

    public ITridentSpout.Emitter getEmitter(String txStateId, Map conf, TopologyContext context2) {
        return new RichSpoutEmitter(conf, context2);
    }

    static class CaptureCollector
    implements ISpoutOutputCollector {
        TridentCollector _collector;
        public List<Object> ids;
        public int numEmitted;

        CaptureCollector() {
        }

        public void reset(TridentCollector c) {
            this._collector = c;
            this.ids = new ArrayList<Object>();
        }

        @Override
        public void reportError(Throwable t) {
            this._collector.reportError(t);
        }

        @Override
        public List<Integer> emit(String stream, List<Object> values, Object id) {
            if (id != null) {
                this.ids.add(id);
            }
            ++this.numEmitted;
            this._collector.emit(values);
            return null;
        }

        @Override
        public void emitDirect(int task2, String stream, List<Object> values, Object id) {
            throw new UnsupportedOperationException("Trident does not support direct streams");
        }
    }

    class RichSpoutCoordinator
    implements ITridentSpout.BatchCoordinator {
        RichSpoutCoordinator() {
        }

        public Object initializeTransaction(long txid, Object prevMetadata, Object currMetadata) {
            return null;
        }

        @Override
        public void success(long txid) {
        }

        @Override
        public boolean isReady(long txid) {
            return true;
        }

        @Override
        public void close() {
        }
    }

    class RichSpoutEmitter
    implements ITridentSpout.Emitter<Object> {
        int _maxBatchSize;
        boolean prepared = false;
        CaptureCollector _collector;
        RotatingMap<Long, List<Object>> idsMap;
        Map _conf;
        TopologyContext _context;
        long lastRotate = System.currentTimeMillis();
        long rotateTime;

        public RichSpoutEmitter(Map conf, TopologyContext context2) {
            this._conf = conf;
            this._context = context2;
            Number batchSize = (Number)conf.get(RichSpoutBatchExecutor.MAX_BATCH_SIZE_CONF);
            if (batchSize == null) {
                batchSize = 1000;
            }
            this._maxBatchSize = batchSize.intValue();
            this._collector = new CaptureCollector();
            this.idsMap = new RotatingMap(3);
            this.rotateTime = 1000L * (long)((Number)conf.get("topology.message.timeout.secs")).intValue();
        }

        @Override
        public void emitBatch(TransactionAttempt tx, Object coordinatorMeta, TridentCollector collector) {
            long txid = tx.getTransactionId();
            long now2 = System.currentTimeMillis();
            if (now2 - this.lastRotate > this.rotateTime) {
                Map<Long, List<Object>> failed = this.idsMap.rotate();
                for (Long id : failed.keySet()) {
                    this.fail(id);
                }
                this.lastRotate = now2;
            }
            if (this.idsMap.containsKey(txid)) {
                this.fail(txid);
            }
            this._collector.reset(collector);
            if (!this.prepared) {
                RichSpoutBatchExecutor.this._spout.open(this._conf, this._context, new SpoutOutputCollector(this._collector));
                this.prepared = true;
            }
            for (int i = 0; i < this._maxBatchSize; ++i) {
                RichSpoutBatchExecutor.this._spout.nextTuple();
                if (this._collector.numEmitted < i) break;
            }
            this.idsMap.put(txid, this._collector.ids);
        }

        @Override
        public void success(TransactionAttempt tx) {
            this.ack(tx.getTransactionId());
        }

        private void ack(long batchId) {
            List ids = (List)this.idsMap.remove(batchId);
            if (ids != null) {
                for (Object id : ids) {
                    RichSpoutBatchExecutor.this._spout.ack(id);
                }
            }
        }

        private void fail(long batchId) {
            List ids = (List)this.idsMap.remove(batchId);
            if (ids != null) {
                for (Object id : ids) {
                    RichSpoutBatchExecutor.this._spout.fail(id);
                }
            }
        }

        @Override
        public void close() {
            RichSpoutBatchExecutor.this._spout.close();
        }
    }
}

