/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.planner.processor;

import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Fields;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import storm.trident.operation.TridentOperationContext;
import storm.trident.planner.ProcessorContext;
import storm.trident.planner.TridentProcessor;
import storm.trident.planner.processor.AppendCollector;
import storm.trident.planner.processor.TridentContext;
import storm.trident.state.QueryFunction;
import storm.trident.state.State;
import storm.trident.tuple.TridentTuple;
import storm.trident.tuple.TridentTupleView;

public class StateQueryProcessor
implements TridentProcessor {
    QueryFunction _function;
    State _state;
    String _stateId;
    TridentContext _context;
    Fields _inputFields;
    TridentTupleView.ProjectionFactory _projection;
    AppendCollector _collector;

    public StateQueryProcessor(String stateId, Fields inputFields, QueryFunction function) {
        this._stateId = stateId;
        this._function = function;
        this._inputFields = inputFields;
    }

    @Override
    public void prepare(Map conf, TopologyContext context2, TridentContext tridentContext) {
        List<TridentTuple.Factory> parents = tridentContext.getParentTupleFactories();
        if (parents.size() != 1) {
            throw new RuntimeException("State query operation can only have one parent");
        }
        this._context = tridentContext;
        this._state = (State)context2.getTaskData(this._stateId);
        this._projection = new TridentTupleView.ProjectionFactory(parents.get(0), this._inputFields);
        this._collector = new AppendCollector(tridentContext);
        this._function.prepare(conf, new TridentOperationContext(context2, (TridentTuple.Factory)this._projection));
    }

    @Override
    public void cleanup() {
        this._function.cleanup();
    }

    @Override
    public void startBatch(ProcessorContext processorContext) {
        processorContext.state[this._context.getStateIndex()] = new BatchState();
    }

    @Override
    public void execute(ProcessorContext processorContext, String streamId, TridentTuple tuple2) {
        BatchState state = (BatchState)processorContext.state[this._context.getStateIndex()];
        state.tuples.add(tuple2);
        state.args.add(this._projection.create(tuple2));
    }

    @Override
    public void finishBatch(ProcessorContext processorContext) {
        BatchState state = (BatchState)processorContext.state[this._context.getStateIndex()];
        if (!state.tuples.isEmpty()) {
            List results = this._function.batchRetrieve(this._state, state.args);
            if (results.size() != state.tuples.size()) {
                throw new RuntimeException("Results size is different than argument size: " + results.size() + " vs " + state.tuples.size());
            }
            for (int i = 0; i < state.tuples.size(); ++i) {
                TridentTuple tuple2 = state.tuples.get(i);
                Object result2 = results.get(i);
                this._collector.setContext(processorContext, tuple2);
                this._function.execute(this._projection.create(tuple2), result2, this._collector);
            }
        }
    }

    @Override
    public TridentTuple.Factory getOutputFactory() {
        return this._collector.getOutputFactory();
    }

    private static class BatchState {
        public List<TridentTuple> tuples = new ArrayList<TridentTuple>();
        public List<TridentTuple> args = new ArrayList<TridentTuple>();

        private BatchState() {
        }
    }
}

