/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.planner.processor;

import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Fields;
import java.util.Map;
import storm.trident.planner.ProcessorContext;
import storm.trident.planner.TridentProcessor;
import storm.trident.planner.TupleReceiver;
import storm.trident.planner.processor.TridentContext;
import storm.trident.tuple.TridentTuple;
import storm.trident.tuple.TridentTupleView;

public class ProjectedProcessor
implements TridentProcessor {
    Fields _projectFields;
    TridentTupleView.ProjectionFactory _factory;
    TridentContext _context;

    public ProjectedProcessor(Fields projectFields) {
        this._projectFields = projectFields;
    }

    @Override
    public void prepare(Map conf, TopologyContext context2, TridentContext tridentContext) {
        if (tridentContext.getParentTupleFactories().size() != 1) {
            throw new RuntimeException("Projection processor can only have one parent");
        }
        this._context = tridentContext;
        this._factory = new TridentTupleView.ProjectionFactory(tridentContext.getParentTupleFactories().get(0), this._projectFields);
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void startBatch(ProcessorContext processorContext) {
    }

    @Override
    public void execute(ProcessorContext processorContext, String streamId, TridentTuple tuple2) {
        TridentTuple toEmit = this._factory.create(tuple2);
        for (TupleReceiver r : this._context.getReceivers()) {
            r.execute(processorContext, this._context.getOutStreamId(), toEmit);
        }
    }

    @Override
    public void finishBatch(ProcessorContext processorContext) {
    }

    @Override
    public TridentTuple.Factory getOutputFactory() {
        return this._factory;
    }
}

