/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.planner.processor;

import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Fields;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import storm.trident.operation.TridentOperationContext;
import storm.trident.planner.ProcessorContext;
import storm.trident.planner.TridentProcessor;
import storm.trident.planner.processor.FreshCollector;
import storm.trident.planner.processor.TridentContext;
import storm.trident.state.State;
import storm.trident.state.StateUpdater;
import storm.trident.topology.TransactionAttempt;
import storm.trident.tuple.TridentTuple;
import storm.trident.tuple.TridentTupleView;

public class PartitionPersistProcessor
implements TridentProcessor {
    StateUpdater _updater;
    State _state;
    String _stateId;
    TridentContext _context;
    Fields _inputFields;
    TridentTupleView.ProjectionFactory _projection;
    FreshCollector _collector;

    public PartitionPersistProcessor(String stateId, Fields inputFields, StateUpdater updater) {
        this._updater = updater;
        this._stateId = stateId;
        this._inputFields = inputFields;
    }

    @Override
    public void prepare(Map conf, TopologyContext context2, TridentContext tridentContext) {
        List<TridentTuple.Factory> parents = tridentContext.getParentTupleFactories();
        if (parents.size() != 1) {
            throw new RuntimeException("Partition persist operation can only have one parent");
        }
        this._context = tridentContext;
        this._state = (State)context2.getTaskData(this._stateId);
        this._projection = new TridentTupleView.ProjectionFactory(parents.get(0), this._inputFields);
        this._collector = new FreshCollector(tridentContext);
        this._updater.prepare(conf, new TridentOperationContext(context2, (TridentTuple.Factory)this._projection));
    }

    @Override
    public void cleanup() {
        this._updater.cleanup();
    }

    @Override
    public void startBatch(ProcessorContext processorContext) {
        processorContext.state[this._context.getStateIndex()] = new ArrayList();
    }

    @Override
    public void execute(ProcessorContext processorContext, String streamId, TridentTuple tuple2) {
        ((List)processorContext.state[this._context.getStateIndex()]).add(this._projection.create(tuple2));
    }

    @Override
    public void finishBatch(ProcessorContext processorContext) {
        this._collector.setContext(processorContext);
        Object batchId = processorContext.batchId;
        List buffer = (List)processorContext.state[this._context.getStateIndex()];
        if (buffer.size() > 0) {
            Long txid = null;
            if (batchId instanceof TransactionAttempt) {
                txid = ((TransactionAttempt)batchId).getTransactionId();
            }
            this._state.beginCommit(txid);
            this._updater.updateState(this._state, buffer, this._collector);
            this._state.commit(txid);
        }
    }

    @Override
    public TridentTuple.Factory getOutputFactory() {
        return this._collector.getOutputFactory();
    }
}

