/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.planner.processor;

import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Fields;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import storm.trident.operation.MultiReducer;
import storm.trident.operation.TridentMultiReducerContext;
import storm.trident.planner.ProcessorContext;
import storm.trident.planner.TridentProcessor;
import storm.trident.planner.processor.FreshCollector;
import storm.trident.planner.processor.TridentContext;
import storm.trident.tuple.TridentTuple;
import storm.trident.tuple.TridentTupleView;

public class MultiReducerProcessor
implements TridentProcessor {
    MultiReducer _reducer;
    TridentContext _context;
    Map<String, Integer> _streamToIndex;
    List<Fields> _projectFields;
    TridentTupleView.ProjectionFactory[] _projectionFactories;
    FreshCollector _collector;

    public MultiReducerProcessor(List<Fields> inputFields, MultiReducer reducer) {
        this._reducer = reducer;
        this._projectFields = inputFields;
    }

    @Override
    public void prepare(Map conf, TopologyContext context2, TridentContext tridentContext) {
        int i;
        List<TridentTuple.Factory> parents = tridentContext.getParentTupleFactories();
        this._context = tridentContext;
        this._streamToIndex = new HashMap<String, Integer>();
        List<String> parentStreams = tridentContext.getParentStreams();
        for (i = 0; i < parentStreams.size(); ++i) {
            this._streamToIndex.put(parentStreams.get(i), i);
        }
        this._projectionFactories = new TridentTupleView.ProjectionFactory[this._projectFields.size()];
        for (i = 0; i < this._projectFields.size(); ++i) {
            this._projectionFactories[i] = new TridentTupleView.ProjectionFactory(parents.get(i), this._projectFields.get(i));
        }
        this._collector = new FreshCollector(tridentContext);
        this._reducer.prepare(conf, new TridentMultiReducerContext(Arrays.asList(this._projectionFactories)));
    }

    @Override
    public void cleanup() {
        this._reducer.cleanup();
    }

    @Override
    public void startBatch(ProcessorContext processorContext) {
        this._collector.setContext(processorContext);
        processorContext.state[this._context.getStateIndex()] = this._reducer.init(this._collector);
    }

    @Override
    public void execute(ProcessorContext processorContext, String streamId, TridentTuple tuple2) {
        this._collector.setContext(processorContext);
        int i = this._streamToIndex.get(streamId);
        this._reducer.execute(processorContext.state[this._context.getStateIndex()], i, this._projectionFactories[i].create(tuple2), this._collector);
    }

    @Override
    public void finishBatch(ProcessorContext processorContext) {
        this._collector.setContext(processorContext);
        this._reducer.complete(processorContext.state[this._context.getStateIndex()], this._collector);
    }

    @Override
    public TridentTuple.Factory getOutputFactory() {
        return this._collector.getOutputFactory();
    }
}

