/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.planner.processor;

import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Fields;
import java.util.List;
import java.util.Map;
import storm.trident.operation.Aggregator;
import storm.trident.operation.TridentOperationContext;
import storm.trident.planner.ProcessorContext;
import storm.trident.planner.TridentProcessor;
import storm.trident.planner.processor.FreshCollector;
import storm.trident.planner.processor.TridentContext;
import storm.trident.tuple.TridentTuple;
import storm.trident.tuple.TridentTupleView;

public class AggregateProcessor
implements TridentProcessor {
    Aggregator _agg;
    TridentContext _context;
    FreshCollector _collector;
    Fields _inputFields;
    TridentTupleView.ProjectionFactory _projection;

    public AggregateProcessor(Fields inputFields, Aggregator agg) {
        this._agg = agg;
        this._inputFields = inputFields;
    }

    @Override
    public void prepare(Map conf, TopologyContext context2, TridentContext tridentContext) {
        List<TridentTuple.Factory> parents = tridentContext.getParentTupleFactories();
        if (parents.size() != 1) {
            throw new RuntimeException("Aggregate operation can only have one parent");
        }
        this._context = tridentContext;
        this._collector = new FreshCollector(tridentContext);
        this._projection = new TridentTupleView.ProjectionFactory(parents.get(0), this._inputFields);
        this._agg.prepare(conf, new TridentOperationContext(context2, (TridentTuple.Factory)this._projection));
    }

    @Override
    public void cleanup() {
        this._agg.cleanup();
    }

    @Override
    public void startBatch(ProcessorContext processorContext) {
        this._collector.setContext(processorContext);
        processorContext.state[this._context.getStateIndex()] = this._agg.init(processorContext.batchId, this._collector);
    }

    @Override
    public void execute(ProcessorContext processorContext, String streamId, TridentTuple tuple2) {
        this._collector.setContext(processorContext);
        this._agg.aggregate(processorContext.state[this._context.getStateIndex()], this._projection.create(tuple2), this._collector);
    }

    @Override
    public void finishBatch(ProcessorContext processorContext) {
        this._collector.setContext(processorContext);
        this._agg.complete(processorContext.state[this._context.getStateIndex()], this._collector);
    }

    @Override
    public TridentTuple.Factory getOutputFactory() {
        return this._collector.getOutputFactory();
    }
}

