/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.operation.impl;

import backtype.storm.tuple.Fields;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import storm.trident.JoinType;
import storm.trident.operation.GroupedMultiReducer;
import storm.trident.operation.TridentCollector;
import storm.trident.operation.TridentMultiReducerContext;
import storm.trident.tuple.ComboList;
import storm.trident.tuple.TridentTuple;

public class JoinerMultiReducer
implements GroupedMultiReducer<JoinState> {
    List<JoinType> _types;
    List<Fields> _sideFields;
    int _numGroupFields;
    ComboList.Factory _factory;

    public JoinerMultiReducer(List<JoinType> types, int numGroupFields, List<Fields> sides) {
        this._types = types;
        this._sideFields = sides;
        this._numGroupFields = numGroupFields;
    }

    @Override
    public void prepare(Map conf, TridentMultiReducerContext context2) {
        int[] sizes = new int[this._sideFields.size() + 1];
        sizes[0] = this._numGroupFields;
        for (int i = 0; i < this._sideFields.size(); ++i) {
            sizes[i + 1] = this._sideFields.get(i).size();
        }
        this._factory = new ComboList.Factory(sizes);
    }

    @Override
    public JoinState init(TridentCollector collector, TridentTuple group) {
        return new JoinState(this._types.size(), group);
    }

    @Override
    public void execute(JoinState state, int streamIndex, TridentTuple group, TridentTuple input, TridentCollector collector) {
        List<List> side = state.sides[streamIndex];
        if (side.isEmpty()) {
            ++state.numSidesReceived;
        }
        side.add(input);
        if (state.numSidesReceived == state.sides.length) {
            this.emitCrossJoin(state, collector, streamIndex, input);
        }
    }

    @Override
    public void complete(JoinState state, TridentTuple group, TridentCollector collector) {
        List<List>[] sides = state.sides;
        boolean wasEmpty = state.numSidesReceived < sides.length;
        for (int i = 0; i < sides.length; ++i) {
            if (!sides[i].isEmpty() || this._types.get(i) != JoinType.OUTER) continue;
            ++state.numSidesReceived;
            sides[i].add(this.makeNullList(this._sideFields.get(i).size()));
        }
        if (wasEmpty && state.numSidesReceived == sides.length) {
            this.emitCrossJoin(state, collector, -1, null);
        }
    }

    @Override
    public void cleanup() {
    }

    private List<Object> makeNullList(int size) {
        ArrayList<Object> ret = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            ret.add(null);
        }
        return ret;
    }

    private void emitCrossJoin(JoinState state, TridentCollector collector, int overrideIndex, TridentTuple overrideTuple) {
        List[] sides = state.sides;
        int[] indices = state.indices;
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = 0;
        }
        boolean keepGoing = true;
        while (keepGoing) {
            List[] combined = new List[sides.length + 1];
            combined[0] = state.group;
            for (int i = 0; i < sides.length; ++i) {
                combined[i + 1] = i == overrideIndex ? overrideTuple : sides[i].get(indices[i]);
            }
            collector.emit(this._factory.create(combined));
            keepGoing = this.increment(sides, indices, indices.length - 1, overrideIndex);
        }
    }

    private boolean increment(List[] lengths, int[] indices, int j, int overrideIndex) {
        if (j == -1) {
            return false;
        }
        if (j == overrideIndex) {
            return this.increment(lengths, indices, j - 1, overrideIndex);
        }
        int n = j;
        indices[n] = indices[n] + 1;
        if (indices[j] >= lengths[j].size()) {
            indices[j] = 0;
            return this.increment(lengths, indices, j - 1, overrideIndex);
        }
        return true;
    }

    public static class JoinState {
        List<List>[] sides;
        int numSidesReceived = 0;
        int[] indices;
        TridentTuple group;

        public JoinState(int numSides, TridentTuple group) {
            this.sides = new List[numSides];
            this.indices = new int[numSides];
            this.group = group;
            for (int i = 0; i < numSides; ++i) {
                this.sides[i] = new ArrayList<List>();
            }
        }
    }
}

