/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.graph;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.storm.shade.org.jgrapht.DirectedGraph;
import storm.trident.planner.Node;
import storm.trident.util.IndexedEdge;
import storm.trident.util.TridentUtils;

public class Group {
    public Set<Node> nodes = new HashSet<Node>();
    private DirectedGraph<Node, IndexedEdge> graph;
    private String id;

    public Group(DirectedGraph graph2, List<Node> nodes) {
        this.init(graph2);
        this.nodes.addAll(nodes);
        this.graph = graph2;
    }

    public Group(DirectedGraph graph2, Node n) {
        this(graph2, Arrays.asList(n));
    }

    public Group(Group g1, Group g2) {
        this.init(g1.graph);
        this.nodes.addAll(g1.nodes);
        this.nodes.addAll(g2.nodes);
    }

    private void init(DirectedGraph graph2) {
        this.graph = graph2;
        this.id = UUID.randomUUID().toString();
    }

    public Set<Node> outgoingNodes() {
        HashSet<Node> ret = new HashSet<Node>();
        for (Node n : this.nodes) {
            ret.addAll(TridentUtils.getChildren(this.graph, n));
        }
        return ret;
    }

    public Set<Node> incomingNodes() {
        HashSet<Node> ret = new HashSet<Node>();
        for (Node n : this.nodes) {
            ret.addAll(TridentUtils.getParents(this.graph, n));
        }
        return ret;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        return this.id.equals(((Group)o).id);
    }

    public String toString() {
        return this.nodes.toString();
    }
}

