/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.graph;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.storm.shade.org.jgrapht.DirectedGraph;
import storm.trident.graph.Group;
import storm.trident.planner.Node;
import storm.trident.util.IndexedEdge;

public class GraphGrouper {
    DirectedGraph<Node, IndexedEdge> graph;
    Set<Group> currGroups;
    Map<Node, Group> groupIndex = new HashMap<Node, Group>();

    public GraphGrouper(DirectedGraph<Node, IndexedEdge> graph2, Collection<Group> initialGroups) {
        this.graph = graph2;
        this.currGroups = new HashSet<Group>(initialGroups);
        this.reindex();
    }

    public Collection<Group> getAllGroups() {
        return this.currGroups;
    }

    public void addGroup(Group g) {
        this.currGroups.add(g);
    }

    public void reindex() {
        this.groupIndex.clear();
        for (Group g : this.currGroups) {
            for (Node n : g.nodes) {
                this.groupIndex.put(n, g);
            }
        }
    }

    public void mergeFully() {
        boolean somethingHappened = true;
        block0: while (somethingHappened) {
            somethingHappened = false;
            for (Group g : this.currGroups) {
                Group in;
                Group out;
                Collection<Group> outgoingGroups = this.outgoingGroups(g);
                if (outgoingGroups.size() == 1 && (out = outgoingGroups.iterator().next()) != null) {
                    this.merge(g, out);
                    somethingHappened = true;
                    continue block0;
                }
                Collection<Group> incomingGroups = this.incomingGroups(g);
                if (incomingGroups.size() != 1 || (in = incomingGroups.iterator().next()) == null) continue;
                this.merge(g, in);
                somethingHappened = true;
                continue block0;
            }
        }
    }

    private void merge(Group g1, Group g2) {
        Group newGroup = new Group(g1, g2);
        this.currGroups.remove(g1);
        this.currGroups.remove(g2);
        this.currGroups.add(newGroup);
        for (Node n : newGroup.nodes) {
            this.groupIndex.put(n, newGroup);
        }
    }

    public Collection<Group> outgoingGroups(Group g) {
        HashSet<Group> ret = new HashSet<Group>();
        for (Node n : g.outgoingNodes()) {
            Group other = this.nodeGroup(n);
            if (other != null && other.equals(g)) continue;
            ret.add(other);
        }
        return ret;
    }

    public Collection<Group> incomingGroups(Group g) {
        HashSet<Group> ret = new HashSet<Group>();
        for (Node n : g.incomingNodes()) {
            Group other = this.nodeGroup(n);
            if (other != null && other.equals(g)) continue;
            ret.add(other);
        }
        return ret;
    }

    public Group nodeGroup(Node n) {
        return this.groupIndex.get(n);
    }
}

