/*
 * Decompiled with CFR 0.152.
 */
package storm.trident;

import backtype.storm.generated.Grouping;
import backtype.storm.generated.NullStruct;
import backtype.storm.grouping.CustomStreamGrouping;
import backtype.storm.tuple.Fields;
import backtype.storm.utils.Utils;
import storm.trident.TridentState;
import storm.trident.TridentTopology;
import storm.trident.fluent.ChainedAggregatorDeclarer;
import storm.trident.fluent.GlobalAggregationScheme;
import storm.trident.fluent.GroupedStream;
import storm.trident.fluent.IAggregatableStream;
import storm.trident.operation.Aggregator;
import storm.trident.operation.Assembly;
import storm.trident.operation.CombinerAggregator;
import storm.trident.operation.Filter;
import storm.trident.operation.Function;
import storm.trident.operation.ReducerAggregator;
import storm.trident.operation.impl.CombinerAggStateUpdater;
import storm.trident.operation.impl.FilterExecutor;
import storm.trident.operation.impl.GlobalBatchToPartition;
import storm.trident.operation.impl.IndexHashBatchToPartition;
import storm.trident.operation.impl.ReducerAggStateUpdater;
import storm.trident.operation.impl.SingleEmitAggregator;
import storm.trident.operation.impl.TrueFilter;
import storm.trident.partition.GlobalGrouping;
import storm.trident.partition.IdentityGrouping;
import storm.trident.partition.IndexHashGrouping;
import storm.trident.planner.Node;
import storm.trident.planner.NodeStateInfo;
import storm.trident.planner.PartitionNode;
import storm.trident.planner.ProcessorNode;
import storm.trident.planner.processor.AggregateProcessor;
import storm.trident.planner.processor.EachProcessor;
import storm.trident.planner.processor.PartitionPersistProcessor;
import storm.trident.planner.processor.ProjectedProcessor;
import storm.trident.planner.processor.StateQueryProcessor;
import storm.trident.state.QueryFunction;
import storm.trident.state.StateFactory;
import storm.trident.state.StateSpec;
import storm.trident.state.StateUpdater;
import storm.trident.util.TridentUtils;

public class Stream
implements IAggregatableStream {
    Node _node;
    TridentTopology _topology;
    String _name;

    protected Stream(TridentTopology topology, String name, Node node) {
        this._topology = topology;
        this._node = node;
        this._name = name;
    }

    public Stream name(String name) {
        return new Stream(this._topology, name, this._node);
    }

    public Stream parallelismHint(int hint) {
        this._node.parallelismHint = hint;
        return this;
    }

    public Stream project(Fields keepFields) {
        this.projectionValidation(keepFields);
        return this._topology.addSourcedNode(this, (Node)new ProcessorNode(this._topology.getUniqueStreamId(), this._name, keepFields, new Fields(new String[0]), new ProjectedProcessor(keepFields)));
    }

    public GroupedStream groupBy(Fields fields2) {
        this.projectionValidation(fields2);
        return new GroupedStream(this, fields2);
    }

    public Stream partitionBy(Fields fields2) {
        this.projectionValidation(fields2);
        return this.partition(Grouping.fields(fields2.toList()));
    }

    public Stream partition(CustomStreamGrouping partitioner) {
        return this.partition(Grouping.custom_serialized(Utils.javaSerialize(partitioner)));
    }

    public Stream shuffle() {
        return this.partition(Grouping.shuffle(new NullStruct()));
    }

    public Stream localOrShuffle() {
        return this.partition(Grouping.local_or_shuffle(new NullStruct()));
    }

    public Stream global() {
        return this.partition(new GlobalGrouping());
    }

    public Stream batchGlobal() {
        return this.partition(new IndexHashGrouping(0));
    }

    public Stream broadcast() {
        return this.partition(Grouping.all(new NullStruct()));
    }

    public Stream identityPartition() {
        return this.partition(new IdentityGrouping());
    }

    public Stream partition(Grouping grouping) {
        if (this._node instanceof PartitionNode) {
            return this.each(new Fields(new String[0]), new TrueFilter()).partition(grouping);
        }
        return this._topology.addSourcedNode(this, (Node)new PartitionNode(this._node.streamId, this._name, this.getOutputFields(), grouping));
    }

    public Stream applyAssembly(Assembly assembly) {
        return assembly.apply(this);
    }

    @Override
    public Stream each(Fields inputFields, Function function, Fields functionFields) {
        this.projectionValidation(inputFields);
        return this._topology.addSourcedNode(this, (Node)new ProcessorNode(this._topology.getUniqueStreamId(), this._name, TridentUtils.fieldsConcat(this.getOutputFields(), functionFields), functionFields, new EachProcessor(inputFields, function)));
    }

    @Override
    public Stream partitionAggregate(Fields inputFields, Aggregator agg, Fields functionFields) {
        this.projectionValidation(inputFields);
        return this._topology.addSourcedNode(this, (Node)new ProcessorNode(this._topology.getUniqueStreamId(), this._name, functionFields, functionFields, new AggregateProcessor(inputFields, agg)));
    }

    public Stream stateQuery(TridentState state, Fields inputFields, QueryFunction function, Fields functionFields) {
        this.projectionValidation(inputFields);
        String stateId = state._node.stateInfo.id;
        ProcessorNode n = new ProcessorNode(this._topology.getUniqueStreamId(), this._name, TridentUtils.fieldsConcat(this.getOutputFields(), functionFields), functionFields, new StateQueryProcessor(stateId, inputFields, function));
        this._topology._colocate.get(stateId).add(n);
        return this._topology.addSourcedNode(this, (Node)n);
    }

    public TridentState partitionPersist(StateFactory stateFactory, Fields inputFields, StateUpdater updater, Fields functionFields) {
        return this.partitionPersist(new StateSpec(stateFactory), inputFields, updater, functionFields);
    }

    public TridentState partitionPersist(StateSpec stateSpec, Fields inputFields, StateUpdater updater, Fields functionFields) {
        this.projectionValidation(inputFields);
        String id = this._topology.getUniqueStateId();
        ProcessorNode n = new ProcessorNode(this._topology.getUniqueStreamId(), this._name, functionFields, functionFields, new PartitionPersistProcessor(id, inputFields, updater));
        n.committer = true;
        n.stateInfo = new NodeStateInfo(id, stateSpec);
        return this._topology.addSourcedStateNode(this, (Node)n);
    }

    public TridentState partitionPersist(StateFactory stateFactory, Fields inputFields, StateUpdater updater) {
        return this.partitionPersist(stateFactory, inputFields, updater, new Fields(new String[0]));
    }

    public TridentState partitionPersist(StateSpec stateSpec, Fields inputFields, StateUpdater updater) {
        return this.partitionPersist(stateSpec, inputFields, updater, new Fields(new String[0]));
    }

    public Stream each(Function function, Fields functionFields) {
        return this.each(null, function, functionFields);
    }

    public Stream each(Fields inputFields, Filter filter) {
        return this.each(inputFields, new FilterExecutor(filter), new Fields(new String[0]));
    }

    public ChainedAggregatorDeclarer chainedAgg() {
        return new ChainedAggregatorDeclarer(this, new BatchGlobalAggScheme());
    }

    public Stream partitionAggregate(Aggregator agg, Fields functionFields) {
        return this.partitionAggregate(null, agg, functionFields);
    }

    public Stream partitionAggregate(CombinerAggregator agg, Fields functionFields) {
        return this.partitionAggregate(null, agg, functionFields);
    }

    public Stream partitionAggregate(Fields inputFields, CombinerAggregator agg, Fields functionFields) {
        this.projectionValidation(inputFields);
        return this.chainedAgg().partitionAggregate(inputFields, agg, functionFields).chainEnd();
    }

    public Stream partitionAggregate(ReducerAggregator agg, Fields functionFields) {
        return this.partitionAggregate(null, agg, functionFields);
    }

    public Stream partitionAggregate(Fields inputFields, ReducerAggregator agg, Fields functionFields) {
        this.projectionValidation(inputFields);
        return this.chainedAgg().partitionAggregate(inputFields, agg, functionFields).chainEnd();
    }

    public Stream aggregate(Aggregator agg, Fields functionFields) {
        return this.aggregate(null, agg, functionFields);
    }

    public Stream aggregate(Fields inputFields, Aggregator agg, Fields functionFields) {
        this.projectionValidation(inputFields);
        return this.chainedAgg().aggregate(inputFields, agg, functionFields).chainEnd();
    }

    public Stream aggregate(CombinerAggregator agg, Fields functionFields) {
        return this.aggregate(null, agg, functionFields);
    }

    public Stream aggregate(Fields inputFields, CombinerAggregator agg, Fields functionFields) {
        this.projectionValidation(inputFields);
        return this.chainedAgg().aggregate(inputFields, agg, functionFields).chainEnd();
    }

    public Stream aggregate(ReducerAggregator agg, Fields functionFields) {
        return this.aggregate(null, agg, functionFields);
    }

    public Stream aggregate(Fields inputFields, ReducerAggregator agg, Fields functionFields) {
        this.projectionValidation(inputFields);
        return this.chainedAgg().aggregate(inputFields, agg, functionFields).chainEnd();
    }

    public TridentState partitionPersist(StateFactory stateFactory, StateUpdater updater, Fields functionFields) {
        return this.partitionPersist(new StateSpec(stateFactory), updater, functionFields);
    }

    public TridentState partitionPersist(StateSpec stateSpec, StateUpdater updater, Fields functionFields) {
        return this.partitionPersist(stateSpec, null, updater, functionFields);
    }

    public TridentState partitionPersist(StateFactory stateFactory, StateUpdater updater) {
        return this.partitionPersist(stateFactory, updater, new Fields(new String[0]));
    }

    public TridentState partitionPersist(StateSpec stateSpec, StateUpdater updater) {
        return this.partitionPersist(stateSpec, updater, new Fields(new String[0]));
    }

    public TridentState persistentAggregate(StateFactory stateFactory, CombinerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(new StateSpec(stateFactory), agg, functionFields);
    }

    public TridentState persistentAggregate(StateSpec spec, CombinerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(spec, null, agg, functionFields);
    }

    public TridentState persistentAggregate(StateFactory stateFactory, Fields inputFields, CombinerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(new StateSpec(stateFactory), inputFields, agg, functionFields);
    }

    public TridentState persistentAggregate(StateSpec spec, Fields inputFields, CombinerAggregator agg, Fields functionFields) {
        this.projectionValidation(inputFields);
        return new ChainedAggregatorDeclarer(this, new GlobalAggScheme()).aggregate(inputFields, agg, functionFields).chainEnd().partitionPersist(spec, functionFields, (StateUpdater)new CombinerAggStateUpdater(agg), functionFields);
    }

    public TridentState persistentAggregate(StateFactory stateFactory, ReducerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(new StateSpec(stateFactory), agg, functionFields);
    }

    public TridentState persistentAggregate(StateSpec spec, ReducerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(spec, null, agg, functionFields);
    }

    public TridentState persistentAggregate(StateFactory stateFactory, Fields inputFields, ReducerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(new StateSpec(stateFactory), inputFields, agg, functionFields);
    }

    public TridentState persistentAggregate(StateSpec spec, Fields inputFields, ReducerAggregator agg, Fields functionFields) {
        this.projectionValidation(inputFields);
        return this.global().partitionPersist(spec, inputFields, (StateUpdater)new ReducerAggStateUpdater(agg), functionFields);
    }

    public Stream stateQuery(TridentState state, QueryFunction function, Fields functionFields) {
        return this.stateQuery(state, null, function, functionFields);
    }

    @Override
    public Stream toStream() {
        return this;
    }

    @Override
    public Fields getOutputFields() {
        return this._node.allOutputFields;
    }

    private void projectionValidation(Fields projFields) {
        if (projFields == null) {
            return;
        }
        Fields allFields = this.getOutputFields();
        for (String field : projFields) {
            if (allFields.contains(field)) continue;
            throw new IllegalArgumentException("Trying to select non-existent field: '" + field + "' from stream containing fields fields: <" + allFields + ">");
        }
    }

    static class GlobalAggScheme
    implements GlobalAggregationScheme<Stream> {
        GlobalAggScheme() {
        }

        @Override
        public IAggregatableStream aggPartition(Stream s) {
            return s.global();
        }

        @Override
        public SingleEmitAggregator.BatchToPartition singleEmitPartitioner() {
            return new GlobalBatchToPartition();
        }
    }

    static class BatchGlobalAggScheme
    implements GlobalAggregationScheme<Stream> {
        BatchGlobalAggScheme() {
        }

        @Override
        public IAggregatableStream aggPartition(Stream s) {
            return s.batchGlobal();
        }

        @Override
        public SingleEmitAggregator.BatchToPartition singleEmitPartitioner() {
            return new IndexHashBatchToPartition();
        }
    }
}

