/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift7.server;

import org.apache.thrift7.TProcessor;
import org.apache.thrift7.TProcessorFactory;
import org.apache.thrift7.protocol.TBinaryProtocol;
import org.apache.thrift7.protocol.TProtocolFactory;
import org.apache.thrift7.server.TServerEventHandler;
import org.apache.thrift7.transport.TServerTransport;
import org.apache.thrift7.transport.TTransportFactory;

public abstract class TServer {
    protected TProcessorFactory processorFactory_;
    protected TServerTransport serverTransport_;
    protected TTransportFactory inputTransportFactory_;
    protected TTransportFactory outputTransportFactory_;
    protected TProtocolFactory inputProtocolFactory_;
    protected TProtocolFactory outputProtocolFactory_;
    private boolean isServing;
    protected TServerEventHandler eventHandler_;

    protected TServer(AbstractServerArgs args) {
        this.processorFactory_ = args.processorFactory;
        this.serverTransport_ = args.serverTransport;
        this.inputTransportFactory_ = args.inputTransportFactory;
        this.outputTransportFactory_ = args.outputTransportFactory;
        this.inputProtocolFactory_ = args.inputProtocolFactory;
        this.outputProtocolFactory_ = args.outputProtocolFactory;
    }

    public abstract void serve();

    public void stop() {
    }

    public boolean isServing() {
        return this.isServing;
    }

    protected void setServing(boolean serving) {
        this.isServing = serving;
    }

    public void setServerEventHandler(TServerEventHandler eventHandler) {
        this.eventHandler_ = eventHandler;
    }

    public TServerEventHandler getEventHandler() {
        return this.eventHandler_;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractServerArgs<T extends AbstractServerArgs<T>> {
        final TServerTransport serverTransport;
        TProcessorFactory processorFactory;
        TTransportFactory inputTransportFactory = new TTransportFactory();
        TTransportFactory outputTransportFactory = new TTransportFactory();
        TProtocolFactory inputProtocolFactory = new TBinaryProtocol.Factory();
        TProtocolFactory outputProtocolFactory = new TBinaryProtocol.Factory();

        public AbstractServerArgs(TServerTransport transport) {
            this.serverTransport = transport;
        }

        public T processorFactory(TProcessorFactory factory2) {
            this.processorFactory = factory2;
            return (T)this;
        }

        public T processor(TProcessor processor) {
            this.processorFactory = new TProcessorFactory(processor);
            return (T)this;
        }

        public T transportFactory(TTransportFactory factory2) {
            this.inputTransportFactory = factory2;
            this.outputTransportFactory = factory2;
            return (T)this;
        }

        public T inputTransportFactory(TTransportFactory factory2) {
            this.inputTransportFactory = factory2;
            return (T)this;
        }

        public T outputTransportFactory(TTransportFactory factory2) {
            this.outputTransportFactory = factory2;
            return (T)this;
        }

        public T protocolFactory(TProtocolFactory factory2) {
            this.inputProtocolFactory = factory2;
            this.outputProtocolFactory = factory2;
            return (T)this;
        }

        public T inputProtocolFactory(TProtocolFactory factory2) {
            this.inputProtocolFactory = factory2;
            return (T)this;
        }

        public T outputProtocolFactory(TProtocolFactory factory2) {
            this.outputProtocolFactory = factory2;
            return (T)this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Args
    extends AbstractServerArgs<Args> {
        public Args(TServerTransport transport) {
            super(transport);
        }
    }
}

