/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift7;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.thrift7.TBase;
import org.apache.thrift7.TException;
import org.apache.thrift7.protocol.TBinaryProtocol;
import org.apache.thrift7.protocol.TProtocol;
import org.apache.thrift7.protocol.TProtocolFactory;
import org.apache.thrift7.transport.TIOStreamTransport;

public class TSerializer {
    private final ByteArrayOutputStream baos_ = new ByteArrayOutputStream();
    private final TIOStreamTransport transport_ = new TIOStreamTransport(this.baos_);
    private TProtocol protocol_;

    public TSerializer() {
        this(new TBinaryProtocol.Factory());
    }

    public TSerializer(TProtocolFactory protocolFactory) {
        this.protocol_ = protocolFactory.getProtocol(this.transport_);
    }

    public byte[] serialize(TBase base) throws TException {
        this.baos_.reset();
        base.write(this.protocol_);
        return this.baos_.toByteArray();
    }

    public String toString(TBase base, String charset2) throws TException {
        try {
            return new String(this.serialize(base), charset2);
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT ENCODING: " + charset2);
        }
    }

    public String toString(TBase base) throws TException {
        return new String(this.serialize(base));
    }
}

