/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift7;

import java.util.Collections;
import java.util.Map;
import org.apache.thrift7.ProcessFunction;
import org.apache.thrift7.TApplicationException;
import org.apache.thrift7.TBase;
import org.apache.thrift7.TException;
import org.apache.thrift7.TProcessor;
import org.apache.thrift7.protocol.TMessage;
import org.apache.thrift7.protocol.TProtocol;
import org.apache.thrift7.protocol.TProtocolUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TBaseProcessor<I>
implements TProcessor {
    private final I iface;
    private final Map<String, ProcessFunction<I, ? extends TBase>> processMap;

    protected TBaseProcessor(I iface, Map<String, ProcessFunction<I, ? extends TBase>> processFunctionMap) {
        this.iface = iface;
        this.processMap = processFunctionMap;
    }

    public Map<String, ProcessFunction<I, ? extends TBase>> getProcessMapView() {
        return Collections.unmodifiableMap(this.processMap);
    }

    @Override
    public boolean process(TProtocol in, TProtocol out) throws TException {
        TMessage msg = in.readMessageBegin();
        ProcessFunction<I, TBase> fn2 = this.processMap.get(msg.name);
        if (fn2 == null) {
            TProtocolUtil.skip(in, (byte)12);
            in.readMessageEnd();
            TApplicationException x = new TApplicationException(1, "Invalid method name: '" + msg.name + "'");
            out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
            x.write(out);
            out.writeMessageEnd();
            out.getTransport().flush();
            return true;
        }
        fn2.process(msg.seqid, in, out, this.iface);
        return true;
    }
}

