/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift7;

import java.util.Collections;
import java.util.Map;
import org.apache.thrift7.AsyncProcessFunction;
import org.apache.thrift7.TApplicationException;
import org.apache.thrift7.TBase;
import org.apache.thrift7.TException;
import org.apache.thrift7.TProcessor;
import org.apache.thrift7.protocol.TMessage;
import org.apache.thrift7.protocol.TProtocol;
import org.apache.thrift7.protocol.TProtocolException;
import org.apache.thrift7.protocol.TProtocolUtil;
import org.apache.thrift7.server.AbstractNonblockingServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TBaseAsyncProcessor<I>
implements TProcessor {
    protected final Logger LOGGER = LoggerFactory.getLogger((String)this.getClass().getName());
    final I iface;
    final Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> processMap;

    public TBaseAsyncProcessor(I iface, Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> processMap) {
        this.iface = iface;
        this.processMap = processMap;
    }

    public Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> getProcessMapView() {
        return Collections.unmodifiableMap(this.processMap);
    }

    public boolean process(AbstractNonblockingServer.AsyncFrameBuffer fb) throws TException {
        TProtocol in = fb.getInputProtocol();
        TProtocol out = fb.getOutputProtocol();
        TMessage msg = in.readMessageBegin();
        AsyncProcessFunction<I, TBase, ?> fn2 = this.processMap.get(msg.name);
        if (fn2 == null) {
            TProtocolUtil.skip(in, (byte)12);
            in.readMessageEnd();
            TApplicationException x = new TApplicationException(1, "Invalid method name: '" + msg.name + "'");
            out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
            x.write(out);
            out.writeMessageEnd();
            out.getTransport().flush();
            fb.responseReady();
            return true;
        }
        TBase args = fn2.getEmptyArgsInstance();
        try {
            args.read(in);
        }
        catch (TProtocolException e) {
            in.readMessageEnd();
            TApplicationException x = new TApplicationException(7, e.getMessage());
            out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
            x.write(out);
            out.writeMessageEnd();
            out.getTransport().flush();
            fb.responseReady();
            return true;
        }
        in.readMessageEnd();
        fn2.start(this.iface, args, fn2.getResultHandler(fb, msg.seqid));
        return true;
    }

    @Override
    public boolean process(TProtocol in, TProtocol out) throws TException {
        return false;
    }
}

