/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.yaml.snakeyaml.error;

import org.apache.storm.shade.org.yaml.snakeyaml.scanner.Constant;

public final class Mark {
    private String name;
    private int index;
    private int line;
    private int column;
    private String buffer;
    private int pointer;

    public Mark(String name, int index, int line, int column, String buffer, int pointer) {
        this.name = name;
        this.index = index;
        this.line = line;
        this.column = column;
        this.buffer = buffer;
        this.pointer = pointer;
    }

    private boolean isLineBreak(char ch) {
        return Constant.NULL_OR_LINEBR.has(ch);
    }

    public String get_snippet(int indent, int max_length) {
        int i;
        if (this.buffer == null) {
            return null;
        }
        float half = max_length / 2 - 1;
        int start2 = this.pointer;
        String head2 = "";
        while (start2 > 0 && !this.isLineBreak(this.buffer.charAt(start2 - 1))) {
            if (!((float)(this.pointer - --start2) > half)) continue;
            head2 = " ... ";
            start2 += 5;
            break;
        }
        String tail = "";
        int end2 = this.pointer;
        while (end2 < this.buffer.length() && !this.isLineBreak(this.buffer.charAt(end2))) {
            if (!((float)(++end2 - this.pointer) > half)) continue;
            tail = " ... ";
            end2 -= 5;
            break;
        }
        String snippet = this.buffer.substring(start2, end2);
        StringBuilder result2 = new StringBuilder();
        for (i = 0; i < indent; ++i) {
            result2.append(" ");
        }
        result2.append(head2);
        result2.append(snippet);
        result2.append(tail);
        result2.append("\n");
        for (i = 0; i < indent + this.pointer - start2 + head2.length(); ++i) {
            result2.append(" ");
        }
        result2.append("^");
        return result2.toString();
    }

    public String get_snippet() {
        return this.get_snippet(4, 75);
    }

    public String toString() {
        String snippet = this.get_snippet();
        StringBuilder where = new StringBuilder(" in ");
        where.append(this.name);
        where.append(", line ");
        where.append(this.line + 1);
        where.append(", column ");
        where.append(this.column + 1);
        if (snippet != null) {
            where.append(":\n");
            where.append(snippet);
        }
        return where.toString();
    }

    public String getName() {
        return this.name;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getIndex() {
        return this.index;
    }
}

