/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.graph;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import org.apache.storm.shade.org.jgrapht.Graph;
import org.apache.storm.shade.org.jgrapht.ListenableGraph;
import org.apache.storm.shade.org.jgrapht.event.GraphEdgeChangeEvent;
import org.apache.storm.shade.org.jgrapht.event.GraphListener;
import org.apache.storm.shade.org.jgrapht.event.GraphVertexChangeEvent;
import org.apache.storm.shade.org.jgrapht.event.VertexSetListener;
import org.apache.storm.shade.org.jgrapht.graph.GraphDelegator;
import org.apache.storm.shade.org.jgrapht.util.TypeUtil;

public class DefaultListenableGraph<V, E>
extends GraphDelegator<V, E>
implements ListenableGraph<V, E>,
Cloneable {
    private static final long serialVersionUID = 3977575900898471984L;
    private List<GraphListener<V, E>> graphListeners = new ArrayList<GraphListener<V, E>>();
    private List<VertexSetListener<V>> vertexSetListeners = new ArrayList<VertexSetListener<V>>();
    private FlyweightEdgeEvent<V, E> reuseableEdgeEvent;
    private FlyweightVertexEvent<V> reuseableVertexEvent;
    private boolean reuseEvents;

    public DefaultListenableGraph(Graph<V, E> g) {
        this(g, false);
    }

    public DefaultListenableGraph(Graph<V, E> g, boolean reuseEvents) {
        super(g);
        this.reuseEvents = reuseEvents;
        this.reuseableEdgeEvent = new FlyweightEdgeEvent((Object)this, -1, null);
        this.reuseableVertexEvent = new FlyweightVertexEvent<Object>((Object)this, -1, null);
        if (g instanceof ListenableGraph) {
            throw new IllegalArgumentException("base graph cannot be listenable");
        }
    }

    public void setReuseEvents(boolean reuseEvents) {
        this.reuseEvents = reuseEvents;
    }

    public boolean isReuseEvents() {
        return this.reuseEvents;
    }

    @Override
    public E addEdge(V sourceVertex, V targetVertex) {
        Object e = super.addEdge(sourceVertex, targetVertex);
        if (e != null) {
            this.fireEdgeAdded(e, sourceVertex, targetVertex);
        }
        return e;
    }

    @Override
    public boolean addEdge(V sourceVertex, V targetVertex, E e) {
        boolean added = super.addEdge(sourceVertex, targetVertex, e);
        if (added) {
            this.fireEdgeAdded(e, sourceVertex, targetVertex);
        }
        return added;
    }

    @Override
    public void addGraphListener(GraphListener<V, E> l) {
        DefaultListenableGraph.addToListenerList(this.graphListeners, l);
    }

    @Override
    public boolean addVertex(V v) {
        boolean modified = super.addVertex(v);
        if (modified) {
            this.fireVertexAdded(v);
        }
        return modified;
    }

    @Override
    public void addVertexSetListener(VertexSetListener<V> l) {
        DefaultListenableGraph.addToListenerList(this.vertexSetListeners, l);
    }

    public Object clone() {
        try {
            TypeUtil typeDecl = null;
            DefaultListenableGraph g = (DefaultListenableGraph)TypeUtil.uncheckedCast(super.clone(), typeDecl);
            g.graphListeners = new ArrayList<GraphListener<V, E>>();
            g.vertexSetListeners = new ArrayList<VertexSetListener<V>>();
            return g;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException("internal error");
        }
    }

    @Override
    public E removeEdge(V sourceVertex, V targetVertex) {
        Object e = super.removeEdge(sourceVertex, targetVertex);
        if (e != null) {
            this.fireEdgeRemoved(e, sourceVertex, targetVertex);
        }
        return e;
    }

    @Override
    public boolean removeEdge(E e) {
        Object sourceVertex = this.getEdgeSource(e);
        Object targetVertex = this.getEdgeTarget(e);
        boolean modified = super.removeEdge(e);
        if (modified) {
            this.fireEdgeRemoved(e, sourceVertex, targetVertex);
        }
        return modified;
    }

    @Override
    public void removeGraphListener(GraphListener<V, E> l) {
        this.graphListeners.remove(l);
    }

    @Override
    public boolean removeVertex(V v) {
        if (this.containsVertex(v)) {
            Set touchingEdgesList = this.edgesOf(v);
            this.removeAllEdges(new ArrayList(touchingEdgesList));
            super.removeVertex(v);
            this.fireVertexRemoved(v);
            return true;
        }
        return false;
    }

    @Override
    public void removeVertexSetListener(VertexSetListener<V> l) {
        this.vertexSetListeners.remove(l);
    }

    protected void fireEdgeAdded(E edge, V source, V target) {
        GraphEdgeChangeEvent<V, E> e = this.createGraphEdgeChangeEvent(23, edge, source, target);
        for (GraphListener<V, E> l : this.graphListeners) {
            l.edgeAdded(e);
        }
    }

    protected void fireEdgeRemoved(E edge, V source, V target) {
        GraphEdgeChangeEvent<V, E> e = this.createGraphEdgeChangeEvent(24, edge, source, target);
        for (GraphListener<V, E> l : this.graphListeners) {
            l.edgeRemoved(e);
        }
    }

    protected void fireVertexAdded(V vertex) {
        GraphVertexChangeEvent<V> e = this.createGraphVertexChangeEvent(13, vertex);
        for (VertexSetListener<V> vertexSetListener : this.vertexSetListeners) {
            vertexSetListener.vertexAdded(e);
        }
        for (GraphListener graphListener : this.graphListeners) {
            graphListener.vertexAdded(e);
        }
    }

    protected void fireVertexRemoved(V vertex) {
        GraphVertexChangeEvent<V> e = this.createGraphVertexChangeEvent(14, vertex);
        for (VertexSetListener<V> vertexSetListener : this.vertexSetListeners) {
            vertexSetListener.vertexRemoved(e);
        }
        for (GraphListener graphListener : this.graphListeners) {
            graphListener.vertexRemoved(e);
        }
    }

    private static <L extends EventListener> void addToListenerList(List<L> list2, L l) {
        if (!list2.contains(l)) {
            list2.add(l);
        }
    }

    private GraphEdgeChangeEvent<V, E> createGraphEdgeChangeEvent(int eventType, E edge, V source, V target) {
        if (this.reuseEvents) {
            this.reuseableEdgeEvent.setType(eventType);
            this.reuseableEdgeEvent.setEdge(edge);
            this.reuseableEdgeEvent.setEdgeSource(source);
            this.reuseableEdgeEvent.setEdgeTarget(target);
            return this.reuseableEdgeEvent;
        }
        return new GraphEdgeChangeEvent<V, E>(this, eventType, edge, source, target);
    }

    private GraphVertexChangeEvent<V> createGraphVertexChangeEvent(int eventType, V vertex) {
        if (this.reuseEvents) {
            this.reuseableVertexEvent.setType(eventType);
            this.reuseableVertexEvent.setVertex(vertex);
            return this.reuseableVertexEvent;
        }
        return new GraphVertexChangeEvent<V>(this, eventType, vertex);
    }

    private static class FlyweightVertexEvent<VV>
    extends GraphVertexChangeEvent<VV> {
        private static final long serialVersionUID = 3257848787857585716L;

        public FlyweightVertexEvent(Object eventSource, int type, VV vertex) {
            super(eventSource, type, vertex);
        }

        protected void setType(int type) {
            this.type = type;
        }

        protected void setVertex(VV vertex) {
            this.vertex = vertex;
        }
    }

    private static class FlyweightEdgeEvent<VV, EE>
    extends GraphEdgeChangeEvent<VV, EE> {
        private static final long serialVersionUID = 3907207152526636089L;

        public FlyweightEdgeEvent(Object eventSource, int type, EE e) {
            super(eventSource, type, e);
        }

        protected void setEdge(EE e) {
            this.edge = e;
        }

        protected void setEdgeSource(VV v) {
            this.edgeSource = v;
        }

        protected void setEdgeTarget(VV v) {
            this.edgeTarget = v;
        }

        protected void setType(int type) {
            this.type = type;
        }
    }
}

