/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.experimental.permutation;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.storm.shade.org.jgrapht.experimental.permutation.ArrayPermutationsIter;

public class IntegerPermutationIter
implements Iterator,
ArrayPermutationsIter {
    private int[] Value;
    private int N;
    private long permutationCounter;
    private boolean endWasReached = false;
    private boolean wasNextValueCalculatedAlready = false;
    private int[] currentValueBackup;

    public IntegerPermutationIter(int N) {
        int[] newArray = new int[N];
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = i;
        }
        this.init(newArray);
    }

    public IntegerPermutationIter(int[] array) {
        int[] newArray = new int[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        Arrays.sort(newArray);
        this.init(newArray);
    }

    private void init(int[] array) {
        this.N = array.length;
        this.Value = array;
        this.currentValueBackup = this.Value;
        this.permutationCounter = 0L;
    }

    private void swap(int i, int j) {
        int temp = this.Value[i];
        this.Value[i] = this.Value[j];
        this.Value[j] = temp;
    }

    private int[] arrayClone(int[] sourceArray) {
        int[] destArray = new int[sourceArray.length];
        System.arraycopy(sourceArray, 0, destArray, 0, sourceArray.length);
        return destArray;
    }

    private int[] getNextStartingWith2() {
        ++this.permutationCounter;
        int i = this.N - 1;
        if (i <= 0) {
            this.endWasReached = true;
            return null;
        }
        while (this.Value[i - 1] >= this.Value[i]) {
            if (--i != 0) continue;
            this.endWasReached = true;
            return null;
        }
        int j = this.N;
        while (this.Value[j - 1] <= this.Value[i - 1]) {
            --j;
        }
        this.swap(i - 1, j - 1);
        ++i;
        for (j = this.N; i < j; ++i, --j) {
            this.swap(i - 1, j - 1);
        }
        return this.Value;
    }

    @Override
    public boolean hasNext() {
        if (this.permutationCounter == 0L || this.wasNextValueCalculatedAlready) {
            return true;
        }
        if (this.endWasReached) {
            return false;
        }
        boolean result2 = true;
        this.getNextStartingWith2();
        this.wasNextValueCalculatedAlready = true;
        if (this.endWasReached) {
            return false;
        }
        return result2;
    }

    public Object next() {
        return this.getNext();
    }

    public int[] getNext() {
        int[] internalArray;
        if (!this.hasNext()) {
            throw new RuntimeException("IntegerPermutationIter exceeds the total number of permutaions. Suggestion: do a check with hasNext() , or count till getTotalNumberOfPermutations before using getNext()");
        }
        if (this.permutationCounter == 0L) {
            ++this.permutationCounter;
            internalArray = this.Value;
        } else if (this.wasNextValueCalculatedAlready) {
            internalArray = this.Value;
            this.wasNextValueCalculatedAlready = false;
        } else {
            internalArray = this.getNextStartingWith2();
            if (this.endWasReached) {
                return null;
            }
        }
        this.currentValueBackup = this.arrayClone(internalArray);
        return this.arrayClone(internalArray);
    }

    public int[] getCurrent() {
        return this.arrayClone(this.currentValueBackup);
    }

    public String toString(int[] array) {
        if (array.length <= 0) {
            return "[]";
        }
        StringBuffer stBuffer = new StringBuffer("[");
        for (int i = 0; i < array.length - 1; ++i) {
            stBuffer.append(array[i]).append(",");
        }
        stBuffer.append(array[array.length - 1]).append("]");
        return stBuffer.toString();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] nextPermutation() {
        return (int[])this.next();
    }

    @Override
    public boolean hasNextPermutaions() {
        return this.hasNext();
    }
}

