/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.experimental.isomorphism;

import java.util.Arrays;
import java.util.Set;
import org.apache.storm.shade.org.jgrapht.Graph;
import org.apache.storm.shade.org.jgrapht.experimental.equivalence.EquivalenceComparator;
import org.apache.storm.shade.org.jgrapht.experimental.equivalence.EquivalenceSet;
import org.apache.storm.shade.org.jgrapht.experimental.equivalence.EquivalenceSetCreator;
import org.apache.storm.shade.org.jgrapht.experimental.isomorphism.AbstractExhaustiveIsomorphismInspector;
import org.apache.storm.shade.org.jgrapht.experimental.permutation.ArrayPermutationsIter;
import org.apache.storm.shade.org.jgrapht.experimental.permutation.CollectionPermutationIter;
import org.apache.storm.shade.org.jgrapht.experimental.permutation.PermutationFactory;

class EquivalenceIsomorphismInspector<V, E>
extends AbstractExhaustiveIsomorphismInspector<V, E> {
    public EquivalenceIsomorphismInspector(Graph<V, E> graph1, Graph<V, E> graph2, EquivalenceComparator<? super V, ? super Graph<? super V, ? super E>> vertexChecker, EquivalenceComparator<? super E, ? super Graph<? super V, ? super E>> edgeChecker) {
        super(graph1, graph2, vertexChecker, edgeChecker);
    }

    public EquivalenceIsomorphismInspector(Graph<V, E> graph1, Graph<V, E> graph2) {
        super(graph1, graph2);
    }

    @Override
    protected CollectionPermutationIter<V> createPermutationIterator(Set<V> vertexSet1, Set<V> vertexSet2) {
        EquivalenceSet[] eqGroupArray2;
        if (vertexSet1.size() != vertexSet2.size()) {
            return null;
        }
        EquivalenceSet[] eqGroupArray1 = EquivalenceSetCreator.createEqualityGroupOrderedArray(vertexSet1, this.vertexComparator, this.graph1);
        boolean reorderSuccess = this.reorderTargetArrayToMatchSourceOrder(eqGroupArray1, eqGroupArray2 = EquivalenceSetCreator.createEqualityGroupOrderedArray(vertexSet2, this.vertexComparator, this.graph2));
        if (!reorderSuccess) {
            return null;
        }
        Object[] reorderingVertexSet1Temp = new Object[vertexSet1.size()];
        this.fillElementsflatArray(eqGroupArray1, reorderingVertexSet1Temp);
        vertexSet1.clear();
        vertexSet1.addAll(Arrays.asList(reorderingVertexSet1Temp));
        Object[] flatVertexArray = new Object[vertexSet2.size()];
        this.fillElementsflatArray(eqGroupArray2, flatVertexArray);
        int[] groupSizesArray = new int[eqGroupArray1.length];
        for (int eqGroupCounter = 0; eqGroupCounter < eqGroupArray2.length; ++eqGroupCounter) {
            groupSizesArray[eqGroupCounter] = eqGroupArray2[eqGroupCounter].size();
        }
        ArrayPermutationsIter arrayPermIter = PermutationFactory.createByGroups(groupSizesArray);
        CollectionPermutationIter<Object> vertexPermIter = new CollectionPermutationIter<Object>(Arrays.asList(flatVertexArray), arrayPermIter);
        return vertexPermIter;
    }

    private boolean reorderTargetArrayToMatchSourceOrder(EquivalenceSet[] sourceArray, EquivalenceSet[] targetArray) {
        boolean result2 = true;
        for (int sourceIndex = 0; sourceIndex < sourceArray.length; ++sourceIndex) {
            EquivalenceSet sourceEqGroup = sourceArray[sourceIndex];
            int currTargetIndex = sourceIndex;
            EquivalenceSet targetEqGroup = targetArray[currTargetIndex];
            if (sourceEqGroup.equals(targetEqGroup)) continue;
            boolean foundMatch = false;
            int sourceSize = sourceEqGroup.size();
            int sourceHashCode = sourceEqGroup.hashCode();
            while (targetEqGroup.size() == sourceSize && targetEqGroup.hashCode() == sourceHashCode && currTargetIndex < targetArray.length - 1) {
                if (!(targetEqGroup = targetArray[++currTargetIndex]).equals(sourceEqGroup)) continue;
                foundMatch = true;
                targetArray[currTargetIndex] = targetArray[sourceIndex];
                targetArray[sourceIndex] = targetEqGroup;
            }
            if (foundMatch) continue;
            result2 = false;
            break;
        }
        return result2;
    }

    protected void fillElementsflatArray(EquivalenceSet[] eqGroupArray, Object[] flatVertexArray) {
        int flatVertexArrayNextFree = 0;
        for (int eqGroupCounter = 0; eqGroupCounter < eqGroupArray.length; ++eqGroupCounter) {
            Object[] currGroupArray = eqGroupArray[eqGroupCounter].toArray();
            System.arraycopy(currGroupArray, 0, flatVertexArray, flatVertexArrayNextFree, currGroupArray.length);
            flatVertexArrayNextFree += currGroupArray.length;
        }
    }

    @Override
    protected boolean areVertexSetsOfTheSameEqualityGroup(Set vertexSet1, Set vertexSet2) {
        return true;
    }
}

