/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.experimental.equivalence;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.storm.shade.org.jgrapht.experimental.equivalence.EquivalenceComparator;
import org.apache.storm.shade.org.jgrapht.experimental.equivalence.EquivalenceComparatorChain;

public class EquivalenceComparatorChainBase<E, C>
implements EquivalenceComparatorChain<E, C> {
    private List<EquivalenceComparator<? super E, ? super C>> chain = new LinkedList<EquivalenceComparator<? super E, ? super C>>();

    public EquivalenceComparatorChainBase(EquivalenceComparator<E, C> firstComaparator) {
        this.chain.add(firstComaparator);
    }

    @Override
    public void appendComparator(EquivalenceComparator comparatorAfter) {
        if (comparatorAfter != null) {
            this.chain.add(comparatorAfter);
        }
    }

    @Override
    public boolean equivalenceCompare(E arg1, E arg2, C context1, C context2) {
        for (EquivalenceComparator<E, C> currentComparator : this.chain) {
            if (currentComparator.equivalenceCompare(arg1, arg2, context1, context2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int equivalenceHashcode(E arg1, C context2) {
        StringBuffer hashStringBuffer = new StringBuffer();
        ListIterator<EquivalenceComparator<E, C>> iter = this.chain.listIterator();
        while (iter.hasNext()) {
            EquivalenceComparator<E, C> currentComparator = iter.next();
            int currentHashCode = currentComparator.equivalenceHashcode(arg1, context2);
            hashStringBuffer.append(currentHashCode);
            if (!iter.hasNext()) continue;
            hashStringBuffer.append('+');
        }
        return hashStringBuffer.toString().hashCode();
    }
}

