/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.experimental;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.shade.org.jgrapht.Graph;
import org.apache.storm.shade.org.jgrapht.VertexFactory;
import org.apache.storm.shade.org.jgrapht.WeightedGraph;
import org.apache.storm.shade.org.jgrapht.generate.GraphGenerator;

public class GraphReader<V, E>
implements GraphGenerator<V, E, V> {
    private final BufferedReader _in;
    private final boolean _isWeighted;
    private final double _defaultWeight;

    private GraphReader(Reader input, boolean isWeighted, double defaultWeight) throws IOException {
        this._in = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        this._isWeighted = isWeighted;
        this._defaultWeight = defaultWeight;
    }

    public GraphReader(Reader input) throws IOException {
        this(input, false, 1.0);
    }

    public GraphReader(Reader input, double defaultWeight) throws IOException {
        this(input, true, defaultWeight);
    }

    private String[] split(String src) {
        if (src == null) {
            return null;
        }
        return src.split("\\s+");
    }

    private String[] skipComments() {
        String[] cols = null;
        try {
            cols = this.split(this._in.readLine());
            while (cols != null && (cols.length == 0 || cols[0].equals("c") || cols[0].startsWith("%"))) {
                cols = this.split(this._in.readLine());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cols;
    }

    private int readNodeCount() {
        String[] cols = this.skipComments();
        if (cols[0].equals("p")) {
            return Integer.parseInt(cols[1]);
        }
        return -1;
    }

    @Override
    public void generateGraph(Graph<V, E> target, VertexFactory<V> vertexFactory, Map<String, V> resultMap) {
        int size = this.readNodeCount();
        if (resultMap == null) {
            resultMap = new HashMap<String, V>();
        }
        for (int i = 0; i < size; ++i) {
            V newVertex = vertexFactory.createVertex();
            target.addVertex(newVertex);
            resultMap.put(Integer.toString(i + 1), newVertex);
        }
        String[] cols = this.skipComments();
        while (cols != null) {
            if (cols[0].equals("e")) {
                E edge = target.addEdge(resultMap.get(cols[1]), resultMap.get(cols[2]));
                if (this._isWeighted && edge != null) {
                    double weight = this._defaultWeight;
                    if (cols.length > 3) {
                        weight = Double.parseDouble(cols[3]);
                    }
                    ((WeightedGraph)target).setEdgeWeight(edge, weight);
                }
            }
            cols = this.skipComments();
        }
    }
}

