/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.alg.cycle;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.storm.shade.org.jgrapht.UndirectedGraph;
import org.apache.storm.shade.org.jgrapht.alg.cycle.UndirectedCycleBase;

public class PatonCycleBase<V, E>
implements UndirectedCycleBase<V, E> {
    private UndirectedGraph<V, E> graph;

    public PatonCycleBase() {
    }

    public PatonCycleBase(UndirectedGraph<V, E> graph2) {
        if (graph2 == null) {
            throw new IllegalArgumentException("Null graph argument.");
        }
        this.graph = graph2;
    }

    @Override
    public UndirectedGraph<V, E> getGraph() {
        return this.graph;
    }

    @Override
    public void setGraph(UndirectedGraph<V, E> graph2) {
        if (graph2 == null) {
            throw new IllegalArgumentException("Null graph argument.");
        }
        this.graph = graph2;
    }

    @Override
    public List<List<V>> findCycleBase() {
        if (this.graph == null) {
            throw new IllegalArgumentException("Null graph.");
        }
        HashMap used = new HashMap();
        HashMap parent = new HashMap();
        ArrayDeque stack = new ArrayDeque();
        ArrayList<List<V>> cycles = new ArrayList<List<V>>();
        for (Object root : this.graph.vertexSet()) {
            if (parent.containsKey(root)) continue;
            used.clear();
            parent.put(root, root);
            used.put(root, new HashSet());
            stack.push(root);
            while (!stack.isEmpty()) {
                Object current = stack.pop();
                Set currentUsed = (Set)used.get(current);
                for (Object e : this.graph.edgesOf(current)) {
                    Set neighbourUsed;
                    Object neighbor = this.graph.getEdgeTarget(e);
                    if (neighbor.equals(current)) {
                        neighbor = this.graph.getEdgeSource(e);
                    }
                    if (!used.containsKey(neighbor)) {
                        parent.put(neighbor, current);
                        neighbourUsed = new HashSet();
                        neighbourUsed.add(current);
                        used.put(neighbor, neighbourUsed);
                        stack.push(neighbor);
                        continue;
                    }
                    if (neighbor.equals(current)) {
                        ArrayList cycle = new ArrayList();
                        cycle.add(current);
                        cycles.add(cycle);
                        continue;
                    }
                    if (currentUsed.contains(neighbor)) continue;
                    neighbourUsed = (Set)used.get(neighbor);
                    ArrayList<Object> cycle = new ArrayList<Object>();
                    cycle.add(neighbor);
                    cycle.add(current);
                    Object p = parent.get(current);
                    while (!neighbourUsed.contains(p)) {
                        cycle.add(p);
                        p = parent.get(p);
                    }
                    cycle.add(p);
                    cycles.add(cycle);
                    neighbourUsed.add(current);
                }
            }
        }
        return cycles;
    }
}

