/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.alg;

import java.util.ArrayList;
import java.util.List;
import org.apache.storm.shade.org.jgrapht.Graph;
import org.apache.storm.shade.org.jgrapht.GraphPath;
import org.apache.storm.shade.org.jgrapht.alg.KShortestPathsIterator;
import org.apache.storm.shade.org.jgrapht.alg.RankingPathElement;
import org.apache.storm.shade.org.jgrapht.alg.RankingPathElementList;

public class KShortestPaths<V, E> {
    private Graph<V, E> graph;
    private int nMaxHops;
    private int nPaths;
    private V startVertex;

    public KShortestPaths(Graph<V, E> graph2, V startVertex, int k) {
        this(graph2, startVertex, k, graph2.vertexSet().size() - 1);
    }

    public KShortestPaths(Graph<V, E> graph2, V startVertex, int nPaths, int nMaxHops) {
        this.assertKShortestPathsFinder(graph2, startVertex, nPaths, nMaxHops);
        this.graph = graph2;
        this.startVertex = startVertex;
        this.nPaths = nPaths;
        this.nMaxHops = nMaxHops;
    }

    public List<GraphPath<V, E>> getPaths(V endVertex) {
        this.assertGetPaths(endVertex);
        KShortestPathsIterator<V, E> iter = new KShortestPathsIterator<V, E>(this.graph, this.startVertex, endVertex, this.nPaths);
        for (int passNumber = 1; passNumber <= this.nMaxHops && iter.hasNext(); ++passNumber) {
            iter.next();
        }
        RankingPathElementList<V, E> list2 = iter.getPathElements(endVertex);
        if (list2 == null) {
            return null;
        }
        ArrayList<GraphPath<V, PathWrapper>> pathList = new ArrayList<GraphPath<V, PathWrapper>>();
        for (RankingPathElement rankingPathElement : list2) {
            pathList.add(new PathWrapper(rankingPathElement));
        }
        return pathList;
    }

    private void assertGetPaths(V endVertex) {
        if (endVertex == null) {
            throw new NullPointerException("endVertex is null");
        }
        if (endVertex.equals(this.startVertex)) {
            throw new IllegalArgumentException("The end vertex is the same as the start vertex!");
        }
        if (!this.graph.vertexSet().contains(endVertex)) {
            throw new IllegalArgumentException("Graph must contain the end vertex!");
        }
    }

    private void assertKShortestPathsFinder(Graph<V, E> graph2, V startVertex, int nPaths, int nMaxHops) {
        if (graph2 == null) {
            throw new NullPointerException("graph is null");
        }
        if (startVertex == null) {
            throw new NullPointerException("startVertex is null");
        }
        if (nPaths <= 0) {
            throw new NullPointerException("nPaths is negative or 0");
        }
        if (nMaxHops <= 0) {
            throw new NullPointerException("nMaxHops is negative or 0");
        }
    }

    private class PathWrapper
    implements GraphPath<V, E> {
        private RankingPathElement<V, E> rankingPathElement;
        private List<E> edgeList;

        PathWrapper(RankingPathElement<V, E> rankingPathElement) {
            this.rankingPathElement = rankingPathElement;
        }

        @Override
        public Graph<V, E> getGraph() {
            return KShortestPaths.this.graph;
        }

        @Override
        public V getStartVertex() {
            return KShortestPaths.this.startVertex;
        }

        @Override
        public V getEndVertex() {
            return this.rankingPathElement.getVertex();
        }

        @Override
        public List<E> getEdgeList() {
            if (this.edgeList == null) {
                this.edgeList = this.rankingPathElement.createEdgeListPath();
            }
            return this.edgeList;
        }

        @Override
        public double getWeight() {
            return this.rankingPathElement.getWeight();
        }

        public String toString() {
            return this.getEdgeList().toString();
        }
    }
}

