/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jboss.netty.util.internal;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.storm.shade.org.jboss.netty.util.DebugUtil;

public final class StackTraceSimplifier {
    private static final boolean SIMPLIFY_STACK_TRACE = !DebugUtil.isDebugEnabled();
    private static final Pattern EXCLUDED_STACK_TRACE = Pattern.compile("^org\\.jboss\\.netty\\.(util\\.(ThreadRenamingRunnable|internal\\.DeadLockProofWorker)|channel\\.(SimpleChannel(Upstream|Downstream)?Handler|(Default|Static)ChannelPipeline.*))(\\$.*)?$");

    public static void simplify(Throwable e) {
        StackTraceElement[] trace2;
        if (!SIMPLIFY_STACK_TRACE) {
            return;
        }
        if (e.getCause() != null) {
            StackTraceSimplifier.simplify(e.getCause());
        }
        if ((trace2 = e.getStackTrace()) == null || trace2.length == 0) {
            return;
        }
        if (EXCLUDED_STACK_TRACE.matcher(trace2[0].getClassName()).matches()) {
            return;
        }
        ArrayList<StackTraceElement> simpleTrace = new ArrayList<StackTraceElement>(trace2.length);
        simpleTrace.add(trace2[0]);
        for (int i = 1; i < trace2.length; ++i) {
            if (EXCLUDED_STACK_TRACE.matcher(trace2[i].getClassName()).matches()) continue;
            simpleTrace.add(trace2[i]);
        }
        e.setStackTrace(simpleTrace.toArray(new StackTraceElement[simpleTrace.size()]));
    }

    private StackTraceSimplifier() {
    }
}

