/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jboss.netty.handler.stream;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.storm.shade.org.jboss.netty.buffer.ChannelBuffers;
import org.apache.storm.shade.org.jboss.netty.handler.stream.ChunkedInput;

public class ChunkedFile
implements ChunkedInput {
    private final RandomAccessFile file;
    private final long startOffset;
    private final long endOffset;
    private final int chunkSize;
    private long offset;

    public ChunkedFile(File file2) throws IOException {
        this(file2, 8192);
    }

    public ChunkedFile(File file2, int chunkSize) throws IOException {
        this(new RandomAccessFile(file2, "r"), chunkSize);
    }

    public ChunkedFile(RandomAccessFile file2) throws IOException {
        this(file2, 8192);
    }

    public ChunkedFile(RandomAccessFile file2, int chunkSize) throws IOException {
        this(file2, 0L, file2.length(), chunkSize);
    }

    public ChunkedFile(RandomAccessFile file2, long offset, long length, int chunkSize) throws IOException {
        if (file2 == null) {
            throw new NullPointerException("file");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("offset: " + offset + " (expected: 0 or greater)");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length: " + length + " (expected: 0 or greater)");
        }
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize: " + chunkSize + " (expected: a positive integer)");
        }
        this.file = file2;
        this.offset = this.startOffset = offset;
        this.endOffset = offset + length;
        this.chunkSize = chunkSize;
        file2.seek(offset);
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public long getEndOffset() {
        return this.endOffset;
    }

    public long getCurrentOffset() {
        return this.offset;
    }

    public boolean hasNextChunk() throws Exception {
        return this.offset < this.endOffset && this.file.getChannel().isOpen();
    }

    public boolean isEndOfInput() throws Exception {
        return !this.hasNextChunk();
    }

    public void close() throws Exception {
        this.file.close();
    }

    public Object nextChunk() throws Exception {
        long offset = this.offset;
        if (offset >= this.endOffset) {
            return null;
        }
        int chunkSize = (int)Math.min((long)this.chunkSize, this.endOffset - offset);
        byte[] chunk = new byte[chunkSize];
        this.file.readFully(chunk);
        this.offset = offset + (long)chunkSize;
        return ChannelBuffers.wrappedBuffer(chunk);
    }
}

