/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jboss.netty.handler.ssl;

import java.nio.ByteBuffer;

public class SslBufferPool {
    private static final int MAX_PACKET_SIZE = 18713;
    private static final int DEFAULT_POOL_SIZE = 19162112;
    private final ByteBuffer[] pool;
    private final int maxBufferCount;
    private int index;

    public SslBufferPool() {
        this(19162112);
    }

    public SslBufferPool(int maxPoolSize) {
        if (maxPoolSize <= 0) {
            throw new IllegalArgumentException("maxPoolSize: " + maxPoolSize);
        }
        int maxBufferCount = maxPoolSize / 18713;
        if (maxPoolSize % 18713 != 0) {
            ++maxBufferCount;
        }
        this.pool = new ByteBuffer[maxBufferCount];
        this.maxBufferCount = maxBufferCount;
    }

    public int getMaxPoolSize() {
        return this.maxBufferCount * 18713;
    }

    public synchronized int getUnacquiredPoolSize() {
        return this.index * 18713;
    }

    public synchronized ByteBuffer acquireBuffer() {
        if (this.index == 0) {
            return ByteBuffer.allocate(18713);
        }
        return (ByteBuffer)this.pool[--this.index].clear();
    }

    @Deprecated
    ByteBuffer acquire() {
        return this.acquireBuffer();
    }

    public synchronized void releaseBuffer(ByteBuffer buffer) {
        if (this.index < this.maxBufferCount) {
            this.pool[this.index++] = buffer;
        }
    }

    @Deprecated
    void release(ByteBuffer buffer) {
        this.releaseBuffer(buffer);
    }
}

