/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jboss.netty.handler.ipfilter;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.storm.shade.org.jboss.netty.handler.ipfilter.CIDR;
import org.apache.storm.shade.org.jboss.netty.handler.ipfilter.IpSet;
import org.apache.storm.shade.org.jboss.netty.logging.InternalLogger;
import org.apache.storm.shade.org.jboss.netty.logging.InternalLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IpSubnet
implements IpSet,
Comparable<IpSubnet> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(IpSubnet.class);
    private final CIDR cidr;

    public IpSubnet() {
        this.cidr = null;
    }

    public IpSubnet(String netAddress) throws UnknownHostException {
        this.cidr = CIDR.newCIDR(netAddress);
    }

    public IpSubnet(InetAddress inetAddress, int cidrNetMask) throws UnknownHostException {
        this.cidr = CIDR.newCIDR(inetAddress, cidrNetMask);
    }

    public IpSubnet(InetAddress inetAddress, String netMask) throws UnknownHostException {
        this.cidr = CIDR.newCIDR(inetAddress, netMask);
    }

    public boolean contains(String ipAddr) throws UnknownHostException {
        InetAddress inetAddress1 = InetAddress.getByName(ipAddr);
        return this.contains(inetAddress1);
    }

    @Override
    public boolean contains(InetAddress inetAddress) {
        if (this.cidr == null) {
            return true;
        }
        return this.cidr.contains(inetAddress);
    }

    public String toString() {
        return this.cidr.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof IpSubnet)) {
            return false;
        }
        IpSubnet ipSubnet = (IpSubnet)o;
        return ipSubnet.cidr.equals(this.cidr);
    }

    public int hashCode() {
        return this.cidr.hashCode();
    }

    @Override
    public int compareTo(IpSubnet o) {
        return this.cidr.toString().compareTo(o.cidr.toString());
    }
}

