/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jboss.netty.handler.execution;

import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.storm.shade.org.jboss.netty.channel.Channel;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelEvent;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelState;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelStateEvent;
import org.apache.storm.shade.org.jboss.netty.handler.execution.ChannelEventRunnable;
import org.apache.storm.shade.org.jboss.netty.handler.execution.MemoryAwareThreadPoolExecutor;
import org.apache.storm.shade.org.jboss.netty.util.ObjectSizeEstimator;
import org.apache.storm.shade.org.jboss.netty.util.internal.ConcurrentIdentityWeakKeyHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedMemoryAwareThreadPoolExecutor
extends MemoryAwareThreadPoolExecutor {
    protected final ConcurrentMap<Object, Executor> childExecutors = this.newChildExecutorMap();

    public OrderedMemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize) {
        super(corePoolSize, maxChannelMemorySize, maxTotalMemorySize);
    }

    public OrderedMemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, long keepAliveTime, TimeUnit unit) {
        super(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, keepAliveTime, unit);
    }

    public OrderedMemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        super(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, keepAliveTime, unit, threadFactory);
    }

    public OrderedMemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, long keepAliveTime, TimeUnit unit, ObjectSizeEstimator objectSizeEstimator, ThreadFactory threadFactory) {
        super(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, keepAliveTime, unit, objectSizeEstimator, threadFactory);
    }

    protected ConcurrentMap<Object, Executor> newChildExecutorMap() {
        return new ConcurrentIdentityWeakKeyHashMap<Object, Executor>();
    }

    protected Object getChildExecutorKey(ChannelEvent e) {
        return e.getChannel();
    }

    protected Set<Object> getChildExecutorKeySet() {
        return this.childExecutors.keySet();
    }

    protected boolean removeChildExecutor(Object key) {
        return this.childExecutors.remove(key) != null;
    }

    @Override
    protected void doExecute(Runnable task2) {
        if (!(task2 instanceof ChannelEventRunnable)) {
            this.doUnorderedExecute(task2);
        } else {
            ChannelEventRunnable r = (ChannelEventRunnable)task2;
            this.getChildExecutor(r.getEvent()).execute(task2);
        }
    }

    protected Executor getChildExecutor(ChannelEvent e) {
        Executor oldExecutor;
        Object key = this.getChildExecutorKey(e);
        Executor executor2 = (Executor)this.childExecutors.get(key);
        if (executor2 == null && (oldExecutor = this.childExecutors.putIfAbsent(key, executor2 = new ChildExecutor())) != null) {
            executor2 = oldExecutor;
        }
        if (e instanceof ChannelStateEvent) {
            Channel channel = e.getChannel();
            ChannelStateEvent se = (ChannelStateEvent)e;
            if (se.getState() == ChannelState.OPEN && !channel.isOpen()) {
                this.removeChildExecutor(key);
            }
        }
        return executor2;
    }

    @Override
    protected boolean shouldCount(Runnable task2) {
        if (task2 instanceof ChildExecutor) {
            return false;
        }
        return super.shouldCount(task2);
    }

    void onAfterExecute(Runnable r, Throwable t) {
        this.afterExecute(r, t);
    }

    protected final class ChildExecutor
    implements Executor,
    Runnable {
        private final Queue<Runnable> tasks = new ConcurrentLinkedQueue<Runnable>();
        private final AtomicBoolean isRunning = new AtomicBoolean();

        protected ChildExecutor() {
        }

        public void execute(Runnable command) {
            this.tasks.add(command);
            if (!this.isRunning.get()) {
                OrderedMemoryAwareThreadPoolExecutor.this.doUnorderedExecute(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.isRunning.compareAndSet(false, true)) {
                boolean acquired = true;
                try {
                    Runnable task2;
                    Thread thread = Thread.currentThread();
                    while ((task2 = this.tasks.poll()) != null) {
                        boolean ran = false;
                        OrderedMemoryAwareThreadPoolExecutor.this.beforeExecute(thread, task2);
                        try {
                            task2.run();
                            ran = true;
                            OrderedMemoryAwareThreadPoolExecutor.this.onAfterExecute(task2, null);
                        }
                        catch (RuntimeException e) {
                            if (!ran) {
                                OrderedMemoryAwareThreadPoolExecutor.this.onAfterExecute(task2, e);
                            }
                            throw e;
                        }
                    }
                    Object var7_6 = null;
                    this.isRunning.set(false);
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    this.isRunning.set(false);
                    throw throwable;
                }
                if (acquired && !this.isRunning.get() && this.tasks.peek() != null) {
                    OrderedMemoryAwareThreadPoolExecutor.this.doUnorderedExecute(this);
                }
            }
        }
    }
}

