/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jboss.netty.handler.execution;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.storm.shade.org.jboss.netty.channel.Channel;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelEvent;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelState;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelStateEvent;
import org.apache.storm.shade.org.jboss.netty.channel.Channels;
import org.apache.storm.shade.org.jboss.netty.channel.WriteCompletionEvent;
import org.apache.storm.shade.org.jboss.netty.handler.execution.ChannelDownstreamEventRunnable;
import org.apache.storm.shade.org.jboss.netty.handler.execution.ChannelEventRunnable;
import org.apache.storm.shade.org.jboss.netty.handler.execution.ChannelUpstreamEventRunnable;
import org.apache.storm.shade.org.jboss.netty.handler.execution.ExecutionHandler;
import org.apache.storm.shade.org.jboss.netty.logging.InternalLogger;
import org.apache.storm.shade.org.jboss.netty.logging.InternalLoggerFactory;
import org.apache.storm.shade.org.jboss.netty.util.DefaultObjectSizeEstimator;
import org.apache.storm.shade.org.jboss.netty.util.ObjectSizeEstimator;
import org.apache.storm.shade.org.jboss.netty.util.internal.ConcurrentIdentityHashMap;
import org.apache.storm.shade.org.jboss.netty.util.internal.SharedResourceMisuseDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryAwareThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MemoryAwareThreadPoolExecutor.class);
    private static final SharedResourceMisuseDetector misuseDetector = new SharedResourceMisuseDetector(MemoryAwareThreadPoolExecutor.class);
    private volatile Settings settings;
    private final ConcurrentMap<Channel, AtomicLong> channelCounters = new ConcurrentIdentityHashMap<Channel, AtomicLong>();
    private final Limiter totalLimiter;
    private volatile boolean notifyOnShutdown;

    public MemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize) {
        this(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, 30L, TimeUnit.SECONDS);
    }

    public MemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, long keepAliveTime, TimeUnit unit) {
        this(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, keepAliveTime, unit, Executors.defaultThreadFactory());
    }

    public MemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        this(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, keepAliveTime, unit, new DefaultObjectSizeEstimator(), threadFactory);
    }

    public MemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, long keepAliveTime, TimeUnit unit, ObjectSizeEstimator objectSizeEstimator, ThreadFactory threadFactory) {
        super(corePoolSize, corePoolSize, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>(), threadFactory, new NewThreadRunsPolicy());
        if (objectSizeEstimator == null) {
            throw new NullPointerException("objectSizeEstimator");
        }
        if (maxChannelMemorySize < 0L) {
            throw new IllegalArgumentException("maxChannelMemorySize: " + maxChannelMemorySize);
        }
        if (maxTotalMemorySize < 0L) {
            throw new IllegalArgumentException("maxTotalMemorySize: " + maxTotalMemorySize);
        }
        try {
            Method m = this.getClass().getMethod("allowCoreThreadTimeOut", Boolean.TYPE);
            m.invoke((Object)this, Boolean.TRUE);
        }
        catch (Throwable t) {
            logger.debug("ThreadPoolExecutor.allowCoreThreadTimeOut() is not supported in this platform.");
        }
        this.settings = new Settings(objectSizeEstimator, maxChannelMemorySize);
        this.totalLimiter = maxTotalMemorySize == 0L ? null : new Limiter(maxTotalMemorySize);
        misuseDetector.increase();
    }

    @Override
    protected void terminated() {
        super.terminated();
        misuseDetector.decrease();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.shutdownNow(this.notifyOnShutdown);
    }

    public List<Runnable> shutdownNow(boolean notify) {
        if (!notify) {
            return super.shutdownNow();
        }
        IOException cause = null;
        HashSet<Channel> channels = null;
        List<Runnable> tasks = super.shutdownNow();
        for (Runnable task2 : tasks) {
            if (!(task2 instanceof ChannelEventRunnable)) continue;
            if (cause == null) {
                cause = new IOException("Unable to process queued event");
            }
            ChannelEvent event2 = ((ChannelEventRunnable)task2).getEvent();
            event2.getFuture().setFailure(cause);
            if (channels == null) {
                channels = new HashSet<Channel>();
            }
            channels.add(event2.getChannel());
        }
        if (channels != null) {
            for (Channel channel : channels) {
                Channels.fireExceptionCaughtLater(channel, (Throwable)cause);
            }
        }
        return tasks;
    }

    public ObjectSizeEstimator getObjectSizeEstimator() {
        return this.settings.objectSizeEstimator;
    }

    public void setObjectSizeEstimator(ObjectSizeEstimator objectSizeEstimator) {
        if (objectSizeEstimator == null) {
            throw new NullPointerException("objectSizeEstimator");
        }
        this.settings = new Settings(objectSizeEstimator, this.settings.maxChannelMemorySize);
    }

    public long getMaxChannelMemorySize() {
        return this.settings.maxChannelMemorySize;
    }

    public void setMaxChannelMemorySize(long maxChannelMemorySize) {
        if (maxChannelMemorySize < 0L) {
            throw new IllegalArgumentException("maxChannelMemorySize: " + maxChannelMemorySize);
        }
        if (this.getTaskCount() > 0L) {
            throw new IllegalStateException("can't be changed after a task is executed");
        }
        this.settings = new Settings(this.settings.objectSizeEstimator, maxChannelMemorySize);
    }

    public long getMaxTotalMemorySize() {
        if (this.totalLimiter == null) {
            return 0L;
        }
        return this.totalLimiter.limit;
    }

    @Deprecated
    public void setMaxTotalMemorySize(long maxTotalMemorySize) {
        if (maxTotalMemorySize < 0L) {
            throw new IllegalArgumentException("maxTotalMemorySize: " + maxTotalMemorySize);
        }
        if (this.getTaskCount() > 0L) {
            throw new IllegalStateException("can't be changed after a task is executed");
        }
    }

    public void setNotifyChannelFuturesOnShutdown(boolean notifyOnShutdown) {
        this.notifyOnShutdown = notifyOnShutdown;
    }

    public boolean getNotifyChannelFuturesOnShutdown() {
        return this.notifyOnShutdown;
    }

    @Override
    public void execute(Runnable command) {
        if (command instanceof ChannelDownstreamEventRunnable) {
            throw new RejectedExecutionException("command must be enclosed with an upstream event.");
        }
        if (!(command instanceof ChannelEventRunnable)) {
            command = new MemoryAwareRunnable(command);
        }
        this.increaseCounter(command);
        this.doExecute(command);
    }

    protected void doExecute(Runnable task2) {
        this.doUnorderedExecute(task2);
    }

    protected final void doUnorderedExecute(Runnable task2) {
        super.execute(task2);
    }

    @Override
    public boolean remove(Runnable task2) {
        boolean removed = super.remove(task2);
        if (removed) {
            this.decreaseCounter(task2);
        }
        return removed;
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.decreaseCounter(r);
    }

    protected void increaseCounter(Runnable task2) {
        if (!this.shouldCount(task2)) {
            return;
        }
        Settings settings = this.settings;
        long maxChannelMemorySize = settings.maxChannelMemorySize;
        int increment = settings.objectSizeEstimator.estimateSize(task2);
        if (task2 instanceof ChannelEventRunnable) {
            ChannelEventRunnable eventTask = (ChannelEventRunnable)task2;
            eventTask.estimatedSize = increment;
            Channel channel = eventTask.getEvent().getChannel();
            long channelCounter = this.getChannelCounter(channel).addAndGet(increment);
            if (maxChannelMemorySize != 0L && channelCounter >= maxChannelMemorySize && channel.isOpen() && channel.isReadable()) {
                ChannelHandlerContext ctx = eventTask.getContext();
                if (ctx.getHandler() instanceof ExecutionHandler) {
                    ctx.setAttachment(Boolean.TRUE);
                }
                channel.setReadable(false);
            }
        } else {
            ((MemoryAwareRunnable)task2).estimatedSize = increment;
        }
        if (this.totalLimiter != null) {
            this.totalLimiter.increase(increment);
        }
    }

    protected void decreaseCounter(Runnable task2) {
        if (!this.shouldCount(task2)) {
            return;
        }
        Settings settings = this.settings;
        long maxChannelMemorySize = settings.maxChannelMemorySize;
        int increment = task2 instanceof ChannelEventRunnable ? ((ChannelEventRunnable)task2).estimatedSize : ((MemoryAwareRunnable)task2).estimatedSize;
        if (this.totalLimiter != null) {
            this.totalLimiter.decrease(increment);
        }
        if (task2 instanceof ChannelEventRunnable) {
            ChannelEventRunnable eventTask = (ChannelEventRunnable)task2;
            Channel channel = eventTask.getEvent().getChannel();
            long channelCounter = this.getChannelCounter(channel).addAndGet(-increment);
            if (maxChannelMemorySize != 0L && channelCounter < maxChannelMemorySize && channel.isOpen() && !channel.isReadable()) {
                ChannelHandlerContext ctx = eventTask.getContext();
                if (ctx.getHandler() instanceof ExecutionHandler) {
                    if (ctx.getAttachment() != null) {
                        ctx.setAttachment(null);
                        channel.setReadable(true);
                    }
                } else {
                    channel.setReadable(true);
                }
            }
        }
    }

    private AtomicLong getChannelCounter(Channel channel) {
        AtomicLong oldCounter;
        AtomicLong counter = (AtomicLong)this.channelCounters.get(channel);
        if (counter == null && (oldCounter = this.channelCounters.putIfAbsent(channel, counter = new AtomicLong())) != null) {
            counter = oldCounter;
        }
        if (!channel.isOpen()) {
            this.channelCounters.remove(channel);
        }
        return counter;
    }

    protected boolean shouldCount(Runnable task2) {
        if (task2 instanceof ChannelUpstreamEventRunnable) {
            ChannelUpstreamEventRunnable r = (ChannelUpstreamEventRunnable)task2;
            ChannelEvent e = r.getEvent();
            if (e instanceof WriteCompletionEvent) {
                return false;
            }
            if (e instanceof ChannelStateEvent && ((ChannelStateEvent)e).getState() == ChannelState.INTEREST_OPS) {
                return false;
            }
        }
        return true;
    }

    private static class Limiter {
        final long limit;
        private long counter;
        private int waiters;

        Limiter(long limit) {
            this.limit = limit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void increase(long amount) {
            while (this.counter >= this.limit) {
                Object var5_3;
                ++this.waiters;
                try {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        var5_3 = null;
                        --this.waiters;
                        continue;
                    }
                    var5_3 = null;
                    --this.waiters;
                }
                catch (Throwable throwable) {
                    var5_3 = null;
                    --this.waiters;
                    throw throwable;
                }
            }
            this.counter += amount;
        }

        synchronized void decrease(long amount) {
            this.counter -= amount;
            if (this.counter < this.limit && this.waiters > 0) {
                this.notifyAll();
            }
        }
    }

    private static final class MemoryAwareRunnable
    implements Runnable {
        final Runnable task;
        int estimatedSize;

        MemoryAwareRunnable(Runnable task2) {
            this.task = task2;
        }

        public void run() {
            this.task.run();
        }
    }

    private static final class NewThreadRunsPolicy
    implements RejectedExecutionHandler {
        private NewThreadRunsPolicy() {
        }

        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor2) {
            try {
                Thread t = new Thread(r, "Temporary task executor");
                t.start();
            }
            catch (Throwable e) {
                throw new RejectedExecutionException("Failed to start a new thread", e);
            }
        }
    }

    private static final class Settings {
        final ObjectSizeEstimator objectSizeEstimator;
        final long maxChannelMemorySize;

        Settings(ObjectSizeEstimator objectSizeEstimator, long maxChannelMemorySize) {
            this.objectSizeEstimator = objectSizeEstimator;
            this.maxChannelMemorySize = maxChannelMemorySize;
        }
    }
}

