/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jboss.netty.handler.execution;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelDownstreamHandler;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelEvent;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelHandler;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelState;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelStateEvent;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelUpstreamHandler;
import org.apache.storm.shade.org.jboss.netty.handler.execution.ChannelDownstreamEventRunnable;
import org.apache.storm.shade.org.jboss.netty.handler.execution.ChannelUpstreamEventRunnable;
import org.apache.storm.shade.org.jboss.netty.util.ExternalResourceReleasable;

@ChannelHandler.Sharable
public class ExecutionHandler
implements ChannelUpstreamHandler,
ChannelDownstreamHandler,
ExternalResourceReleasable {
    private final Executor executor;
    private final boolean handleDownstream;
    private final boolean handleUpstream;

    public ExecutionHandler(Executor executor2) {
        this(executor2, false, true);
    }

    @Deprecated
    public ExecutionHandler(Executor executor2, boolean handleDownstream) {
        this(executor2, handleDownstream, true);
    }

    public ExecutionHandler(Executor executor2, boolean handleDownstream, boolean handleUpstream) {
        if (executor2 == null) {
            throw new NullPointerException("executor");
        }
        if (!handleDownstream && !handleUpstream) {
            throw new IllegalArgumentException("You must handle at least handle one event type");
        }
        this.executor = executor2;
        this.handleDownstream = handleDownstream;
        this.handleUpstream = handleUpstream;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void releaseExternalResources() {
        Executor executor2 = this.getExecutor();
        if (executor2 instanceof ExecutorService) {
            ((ExecutorService)executor2).shutdown();
        }
        if (executor2 instanceof ExternalResourceReleasable) {
            ((ExternalResourceReleasable)((Object)executor2)).releaseExternalResources();
        }
    }

    public void handleUpstream(ChannelHandlerContext context2, ChannelEvent e) throws Exception {
        if (this.handleUpstream) {
            this.executor.execute(new ChannelUpstreamEventRunnable(context2, e, this.executor));
        } else {
            context2.sendUpstream(e);
        }
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (!this.handleReadSuspend(ctx, e)) {
            if (this.handleDownstream) {
                this.executor.execute(new ChannelDownstreamEventRunnable(ctx, e, this.executor));
            } else {
                ctx.sendDownstream(e);
            }
        }
    }

    protected boolean handleReadSuspend(ChannelHandlerContext ctx, ChannelEvent e) {
        ChannelStateEvent cse;
        if (e instanceof ChannelStateEvent && (cse = (ChannelStateEvent)e).getState() == ChannelState.INTEREST_OPS && ((Integer)cse.getValue() & 1) != 0) {
            boolean readSuspended;
            boolean bl = readSuspended = ctx.getAttachment() != null;
            if (readSuspended) {
                e.getFuture().setSuccess();
                return true;
            }
        }
        return false;
    }
}

