/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jboss.netty.channel.socket.nio;

import java.net.SocketAddress;
import org.apache.storm.shade.org.jboss.netty.channel.Channel;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelEvent;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelFuture;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelPipeline;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelState;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelStateEvent;
import org.apache.storm.shade.org.jboss.netty.channel.MessageEvent;
import org.apache.storm.shade.org.jboss.netty.channel.socket.nio.AbstractNioChannelSink;
import org.apache.storm.shade.org.jboss.netty.channel.socket.nio.NioServerBoss;
import org.apache.storm.shade.org.jboss.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.storm.shade.org.jboss.netty.channel.socket.nio.NioSocketChannel;

class NioServerSocketPipelineSink
extends AbstractNioChannelSink {
    NioServerSocketPipelineSink() {
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        Channel channel = e.getChannel();
        if (channel instanceof NioServerSocketChannel) {
            NioServerSocketPipelineSink.handleServerSocket(e);
        } else if (channel instanceof NioSocketChannel) {
            NioServerSocketPipelineSink.handleAcceptedSocket(e);
        }
    }

    private static void handleServerSocket(ChannelEvent e) {
        if (!(e instanceof ChannelStateEvent)) {
            return;
        }
        ChannelStateEvent event2 = (ChannelStateEvent)e;
        NioServerSocketChannel channel = (NioServerSocketChannel)event2.getChannel();
        ChannelFuture future = event2.getFuture();
        ChannelState state = event2.getState();
        Object value = event2.getValue();
        switch (state) {
            case OPEN: {
                if (!Boolean.FALSE.equals(value)) break;
                ((NioServerBoss)channel.boss).close(channel, future);
                break;
            }
            case BOUND: {
                if (value != null) {
                    ((NioServerBoss)channel.boss).bind(channel, future, (SocketAddress)value);
                    break;
                }
                ((NioServerBoss)channel.boss).close(channel, future);
                break;
            }
        }
    }

    private static void handleAcceptedSocket(ChannelEvent e) {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent event2 = (ChannelStateEvent)e;
            NioSocketChannel channel = (NioSocketChannel)event2.getChannel();
            ChannelFuture future = event2.getFuture();
            ChannelState state = event2.getState();
            Object value = event2.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    channel.worker.close(channel, future);
                    break;
                }
                case BOUND: 
                case CONNECTED: {
                    if (value != null) break;
                    channel.worker.close(channel, future);
                    break;
                }
                case INTEREST_OPS: {
                    channel.worker.setInterestOps(channel, future, (Integer)value);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event3 = (MessageEvent)e;
            NioSocketChannel channel = (NioSocketChannel)event3.getChannel();
            boolean offered = channel.writeBufferQueue.offer(event3);
            assert (offered);
            channel.worker.writeFromUserCode(channel);
        }
    }
}

