/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ConcurrentModificationException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.storm.shade.org.jboss.netty.channel.Channel;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelException;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelFuture;
import org.apache.storm.shade.org.jboss.netty.channel.socket.nio.NioSelector;
import org.apache.storm.shade.org.jboss.netty.channel.socket.nio.SelectorUtil;
import org.apache.storm.shade.org.jboss.netty.logging.InternalLogger;
import org.apache.storm.shade.org.jboss.netty.logging.InternalLoggerFactory;
import org.apache.storm.shade.org.jboss.netty.util.ThreadNameDeterminer;
import org.apache.storm.shade.org.jboss.netty.util.ThreadRenamingRunnable;
import org.apache.storm.shade.org.jboss.netty.util.internal.DeadLockProofWorker;

abstract class AbstractNioSelector
implements NioSelector {
    private static final AtomicInteger nextId = new AtomicInteger();
    private final int id = nextId.incrementAndGet();
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractNioSelector.class);
    private static final int CLEANUP_INTERVAL = 256;
    private final Executor executor;
    protected volatile Thread thread;
    final CountDownLatch startupLatch = new CountDownLatch(1);
    protected volatile Selector selector;
    protected final AtomicBoolean wakenUp = new AtomicBoolean();
    private final Queue<Runnable> taskQueue = new ConcurrentLinkedQueue<Runnable>();
    private volatile int cancelledKeys;
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private volatile boolean shutdown;

    AbstractNioSelector(Executor executor2) {
        this(executor2, null);
    }

    AbstractNioSelector(Executor executor2, ThreadNameDeterminer determiner) {
        this.executor = executor2;
        this.openSelector(determiner);
    }

    public void register(Channel channel, ChannelFuture future) {
        Runnable task2 = this.createRegisterTask(channel, future);
        this.registerTask(task2);
    }

    protected final void registerTask(Runnable task2) {
        this.taskQueue.add(task2);
        Selector selector = this.selector;
        if (selector != null) {
            if (this.wakenUp.compareAndSet(false, true)) {
                selector.wakeup();
            }
        } else if (this.taskQueue.remove(task2)) {
            throw new RejectedExecutionException("Worker has already been shutdown");
        }
    }

    protected final boolean isIoThread() {
        return Thread.currentThread() == this.thread;
    }

    public void rebuildSelector() {
        int nChannels;
        block12: {
            Selector newSelector;
            if (!this.isIoThread()) {
                this.taskQueue.add(new Runnable(){

                    public void run() {
                        AbstractNioSelector.this.rebuildSelector();
                    }
                });
                return;
            }
            Selector oldSelector = this.selector;
            if (oldSelector == null) {
                return;
            }
            try {
                newSelector = SelectorUtil.open();
            }
            catch (Exception e) {
                logger.warn("Failed to create a new Selector.", e);
                return;
            }
            nChannels = 0;
            while (true) {
                try {
                    for (SelectionKey key : oldSelector.keys()) {
                        try {
                            if (key.channel().keyFor(newSelector) != null) continue;
                            int interestOps = key.interestOps();
                            key.cancel();
                            key.channel().register(newSelector, interestOps, key.attachment());
                            ++nChannels;
                        }
                        catch (Exception e) {
                            logger.warn("Failed to re-register a Channel to the new Selector,", e);
                            this.close(key);
                        }
                    }
                }
                catch (ConcurrentModificationException e) {
                    continue;
                }
                break;
            }
            this.selector = newSelector;
            try {
                oldSelector.close();
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block12;
                logger.warn("Failed to close the old Selector.", t);
            }
        }
        logger.info("Migrated " + nChannels + " channel(s) to the new Selector,");
    }

    public void run() {
        this.thread = Thread.currentThread();
        this.startupLatch.countDown();
        int selectReturnsImmediately = 0;
        Selector selector = this.selector;
        if (selector == null) {
            return;
        }
        long minSelectTimeout = SelectorUtil.SELECT_TIMEOUT_NANOS * 80L / 100L;
        boolean wakenupFromLoop = false;
        while (true) {
            this.wakenUp.set(false);
            try {
                long beforeSelect = System.nanoTime();
                int selected = this.select(selector);
                if (SelectorUtil.EPOLL_BUG_WORKAROUND && selected == 0 && !wakenupFromLoop && !this.wakenUp.get()) {
                    long timeBlocked = System.nanoTime() - beforeSelect;
                    if (timeBlocked < minSelectTimeout) {
                        boolean notConnected = false;
                        for (SelectionKey key : selector.keys()) {
                            SelectableChannel ch = key.channel();
                            try {
                                if ((!(ch instanceof DatagramChannel) || ch.isOpen()) && (!(ch instanceof SocketChannel) || ((SocketChannel)ch).isConnected())) continue;
                                notConnected = true;
                                key.cancel();
                            }
                            catch (CancelledKeyException e) {}
                        }
                        selectReturnsImmediately = notConnected ? 0 : ++selectReturnsImmediately;
                    } else {
                        selectReturnsImmediately = 0;
                    }
                    if (selectReturnsImmediately == 1024) {
                        this.rebuildSelector();
                        selector = this.selector;
                        selectReturnsImmediately = 0;
                        wakenupFromLoop = false;
                        continue;
                    }
                } else {
                    selectReturnsImmediately = 0;
                }
                if (this.wakenUp.get()) {
                    wakenupFromLoop = true;
                    selector.wakeup();
                } else {
                    wakenupFromLoop = false;
                }
                this.cancelledKeys = 0;
                this.processTaskQueue();
                selector = this.selector;
                if (this.shutdown) {
                    this.selector = null;
                    this.processTaskQueue();
                    for (SelectionKey k : selector.keys()) {
                        this.close(k);
                    }
                    try {
                        selector.close();
                    }
                    catch (IOException e) {
                        logger.warn("Failed to close a selector.", e);
                    }
                    this.shutdownLatch.countDown();
                    break;
                }
                this.process(selector);
            }
            catch (Throwable t) {
                logger.warn("Unexpected exception in the selector loop.", t);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openSelector(ThreadNameDeterminer determiner) {
        try {
            this.selector = SelectorUtil.open();
        }
        catch (Throwable t) {
            throw new ChannelException("Failed to create a selector.", t);
        }
        boolean success = false;
        try {
            DeadLockProofWorker.start(this.executor, this.newThreadRenamingRunnable(this.id, determiner));
            success = true;
        }
        finally {
            if (!success) {
                try {
                    this.selector.close();
                }
                catch (Throwable t) {
                    logger.warn("Failed to close a selector.", t);
                }
                this.selector = null;
            }
        }
        assert (this.selector != null && this.selector.isOpen());
    }

    private void processTaskQueue() {
        Runnable task2;
        while ((task2 = this.taskQueue.poll()) != null) {
            task2.run();
            try {
                this.cleanUpCancelledKeys();
            }
            catch (IOException iOException) {}
        }
    }

    protected final void increaseCancelledKeys() {
        ++this.cancelledKeys;
    }

    protected final boolean cleanUpCancelledKeys() throws IOException {
        if (this.cancelledKeys >= 256) {
            this.cancelledKeys = 0;
            this.selector.selectNow();
            return true;
        }
        return false;
    }

    public void shutdown() {
        if (this.isIoThread()) {
            throw new IllegalStateException("Must not be called from a I/O-Thread to prevent deadlocks!");
        }
        Selector selector = this.selector;
        this.shutdown = true;
        if (selector != null) {
            selector.wakeup();
        }
        try {
            this.shutdownLatch.await();
        }
        catch (InterruptedException e) {
            logger.error("Interrupted while wait for resources to be released #" + this.id);
            Thread.currentThread().interrupt();
        }
    }

    protected abstract void process(Selector var1) throws IOException;

    protected int select(Selector selector) throws IOException {
        return SelectorUtil.select(selector);
    }

    protected abstract void close(SelectionKey var1);

    protected abstract ThreadRenamingRunnable newThreadRenamingRunnable(int var1, ThreadNameDeterminer var2);

    protected abstract Runnable createRegisterTask(Channel var1, ChannelFuture var2);
}

