/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jboss.netty.channel;

import org.apache.storm.shade.org.jboss.netty.channel.ChannelEvent;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelFuture;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelPipeline;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelPipelineException;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelSink;
import org.apache.storm.shade.org.jboss.netty.channel.Channels;

public abstract class AbstractChannelSink
implements ChannelSink {
    protected AbstractChannelSink() {
    }

    public void exceptionCaught(ChannelPipeline pipeline, ChannelEvent event2, ChannelPipelineException cause) throws Exception {
        Throwable actualCause = cause.getCause();
        if (actualCause == null) {
            actualCause = cause;
        }
        if (this.isFireExceptionCaughtLater(event2, actualCause)) {
            Channels.fireExceptionCaughtLater(event2.getChannel(), actualCause);
        } else {
            Channels.fireExceptionCaught(event2.getChannel(), actualCause);
        }
    }

    protected boolean isFireExceptionCaughtLater(ChannelEvent event2, Throwable actualCause) {
        return false;
    }

    public ChannelFuture execute(ChannelPipeline pipeline, Runnable task2) {
        try {
            task2.run();
            return Channels.succeededFuture(pipeline.getChannel());
        }
        catch (Throwable t) {
            return Channels.failedFuture(pipeline.getChannel(), t);
        }
    }
}

