/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jboss.netty.bootstrap;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.shade.org.jboss.netty.bootstrap.Bootstrap;
import org.apache.storm.shade.org.jboss.netty.channel.Channel;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelException;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelFactory;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelFuture;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelFutureListener;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelHandler;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelPipeline;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelStateEvent;
import org.apache.storm.shade.org.jboss.netty.channel.Channels;
import org.apache.storm.shade.org.jboss.netty.channel.ChildChannelStateEvent;
import org.apache.storm.shade.org.jboss.netty.channel.DefaultChannelFuture;
import org.apache.storm.shade.org.jboss.netty.channel.ExceptionEvent;
import org.apache.storm.shade.org.jboss.netty.channel.ServerChannelFactory;
import org.apache.storm.shade.org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public class ServerBootstrap
extends Bootstrap {
    private volatile ChannelHandler parentHandler;

    public ServerBootstrap() {
    }

    public ServerBootstrap(ChannelFactory channelFactory) {
        super(channelFactory);
    }

    public void setFactory(ChannelFactory factory2) {
        if (factory2 == null) {
            throw new NullPointerException("factory");
        }
        if (!(factory2 instanceof ServerChannelFactory)) {
            throw new IllegalArgumentException("factory must be a " + ServerChannelFactory.class.getSimpleName() + ": " + factory2.getClass());
        }
        super.setFactory(factory2);
    }

    public ChannelHandler getParentHandler() {
        return this.parentHandler;
    }

    public void setParentHandler(ChannelHandler parentHandler) {
        this.parentHandler = parentHandler;
    }

    public Channel bind() {
        SocketAddress localAddress = (SocketAddress)this.getOption("localAddress");
        if (localAddress == null) {
            throw new IllegalStateException("localAddress option is not set.");
        }
        return this.bind(localAddress);
    }

    public Channel bind(SocketAddress localAddress) {
        ChannelFuture future = this.bindAsync(localAddress);
        future.awaitUninterruptibly();
        if (!future.isSuccess()) {
            future.getChannel().close().awaitUninterruptibly();
            throw new ChannelException("Failed to bind to: " + localAddress, future.getCause());
        }
        return future.getChannel();
    }

    public ChannelFuture bindAsync() {
        SocketAddress localAddress = (SocketAddress)this.getOption("localAddress");
        if (localAddress == null) {
            throw new IllegalStateException("localAddress option is not set.");
        }
        return this.bindAsync(localAddress);
    }

    public ChannelFuture bindAsync(SocketAddress localAddress) {
        if (localAddress == null) {
            throw new NullPointerException("localAddress");
        }
        Binder binder = new Binder(localAddress);
        ChannelHandler parentHandler = this.getParentHandler();
        ChannelPipeline bossPipeline = Channels.pipeline();
        bossPipeline.addLast("binder", binder);
        if (parentHandler != null) {
            bossPipeline.addLast("userHandler", parentHandler);
        }
        Channel channel = this.getFactory().newChannel(bossPipeline);
        final DefaultChannelFuture bfuture = new DefaultChannelFuture(channel, false);
        binder.bindFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    bfuture.setSuccess();
                } else {
                    bfuture.getChannel().close();
                    bfuture.setFailure(future.getCause());
                }
            }
        });
        return bfuture;
    }

    private final class Binder
    extends SimpleChannelUpstreamHandler {
        private final SocketAddress localAddress;
        private final Map<String, Object> childOptions = new HashMap<String, Object>();
        private final DefaultChannelFuture bindFuture = new DefaultChannelFuture(null, false);

        Binder(SocketAddress localAddress) {
            this.localAddress = localAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent evt) {
            try {
                evt.getChannel().getConfig().setPipelineFactory(ServerBootstrap.this.getPipelineFactory());
                Map<String, Object> allOptions = ServerBootstrap.this.getOptions();
                HashMap<String, Object> parentOptions = new HashMap<String, Object>();
                for (Map.Entry<String, Object> e : allOptions.entrySet()) {
                    if (e.getKey().startsWith("child.")) {
                        this.childOptions.put(e.getKey().substring(6), e.getValue());
                        continue;
                    }
                    if ("pipelineFactory".equals(e.getKey())) continue;
                    parentOptions.put(e.getKey(), e.getValue());
                }
                evt.getChannel().getConfig().setOptions(parentOptions);
                Object var8_7 = null;
                ctx.sendUpstream(evt);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                ctx.sendUpstream(evt);
                throw throwable;
            }
            evt.getChannel().bind(this.localAddress).addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        Binder.this.bindFuture.setSuccess();
                    } else {
                        Binder.this.bindFuture.setFailure(future.getCause());
                    }
                }
            });
        }

        public void childChannelOpen(ChannelHandlerContext ctx, ChildChannelStateEvent e) throws Exception {
            try {
                e.getChildChannel().getConfig().setOptions(this.childOptions);
            }
            catch (Throwable t) {
                Channels.fireExceptionCaught(e.getChildChannel(), t);
            }
            ctx.sendUpstream(e);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            this.bindFuture.setFailure(e.getCause());
            ctx.sendUpstream(e);
        }
    }
}

