/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.util.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.storm.shade.org.eclipse.jetty.util.resource.Resource;

public class ResourceCollection
extends Resource {
    private Resource[] _resources;

    public ResourceCollection() {
        this._resources = new Resource[0];
    }

    public ResourceCollection(Resource ... resources2) {
        ArrayList<Resource> list2 = new ArrayList<Resource>();
        for (Resource r : resources2) {
            if (r == null) continue;
            if (r instanceof ResourceCollection) {
                for (Resource r2 : ((ResourceCollection)r).getResources()) {
                    list2.add(r2);
                }
                continue;
            }
            list2.add(r);
        }
        this._resources = list2.toArray(new Resource[list2.size()]);
        for (Resource r : this._resources) {
            if (r.exists() && r.isDirectory()) continue;
            throw new IllegalArgumentException(r + " is not an existing directory.");
        }
    }

    public ResourceCollection(String[] resources2) {
        this._resources = new Resource[resources2.length];
        try {
            for (int i = 0; i < resources2.length; ++i) {
                this._resources[i] = Resource.newResource(resources2[i]);
                if (this._resources[i].exists() && this._resources[i].isDirectory()) continue;
                throw new IllegalArgumentException(this._resources[i] + " is not an existing directory.");
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ResourceCollection(String csvResources) {
        this.setResourcesAsCSV(csvResources);
    }

    public Resource[] getResources() {
        return this._resources;
    }

    public void setResources(Resource[] resources2) {
        this._resources = resources2 != null ? resources2 : new Resource[]{};
    }

    public void setResourcesAsCSV(String csvResources) {
        StringTokenizer tokenizer = new StringTokenizer(csvResources, ",;");
        int len = tokenizer.countTokens();
        if (len == 0) {
            throw new IllegalArgumentException("ResourceCollection@setResourcesAsCSV(String)  argument must be a string containing one or more comma-separated resource strings.");
        }
        this._resources = new Resource[len];
        try {
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                this._resources[i] = Resource.newResource(tokenizer.nextToken().trim());
                if (!this._resources[i].exists() || !this._resources[i].isDirectory()) {
                    throw new IllegalArgumentException(this._resources[i] + " is not an existing directory.");
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Resource addPath(String path) throws IOException, MalformedURLException {
        int i;
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        if (path == null) {
            throw new MalformedURLException();
        }
        if (path.length() == 0 || "/".equals(path)) {
            return this;
        }
        Resource resource = null;
        ArrayList<Resource> resources2 = null;
        for (i = 0; i < this._resources.length; ++i) {
            resource = this._resources[i].addPath(path);
            if (!resource.exists()) continue;
            if (resource.isDirectory()) break;
            return resource;
        }
        ++i;
        while (i < this._resources.length) {
            Resource r = this._resources[i].addPath(path);
            if (r.exists() && r.isDirectory()) {
                if (resource != null) {
                    resources2 = new ArrayList<Resource>();
                    resources2.add(resource);
                    resource = null;
                }
                resources2.add(r);
            }
            ++i;
        }
        if (resource != null) {
            return resource;
        }
        if (resources2 != null) {
            return new ResourceCollection(resources2.toArray(new Resource[resources2.size()]));
        }
        return null;
    }

    protected Object findResource(String path) throws IOException, MalformedURLException {
        int i;
        Resource resource = null;
        ArrayList<Resource> resources2 = null;
        for (i = 0; i < this._resources.length; ++i) {
            resource = this._resources[i].addPath(path);
            if (!resource.exists()) continue;
            if (resource.isDirectory()) break;
            return resource;
        }
        ++i;
        while (i < this._resources.length) {
            Resource r = this._resources[i].addPath(path);
            if (r.exists() && r.isDirectory()) {
                if (resource != null) {
                    resources2 = new ArrayList<Resource>();
                    resources2.add(resource);
                }
                resources2.add(r);
            }
            ++i;
        }
        if (resource != null) {
            return resource;
        }
        if (resources2 != null) {
            return resources2;
        }
        return null;
    }

    public boolean delete() throws SecurityException {
        throw new UnsupportedOperationException();
    }

    public boolean exists() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        return true;
    }

    public File getFile() throws IOException {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (Resource r : this._resources) {
            File f = r.getFile();
            if (f == null) continue;
            return f;
        }
        return null;
    }

    public InputStream getInputStream() throws IOException {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (Resource r : this._resources) {
            InputStream is = r.getInputStream();
            if (is == null) continue;
            return is;
        }
        return null;
    }

    public String getName() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (Resource r : this._resources) {
            String name = r.getName();
            if (name == null) continue;
            return name;
        }
        return null;
    }

    public OutputStream getOutputStream() throws IOException, SecurityException {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (Resource r : this._resources) {
            OutputStream os = r.getOutputStream();
            if (os == null) continue;
            return os;
        }
        return null;
    }

    public URL getURL() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (Resource r : this._resources) {
            URL url2 = r.getURL();
            if (url2 == null) continue;
            return url2;
        }
        return null;
    }

    public boolean isDirectory() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        return true;
    }

    public long lastModified() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (Resource r : this._resources) {
            long lm = r.lastModified();
            if (lm == -1L) continue;
            return lm;
        }
        return -1L;
    }

    public long length() {
        return -1L;
    }

    public String[] list() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        HashSet<String> set = new HashSet<String>();
        for (Resource r : this._resources) {
            for (String s : r.list()) {
                set.add(s);
            }
        }
        Object[] result2 = set.toArray(new String[set.size()]);
        Arrays.sort(result2);
        return result2;
    }

    public void release() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (Resource r : this._resources) {
            r.release();
        }
    }

    public boolean renameTo(Resource dest) throws SecurityException {
        throw new UnsupportedOperationException();
    }

    public void copyTo(File destination) throws IOException {
        int r = this._resources.length;
        while (r-- > 0) {
            this._resources[r].copyTo(destination);
        }
    }

    public String toString() {
        if (this._resources == null) {
            return "[]";
        }
        return String.valueOf(Arrays.asList(this._resources));
    }

    public boolean isContainedIn(Resource r) throws MalformedURLException {
        return false;
    }
}

