/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.util.resource;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import org.apache.storm.shade.org.eclipse.jetty.util.B64Code;
import org.apache.storm.shade.org.eclipse.jetty.util.IO;
import org.apache.storm.shade.org.eclipse.jetty.util.Loader;
import org.apache.storm.shade.org.eclipse.jetty.util.StringUtil;
import org.apache.storm.shade.org.eclipse.jetty.util.URIUtil;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Log;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Logger;
import org.apache.storm.shade.org.eclipse.jetty.util.resource.BadResource;
import org.apache.storm.shade.org.eclipse.jetty.util.resource.FileResource;
import org.apache.storm.shade.org.eclipse.jetty.util.resource.JarFileResource;
import org.apache.storm.shade.org.eclipse.jetty.util.resource.JarResource;
import org.apache.storm.shade.org.eclipse.jetty.util.resource.ResourceFactory;
import org.apache.storm.shade.org.eclipse.jetty.util.resource.URLResource;

public abstract class Resource
implements ResourceFactory {
    private static final Logger LOG = Log.getLogger(Resource.class);
    public static boolean __defaultUseCaches = true;
    volatile Object _associate;

    public static void setDefaultUseCaches(boolean useCaches) {
        __defaultUseCaches = useCaches;
    }

    public static boolean getDefaultUseCaches() {
        return __defaultUseCaches;
    }

    public static Resource newResource(URI uri) throws IOException {
        return Resource.newResource(uri.toURL());
    }

    public static Resource newResource(URL url2) throws IOException {
        return Resource.newResource(url2, __defaultUseCaches);
    }

    static Resource newResource(URL url2, boolean useCaches) {
        if (url2 == null) {
            return null;
        }
        String url_string = url2.toExternalForm();
        if (url_string.startsWith("file:")) {
            try {
                FileResource fileResource = new FileResource(url2);
                return fileResource;
            }
            catch (Exception e) {
                LOG.debug("EXCEPTION ", e);
                return new BadResource(url2, e.toString());
            }
        }
        if (url_string.startsWith("jar:file:")) {
            return new JarFileResource(url2, useCaches);
        }
        if (url_string.startsWith("jar:")) {
            return new JarResource(url2, useCaches);
        }
        return new URLResource(url2, null, useCaches);
    }

    public static Resource newResource(String resource) throws MalformedURLException, IOException {
        return Resource.newResource(resource, __defaultUseCaches);
    }

    public static Resource newResource(String resource, boolean useCaches) throws MalformedURLException, IOException {
        URL url2 = null;
        try {
            url2 = new URL(resource);
        }
        catch (MalformedURLException e) {
            if (!(resource.startsWith("ftp:") || resource.startsWith("file:") || resource.startsWith("jar:"))) {
                try {
                    if (resource.startsWith("./")) {
                        resource = resource.substring(2);
                    }
                    File file2 = new File(resource).getCanonicalFile();
                    url2 = Resource.toURL(file2);
                    URLConnection connection = url2.openConnection();
                    connection.setUseCaches(useCaches);
                    return new FileResource(url2, connection, file2);
                }
                catch (Exception e2) {
                    LOG.debug("EXCEPTION ", e2);
                    throw e;
                }
            }
            LOG.warn("Bad Resource: " + resource, new Object[0]);
            throw e;
        }
        return Resource.newResource(url2);
    }

    public static Resource newResource(File file2) throws MalformedURLException, IOException {
        file2 = file2.getCanonicalFile();
        URL url2 = Resource.toURL(file2);
        URLConnection connection = url2.openConnection();
        FileResource fileResource = new FileResource(url2, connection, file2);
        return fileResource;
    }

    public static Resource newSystemResource(String resource) throws IOException {
        URL url2 = null;
        ClassLoader loader2 = Thread.currentThread().getContextClassLoader();
        if (loader2 != null) {
            try {
                url2 = loader2.getResource(resource);
                if (url2 == null && resource.startsWith("/")) {
                    url2 = loader2.getResource(resource.substring(1));
                }
            }
            catch (IllegalArgumentException e) {
                url2 = null;
            }
        }
        if (url2 == null && (loader2 = Resource.class.getClassLoader()) != null && (url2 = loader2.getResource(resource)) == null && resource.startsWith("/")) {
            url2 = loader2.getResource(resource.substring(1));
        }
        if (url2 == null && (url2 = ClassLoader.getSystemResource(resource)) == null && resource.startsWith("/")) {
            url2 = ClassLoader.getSystemResource(resource.substring(1));
        }
        if (url2 == null) {
            return null;
        }
        return Resource.newResource(url2);
    }

    public static Resource newClassPathResource(String resource) {
        return Resource.newClassPathResource(resource, true, false);
    }

    public static Resource newClassPathResource(String name, boolean useCaches, boolean checkParents) {
        URL url2 = Resource.class.getResource(name);
        if (url2 == null) {
            url2 = Loader.getResource(Resource.class, name, checkParents);
        }
        if (url2 == null) {
            return null;
        }
        return Resource.newResource(url2, useCaches);
    }

    public static boolean isContainedIn(Resource r, Resource containingResource) throws MalformedURLException {
        return r.isContainedIn(containingResource);
    }

    protected void finalize() {
        this.release();
    }

    public abstract boolean isContainedIn(Resource var1) throws MalformedURLException;

    public abstract void release();

    public abstract boolean exists();

    public abstract boolean isDirectory();

    public abstract long lastModified();

    public abstract long length();

    public abstract URL getURL();

    public URI getURI() {
        try {
            return this.getURL().toURI();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public abstract File getFile() throws IOException;

    public abstract String getName();

    public abstract InputStream getInputStream() throws IOException;

    public abstract OutputStream getOutputStream() throws IOException, SecurityException;

    public abstract boolean delete() throws SecurityException;

    public abstract boolean renameTo(Resource var1) throws SecurityException;

    public abstract String[] list();

    public abstract Resource addPath(String var1) throws IOException, MalformedURLException;

    public Resource getResource(String path) {
        try {
            return this.addPath(path);
        }
        catch (Exception e) {
            LOG.debug(e);
            return null;
        }
    }

    public String encode(String uri) {
        return URIUtil.encodePath(uri);
    }

    public Object getAssociate() {
        return this._associate;
    }

    public void setAssociate(Object o) {
        this._associate = o;
    }

    public URL getAlias() {
        return null;
    }

    public String getListHTML(String base, boolean parent) throws IOException {
        if ((base = URIUtil.canonicalPath(base)) == null || !this.isDirectory()) {
            return null;
        }
        Object[] ls = this.list();
        if (ls == null) {
            return null;
        }
        Arrays.sort(ls);
        String decodedBase = URIUtil.decodePath(base);
        String title = "Directory: " + Resource.deTag(decodedBase);
        StringBuilder buf = new StringBuilder(4096);
        buf.append("<HTML><HEAD>");
        buf.append("<LINK HREF=\"").append("jetty-dir.css").append("\" REL=\"stylesheet\" TYPE=\"text/css\"/><TITLE>");
        buf.append(title);
        buf.append("</TITLE></HEAD><BODY>\n<H1>");
        buf.append(title);
        buf.append("</H1>\n<TABLE BORDER=0>\n");
        if (parent) {
            buf.append("<TR><TD><A HREF=\"");
            buf.append(URIUtil.addPaths(base, "../"));
            buf.append("\">Parent Directory</A></TD><TD></TD><TD></TD></TR>\n");
        }
        String encodedBase = Resource.hrefEncodeURI(base);
        DateFormat dfmt = DateFormat.getDateTimeInstance(2, 2);
        for (int i = 0; i < ls.length; ++i) {
            Resource item = this.addPath((String)ls[i]);
            buf.append("\n<TR><TD><A HREF=\"");
            String path = URIUtil.addPaths(encodedBase, URIUtil.encodePath((String)ls[i]));
            buf.append(path);
            if (item.isDirectory() && !path.endsWith("/")) {
                buf.append("/");
            }
            buf.append("\">");
            buf.append(Resource.deTag((String)ls[i]));
            buf.append("&nbsp;");
            buf.append("</A></TD><TD ALIGN=right>");
            buf.append(item.length());
            buf.append(" bytes&nbsp;</TD><TD>");
            buf.append(dfmt.format(new Date(item.lastModified())));
            buf.append("</TD></TR>");
        }
        buf.append("</TABLE>\n");
        buf.append("</BODY></HTML>\n");
        return buf.toString();
    }

    private static String hrefEncodeURI(String raw) {
        char c;
        int i;
        StringBuffer buf = null;
        block9: for (i = 0; i < raw.length(); ++i) {
            c = raw.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': 
                case '<': 
                case '>': {
                    buf = new StringBuffer(raw.length() << 1);
                    break block9;
                }
                default: {
                    continue block9;
                }
            }
        }
        if (buf == null) {
            return raw;
        }
        block10: for (i = 0; i < raw.length(); ++i) {
            c = raw.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append("%22");
                    continue block10;
                }
                case '\'': {
                    buf.append("%27");
                    continue block10;
                }
                case '<': {
                    buf.append("%3C");
                    continue block10;
                }
                case '>': {
                    buf.append("%3E");
                    continue block10;
                }
                default: {
                    buf.append(c);
                    continue block10;
                }
            }
        }
        return buf.toString();
    }

    private static String deTag(String raw) {
        return StringUtil.replace(StringUtil.replace(raw, "<", "&lt;"), ">", "&gt;");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out, long start2, long count) throws IOException {
        InputStream in = this.getInputStream();
        try {
            in.skip(start2);
            if (count < 0L) {
                IO.copy(in, out);
            } else {
                IO.copy(in, out, count);
            }
        }
        finally {
            in.close();
        }
    }

    public void copyTo(File destination) throws IOException {
        if (destination.exists()) {
            throw new IllegalArgumentException(destination + " exists");
        }
        this.writeTo(new FileOutputStream(destination), 0L, -1L);
    }

    public String getWeakETag() {
        try {
            StringBuilder b = new StringBuilder(32);
            b.append("W/\"");
            String name = this.getName();
            int length = name.length();
            long lhash = 0L;
            for (int i = 0; i < length; ++i) {
                lhash = 31L * lhash + (long)name.charAt(i);
            }
            B64Code.encode(this.lastModified() ^ lhash, (Appendable)b);
            B64Code.encode(this.length() ^ lhash, (Appendable)b);
            b.append('\"');
            return b.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL toURL(File file2) throws MalformedURLException {
        return file2.toURI().toURL();
    }
}

