/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.util.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import org.apache.storm.shade.org.eclipse.jetty.util.IO;
import org.apache.storm.shade.org.eclipse.jetty.util.URIUtil;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Log;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Logger;
import org.apache.storm.shade.org.eclipse.jetty.util.resource.Resource;
import org.apache.storm.shade.org.eclipse.jetty.util.resource.URLResource;

public class FileResource
extends URLResource {
    private static final Logger LOG = Log.getLogger(FileResource.class);
    private static boolean __checkAliases = true;
    private File _file;
    private transient URL _alias = null;
    private transient boolean _aliasChecked = false;

    public static void setCheckAliases(boolean checkAliases) {
        __checkAliases = checkAliases;
    }

    public static boolean getCheckAliases() {
        return __checkAliases;
    }

    public FileResource(URL url2) throws IOException, URISyntaxException {
        super(url2, null);
        try {
            this._file = new File(new URI(url2.toString()));
        }
        catch (URISyntaxException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.ignore(e);
            try {
                String file_url = "file:" + URIUtil.encodePath(url2.toString().substring(5));
                URI uri = new URI(file_url);
                this._file = uri.getAuthority() == null ? new File(uri) : new File("//" + uri.getAuthority() + URIUtil.decodePath(url2.getFile()));
            }
            catch (Exception e2) {
                LOG.ignore(e2);
                this.checkConnection();
                Permission perm = this._connection.getPermission();
                this._file = new File(perm == null ? url2.getFile() : perm.getName());
            }
        }
        if (this._file.isDirectory()) {
            if (!this._urlString.endsWith("/")) {
                this._urlString = this._urlString + "/";
            }
        } else if (this._urlString.endsWith("/")) {
            this._urlString = this._urlString.substring(0, this._urlString.length() - 1);
        }
    }

    FileResource(URL url2, URLConnection connection, File file2) {
        super(url2, connection);
        this._file = file2;
        if (this._file.isDirectory() && !this._urlString.endsWith("/")) {
            this._urlString = this._urlString + "/";
        }
    }

    public Resource addPath(String path) throws IOException, MalformedURLException {
        URLResource r = null;
        String url2 = null;
        if ("/".equals(path = URIUtil.canonicalPath(path))) {
            return this;
        }
        if (!this.isDirectory()) {
            r = (FileResource)super.addPath(path);
            url2 = r._urlString;
        } else {
            if (path == null) {
                throw new MalformedURLException();
            }
            String rel = path;
            if (path.startsWith("/")) {
                rel = path.substring(1);
            }
            url2 = URIUtil.addPaths(this._urlString, URIUtil.encodePath(rel));
            r = (URLResource)Resource.newResource(url2);
        }
        String encoded = URIUtil.encodePath(path);
        int expected = r.toString().length() - encoded.length();
        int index = r._urlString.lastIndexOf(encoded, expected);
        if (expected != index && (expected - 1 != index || path.endsWith("/") || !r.isDirectory()) && r instanceof FileResource) {
            ((FileResource)r)._alias = ((FileResource)r)._file.getCanonicalFile().toURI().toURL();
            ((FileResource)r)._aliasChecked = true;
        }
        return r;
    }

    public URL getAlias() {
        if (__checkAliases && !this._aliasChecked) {
            try {
                String abs2 = this._file.getAbsolutePath();
                String can = this._file.getCanonicalPath();
                if (abs2.length() != can.length() || !abs2.equals(can)) {
                    this._alias = Resource.toURL(new File(can));
                }
                this._aliasChecked = true;
                if (this._alias != null && LOG.isDebugEnabled()) {
                    LOG.debug("ALIAS abs=" + abs2, new Object[0]);
                    LOG.debug("ALIAS can=" + can, new Object[0]);
                }
            }
            catch (Exception e) {
                LOG.warn("EXCEPTION ", e);
                return this.getURL();
            }
        }
        return this._alias;
    }

    public boolean exists() {
        return this._file.exists();
    }

    public long lastModified() {
        return this._file.lastModified();
    }

    public boolean isDirectory() {
        return this._file.isDirectory();
    }

    public long length() {
        return this._file.length();
    }

    public String getName() {
        return this._file.getAbsolutePath();
    }

    public File getFile() {
        return this._file;
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this._file);
    }

    public OutputStream getOutputStream() throws IOException, SecurityException {
        return new FileOutputStream(this._file);
    }

    public boolean delete() throws SecurityException {
        return this._file.delete();
    }

    public boolean renameTo(Resource dest) throws SecurityException {
        if (dest instanceof FileResource) {
            return this._file.renameTo(((FileResource)dest)._file);
        }
        return false;
    }

    public String[] list() {
        String[] list2 = this._file.list();
        if (list2 == null) {
            return null;
        }
        int i = list2.length;
        while (i-- > 0) {
            if (!new File(this._file, list2[i]).isDirectory() || list2[i].endsWith("/")) continue;
            int n = i;
            list2[n] = list2[n] + "/";
        }
        return list2;
    }

    public String encode(String uri) {
        return uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || !(o instanceof FileResource)) {
            return false;
        }
        FileResource f = (FileResource)o;
        return f._file == this._file || null != this._file && this._file.equals(f._file);
    }

    public int hashCode() {
        return null == this._file ? super.hashCode() : this._file.hashCode();
    }

    public void copyTo(File destination) throws IOException {
        if (this.isDirectory()) {
            IO.copyDir(this.getFile(), destination);
        } else {
            if (destination.exists()) {
                throw new IllegalArgumentException(destination + " exists");
            }
            IO.copy(this.getFile(), destination);
        }
    }
}

