/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.util.component;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.storm.shade.org.eclipse.jetty.util.IO;
import org.apache.storm.shade.org.eclipse.jetty.util.component.Destroyable;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Log;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Logger;
import org.apache.storm.shade.org.eclipse.jetty.util.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDestroyable
implements Destroyable {
    private static final Logger LOG = Log.getLogger(FileDestroyable.class);
    final List<File> _files = new ArrayList<File>();

    public FileDestroyable() {
    }

    public FileDestroyable(String file2) throws IOException {
        this._files.add(Resource.newResource(file2).getFile());
    }

    public FileDestroyable(File file2) {
        this._files.add(file2);
    }

    public void addFile(String file2) throws IOException {
        this._files.add(Resource.newResource(file2).getFile());
    }

    public void addFile(File file2) {
        this._files.add(file2);
    }

    public void addFiles(Collection<File> files2) {
        this._files.addAll(files2);
    }

    public void removeFile(String file2) throws IOException {
        this._files.remove(Resource.newResource(file2).getFile());
    }

    public void removeFile(File file2) {
        this._files.remove(file2);
    }

    @Override
    public void destroy() {
        for (File file2 : this._files) {
            if (!file2.exists()) continue;
            LOG.debug("Destroy {}", file2);
            IO.delete(file2);
        }
    }
}

