/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.util;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.storm.shade.org.eclipse.jetty.util.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Loader {
    public static URL getResource(Class<?> loadClass, String name, boolean checkParents) {
        URL url2 = null;
        ClassLoader loader2 = Thread.currentThread().getContextClassLoader();
        while (url2 == null && loader2 != null) {
            url2 = loader2.getResource(name);
            loader2 = url2 == null && checkParents ? loader2.getParent() : null;
        }
        ClassLoader classLoader = loader2 = loadClass == null ? null : loadClass.getClassLoader();
        while (url2 == null && loader2 != null) {
            url2 = loader2.getResource(name);
            loader2 = url2 == null && checkParents ? loader2.getParent() : null;
        }
        if (url2 == null) {
            url2 = ClassLoader.getSystemResource(name);
        }
        return url2;
    }

    public static Class loadClass(Class loadClass, String name) throws ClassNotFoundException {
        return Loader.loadClass(loadClass, name, false);
    }

    public static Class loadClass(Class loadClass, String name, boolean checkParents) throws ClassNotFoundException {
        Class<?> c;
        ClassNotFoundException ex;
        block12: {
            ex = null;
            c = null;
            ClassLoader loader2 = Thread.currentThread().getContextClassLoader();
            while (c == null && loader2 != null) {
                block10: {
                    try {
                        c = loader2.loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                        if (ex != null) break block10;
                        ex = e;
                    }
                }
                loader2 = c == null && checkParents ? loader2.getParent() : null;
            }
            ClassLoader classLoader = loader2 = loadClass == null ? null : loadClass.getClassLoader();
            while (c == null && loader2 != null) {
                block11: {
                    try {
                        c = loader2.loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                        if (ex != null) break block11;
                        ex = e;
                    }
                }
                loader2 = c == null && checkParents ? loader2.getParent() : null;
            }
            if (c == null) {
                try {
                    c = Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    if (ex != null) break block12;
                    ex = e;
                }
            }
        }
        if (c != null) {
            return c;
        }
        throw ex;
    }

    public static ResourceBundle getResourceBundle(Class<?> loadClass, String name, boolean checkParents, Locale locale) throws MissingResourceException {
        ResourceBundle bundle;
        MissingResourceException ex;
        block12: {
            ex = null;
            bundle = null;
            ClassLoader loader2 = Thread.currentThread().getContextClassLoader();
            while (bundle == null && loader2 != null) {
                block10: {
                    try {
                        bundle = ResourceBundle.getBundle(name, locale, loader2);
                    }
                    catch (MissingResourceException e) {
                        if (ex != null) break block10;
                        ex = e;
                    }
                }
                loader2 = bundle == null && checkParents ? loader2.getParent() : null;
            }
            ClassLoader classLoader = loader2 = loadClass == null ? null : loadClass.getClassLoader();
            while (bundle == null && loader2 != null) {
                block11: {
                    try {
                        bundle = ResourceBundle.getBundle(name, locale, loader2);
                    }
                    catch (MissingResourceException e) {
                        if (ex != null) break block11;
                        ex = e;
                    }
                }
                loader2 = bundle == null && checkParents ? loader2.getParent() : null;
            }
            if (bundle == null) {
                try {
                    bundle = ResourceBundle.getBundle(name, locale);
                }
                catch (MissingResourceException e) {
                    if (ex != null) break block12;
                    ex = e;
                }
            }
        }
        if (bundle != null) {
            return bundle;
        }
        throw ex;
    }

    public static String getClassPath(ClassLoader loader2) throws Exception {
        StringBuilder classpath = new StringBuilder();
        while (loader2 != null && loader2 instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)loader2).getURLs();
            if (urls != null) {
                for (int i = 0; i < urls.length; ++i) {
                    Resource resource = Resource.newResource(urls[i]);
                    File file2 = resource.getFile();
                    if (file2 == null || !file2.exists()) continue;
                    if (classpath.length() > 0) {
                        classpath.append(File.pathSeparatorChar);
                    }
                    classpath.append(file2.getAbsolutePath());
                }
            }
            loader2 = loader2.getParent();
        }
        return classpath.toString();
    }
}

