/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyList
implements Cloneable,
Serializable {
    private static final String[] __EMTPY_STRING_ARRAY = new String[0];

    private LazyList() {
    }

    public static Object add(Object list2, Object item) {
        if (list2 == null) {
            if (item instanceof List || item == null) {
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(item);
                return l;
            }
            return item;
        }
        if (list2 instanceof List) {
            ((List)list2).add(item);
            return list2;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(list2);
        l.add(item);
        return l;
    }

    public static Object add(Object list2, int index, Object item) {
        if (list2 == null) {
            if (index > 0 || item instanceof List || item == null) {
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(index, item);
                return l;
            }
            return item;
        }
        if (list2 instanceof List) {
            ((List)list2).add(index, item);
            return list2;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(list2);
        l.add(index, item);
        return l;
    }

    public static Object addCollection(Object list2, Collection<?> collection) {
        Iterator<?> i = collection.iterator();
        while (i.hasNext()) {
            list2 = LazyList.add(list2, i.next());
        }
        return list2;
    }

    public static Object addArray(Object list2, Object[] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            list2 = LazyList.add(list2, array[i]);
        }
        return list2;
    }

    public static Object ensureSize(Object list2, int initialSize) {
        if (list2 == null) {
            return new ArrayList(initialSize);
        }
        if (list2 instanceof ArrayList) {
            ArrayList ol = (ArrayList)list2;
            if (ol.size() > initialSize) {
                return ol;
            }
            ArrayList nl = new ArrayList(initialSize);
            nl.addAll(ol);
            return nl;
        }
        ArrayList<Object> l = new ArrayList<Object>(initialSize);
        l.add(list2);
        return l;
    }

    public static Object remove(Object list2, Object o) {
        if (list2 == null) {
            return null;
        }
        if (list2 instanceof List) {
            List l = (List)list2;
            l.remove(o);
            if (l.size() == 0) {
                return null;
            }
            return list2;
        }
        if (list2.equals(o)) {
            return null;
        }
        return list2;
    }

    public static Object remove(Object list2, int i) {
        if (list2 == null) {
            return null;
        }
        if (list2 instanceof List) {
            List l = (List)list2;
            l.remove(i);
            if (l.size() == 0) {
                return null;
            }
            return list2;
        }
        if (i == 0) {
            return null;
        }
        return list2;
    }

    public static <E> List<E> getList(Object list2) {
        return LazyList.getList(list2, false);
    }

    public static <E> List<E> getList(Object list2, boolean nullForEmpty) {
        if (list2 == null) {
            if (nullForEmpty) {
                return null;
            }
            return Collections.emptyList();
        }
        if (list2 instanceof List) {
            return (List)list2;
        }
        return Collections.singletonList(list2);
    }

    public static String[] toStringArray(Object list2) {
        if (list2 == null) {
            return __EMTPY_STRING_ARRAY;
        }
        if (list2 instanceof List) {
            List l = (List)list2;
            String[] a = new String[l.size()];
            int i = l.size();
            while (i-- > 0) {
                Object o = l.get(i);
                if (o == null) continue;
                a[i] = o.toString();
            }
            return a;
        }
        return new String[]{list2.toString()};
    }

    public static Object toArray(Object list2, Class<?> clazz) {
        if (list2 == null) {
            return Array.newInstance(clazz, 0);
        }
        if (list2 instanceof List) {
            List l = (List)list2;
            if (clazz.isPrimitive()) {
                Object a = Array.newInstance(clazz, l.size());
                for (int i = 0; i < l.size(); ++i) {
                    Array.set(a, i, l.get(i));
                }
                return a;
            }
            return l.toArray((Object[])Array.newInstance(clazz, l.size()));
        }
        Object a = Array.newInstance(clazz, 1);
        Array.set(a, 0, list2);
        return a;
    }

    public static int size(Object list2) {
        if (list2 == null) {
            return 0;
        }
        if (list2 instanceof List) {
            return ((List)list2).size();
        }
        return 1;
    }

    public static <E> E get(Object list2, int i) {
        if (list2 == null) {
            throw new IndexOutOfBoundsException();
        }
        if (list2 instanceof List) {
            return ((List)list2).get(i);
        }
        if (i == 0) {
            return (E)list2;
        }
        throw new IndexOutOfBoundsException();
    }

    public static boolean contains(Object list2, Object item) {
        if (list2 == null) {
            return false;
        }
        if (list2 instanceof List) {
            return ((List)list2).contains(item);
        }
        return list2.equals(item);
    }

    public static Object clone(Object list2) {
        if (list2 == null) {
            return null;
        }
        if (list2 instanceof List) {
            return new ArrayList((List)list2);
        }
        return list2;
    }

    public static String toString(Object list2) {
        if (list2 == null) {
            return "[]";
        }
        if (list2 instanceof List) {
            return list2.toString();
        }
        return "[" + list2 + "]";
    }

    public static <E> Iterator<E> iterator(Object list2) {
        if (list2 == null) {
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        if (list2 instanceof List) {
            return ((List)list2).iterator();
        }
        List<E> l = LazyList.getList(list2);
        return l.iterator();
    }

    public static <E> ListIterator<E> listIterator(Object list2) {
        if (list2 == null) {
            List empty = Collections.emptyList();
            return empty.listIterator();
        }
        if (list2 instanceof List) {
            return ((List)list2).listIterator();
        }
        List<E> l = LazyList.getList(list2);
        return l.listIterator();
    }

    public static <E> List<E> array2List(E[] array) {
        if (array == null || array.length == 0) {
            return new ArrayList();
        }
        return new ArrayList<E>(Arrays.asList(array));
    }

    public static <T> T[] addToArray(T[] array, T item, Class<?> type) {
        if (array == null) {
            if (type == null && item != null) {
                type = item.getClass();
            }
            Object[] na = (Object[])Array.newInstance(type, 1);
            na[0] = item;
            return na;
        }
        Class<?> c = array.getClass().getComponentType();
        Object[] na = (Object[])Array.newInstance(c, Array.getLength(array) + 1);
        System.arraycopy(array, 0, na, 0, array.length);
        na[array.length] = item;
        return na;
    }

    public static <T> T[] removeFromArray(T[] array, Object item) {
        if (item == null || array == null) {
            return array;
        }
        int i = array.length;
        while (i-- > 0) {
            if (!item.equals(array[i])) continue;
            Class<?> c = array == null ? item.getClass() : array.getClass().getComponentType();
            Object[] na = (Object[])Array.newInstance(c, Array.getLength(array) - 1);
            if (i > 0) {
                System.arraycopy(array, 0, na, 0, i);
            }
            if (i + 1 < array.length) {
                System.arraycopy(array, i + 1, na, i, array.length - (i + 1));
            }
            return na;
        }
        return array;
    }
}

