/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.servlets;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.storm.shade.org.eclipse.jetty.util.IO;
import org.apache.storm.shade.org.eclipse.jetty.util.URIUtil;

public class PutFilter
implements Filter {
    public static final String __PUT = "PUT";
    public static final String __DELETE = "DELETE";
    public static final String __MOVE = "MOVE";
    public static final String __OPTIONS = "OPTIONS";
    Set<String> _operations = new HashSet<String>();
    private ConcurrentMap<String, String> _hidden = new ConcurrentHashMap<String, String>();
    private ServletContext _context;
    private String _baseURI;
    private boolean _delAllowed;
    private boolean _putAtomic;
    private File _tmpdir;

    public void init(FilterConfig config2) throws ServletException {
        this._context = config2.getServletContext();
        this._tmpdir = (File)this._context.getAttribute("javax.servlet.context.tempdir");
        if (this._context.getRealPath("/") == null) {
            throw new UnavailableException("Packed war");
        }
        String b = config2.getInitParameter("baseURI");
        if (b != null) {
            this._baseURI = b;
        } else {
            File base = new File(this._context.getRealPath("/"));
            this._baseURI = base.toURI().toString();
        }
        this._delAllowed = this.getInitBoolean(config2, "delAllowed");
        this._putAtomic = this.getInitBoolean(config2, "putAtomic");
        this._operations.add(__OPTIONS);
        this._operations.add(__PUT);
        if (this._delAllowed) {
            this._operations.add(__DELETE);
            this._operations.add(__MOVE);
        }
    }

    private boolean getInitBoolean(FilterConfig config2, String name) {
        String value = config2.getInitParameter(name);
        return value != null && value.length() > 0 && (value.startsWith("t") || value.startsWith("T") || value.startsWith("y") || value.startsWith("Y") || value.startsWith("1"));
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        block11: {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response2 = (HttpServletResponse)res;
            String servletPath = request.getServletPath();
            String pathInfo = request.getPathInfo();
            String pathInContext = URIUtil.addPaths(servletPath, pathInfo);
            String resource = URIUtil.addPaths(this._baseURI, pathInContext);
            String method = request.getMethod();
            boolean op = this._operations.contains(method);
            if (op) {
                File file2 = null;
                try {
                    if (method.equals(__OPTIONS)) {
                        this.handleOptions(chain, request, response2);
                        break block11;
                    }
                    file2 = new File(new URI(resource));
                    boolean exists2 = file2.exists();
                    if (exists2 && !this.passConditionalHeaders(request, response2, file2)) {
                        return;
                    }
                    if (method.equals(__PUT)) {
                        this.handlePut(request, response2, pathInContext, file2);
                        break block11;
                    }
                    if (method.equals(__DELETE)) {
                        this.handleDelete(request, response2, pathInContext, file2);
                        break block11;
                    }
                    if (method.equals(__MOVE)) {
                        this.handleMove(request, response2, pathInContext, file2);
                        break block11;
                    }
                    throw new IllegalStateException();
                }
                catch (Exception e) {
                    this._context.log(e.toString(), (Throwable)e);
                    response2.sendError(500);
                }
            } else {
                if (this.isHidden(pathInContext)) {
                    response2.sendError(404);
                } else {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response2);
                }
                return;
            }
        }
    }

    private boolean isHidden(String pathInContext) {
        return this._hidden.containsKey(pathInContext);
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePut(HttpServletRequest request, HttpServletResponse response2, String pathInContext, File file2) throws ServletException, IOException {
        boolean exists2 = file2.exists();
        if (pathInContext.endsWith("/")) {
            if (!exists2) {
                if (!file2.mkdirs()) {
                    response2.sendError(403);
                } else {
                    response2.setStatus(201);
                    response2.flushBuffer();
                }
            } else {
                response2.setStatus(200);
                response2.flushBuffer();
            }
        } else {
            boolean ok = false;
            try {
                this._hidden.put(pathInContext, pathInContext);
                File parent = file2.getParentFile();
                parent.mkdirs();
                int toRead = request.getContentLength();
                ServletInputStream in = request.getInputStream();
                if (this._putAtomic) {
                    File tmp = File.createTempFile(file2.getName(), null, this._tmpdir);
                    FileOutputStream out = new FileOutputStream(tmp, false);
                    if (toRead >= 0) {
                        IO.copy((InputStream)in, out, (long)toRead);
                    } else {
                        IO.copy((InputStream)in, out);
                    }
                    ((OutputStream)out).close();
                    if (!tmp.renameTo(file2)) {
                        throw new IOException("rename from " + tmp + " to " + file2 + " failed");
                    }
                } else {
                    FileOutputStream out = new FileOutputStream(file2, false);
                    if (toRead >= 0) {
                        IO.copy((InputStream)in, out, (long)toRead);
                    } else {
                        IO.copy((InputStream)in, out);
                    }
                    ((OutputStream)out).close();
                }
                response2.setStatus(exists2 ? 200 : 201);
                response2.flushBuffer();
                ok = true;
            }
            catch (Exception ex) {
                this._context.log(ex.toString(), (Throwable)ex);
                response2.sendError(403);
            }
            finally {
                if (!ok) {
                    try {
                        if (file2.exists()) {
                            file2.delete();
                        }
                    }
                    catch (Exception e) {
                        this._context.log(e.toString(), (Throwable)e);
                    }
                }
                this._hidden.remove(pathInContext);
            }
        }
    }

    public void handleDelete(HttpServletRequest request, HttpServletResponse response2, String pathInContext, File file2) throws ServletException, IOException {
        try {
            if (file2.delete()) {
                response2.setStatus(204);
                response2.flushBuffer();
            } else {
                response2.sendError(403);
            }
        }
        catch (SecurityException sex) {
            this._context.log(sex.toString(), (Throwable)sex);
            response2.sendError(403);
        }
    }

    public void handleMove(HttpServletRequest request, HttpServletResponse response2, String pathInContext, File file2) throws ServletException, IOException, URISyntaxException {
        String newPath = URIUtil.canonicalPath(request.getHeader("new-uri"));
        if (newPath == null) {
            response2.sendError(400);
            return;
        }
        String contextPath = request.getContextPath();
        if (contextPath != null && !newPath.startsWith(contextPath)) {
            response2.sendError(405);
            return;
        }
        String newInfo = newPath;
        if (contextPath != null) {
            newInfo = newInfo.substring(contextPath.length());
        }
        String new_resource = URIUtil.addPaths(this._baseURI, newInfo);
        File new_file = new File(new URI(new_resource));
        file2.renameTo(new_file);
        response2.setStatus(204);
        response2.flushBuffer();
    }

    public void handleOptions(FilterChain chain, HttpServletRequest request, HttpServletResponse response2) throws IOException, ServletException {
        chain.doFilter((ServletRequest)request, (ServletResponse)new HttpServletResponseWrapper(response2){

            public void setHeader(String name, String value) {
                if ("Allow".equalsIgnoreCase(name)) {
                    HashSet<String> options = new HashSet<String>();
                    options.addAll(Arrays.asList(value.split(" *, *")));
                    options.addAll(PutFilter.this._operations);
                    value = null;
                    for (String o : options) {
                        value = value == null ? o : value + ", " + o;
                    }
                }
                super.setHeader(name, value);
            }
        });
    }

    protected boolean passConditionalHeaders(HttpServletRequest request, HttpServletResponse response2, File file2) throws IOException {
        long date = 0L;
        date = request.getDateHeader("if-unmodified-since");
        if (date > 0L && file2.lastModified() / 1000L > date / 1000L) {
            response2.sendError(412);
            return false;
        }
        date = request.getDateHeader("if-modified-since");
        if (date > 0L && file2.lastModified() / 1000L <= date / 1000L) {
            response2.reset();
            response2.setStatus(304);
            response2.flushBuffer();
            return false;
        }
        return true;
    }
}

