/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.servlets;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.storm.shade.org.eclipse.jetty.http.MimeTypes;
import org.apache.storm.shade.org.eclipse.jetty.io.ByteArrayBuffer;
import org.apache.storm.shade.org.eclipse.jetty.util.B64Code;
import org.apache.storm.shade.org.eclipse.jetty.util.LazyList;
import org.apache.storm.shade.org.eclipse.jetty.util.MultiMap;
import org.apache.storm.shade.org.eclipse.jetty.util.QuotedStringTokenizer;
import org.apache.storm.shade.org.eclipse.jetty.util.ReadLineInputStream;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Log;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Logger;

public class MultiPartFilter
implements Filter {
    private static final Logger LOG = Log.getLogger(MultiPartFilter.class);
    public static final String CONTENT_TYPE_SUFFIX = ".org.apache.storm.shade.org.eclipse.jetty.servlet.contentType";
    private static final String FILES = "org.apache.storm.shade.org.eclipse.jetty.servlet.MultiPartFilter.files";
    private File tempdir;
    private boolean _deleteFiles;
    private ServletContext _context;
    private int _fileOutputBuffer = 0;
    private int _maxFormKeys = Integer.getInteger("org.apache.storm.shade.org.eclipse.jetty.server.Request.maxFormKeys", 1000);

    public void init(FilterConfig filterConfig) throws ServletException {
        this.tempdir = (File)filterConfig.getServletContext().getAttribute("javax.servlet.context.tempdir");
        this._deleteFiles = "true".equals(filterConfig.getInitParameter("deleteFiles"));
        String fileOutputBuffer = filterConfig.getInitParameter("fileOutputBuffer");
        if (fileOutputBuffer != null) {
            this._fileOutputBuffer = Integer.parseInt(fileOutputBuffer);
        }
        this._context = filterConfig.getServletContext();
        String mfks = filterConfig.getInitParameter("maxFormKeys");
        if (mfks != null) {
            this._maxFormKeys = Integer.parseInt(mfks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response2, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest srequest = (HttpServletRequest)request;
        if (srequest.getContentType() == null || !srequest.getContentType().startsWith("multipart/form-data")) {
            chain.doFilter(request, response2);
            return;
        }
        InputStream in = new ReadLineInputStream((InputStream)request.getInputStream());
        String content_type2 = srequest.getContentType();
        String contentTypeBoundary = "";
        int bstart = content_type2.indexOf("boundary=");
        if (bstart >= 0) {
            int bend = content_type2.indexOf(";", bstart);
            bend = bend < 0 ? content_type2.length() : bend;
            contentTypeBoundary = QuotedStringTokenizer.unquote(this.value(content_type2.substring(bstart, bend)).trim());
        }
        String boundary = "--" + contentTypeBoundary;
        byte[] byteBoundary = (boundary + "--").getBytes("ISO-8859-1");
        MultiMap params2 = new MultiMap();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String[]) {
                params2.addValues(entry.getKey(), (String[])value);
                continue;
            }
            params2.add(entry.getKey(), value);
        }
        boolean badFormatLogged = false;
        try {
            String line = ((ReadLineInputStream)in).readLine();
            if (line == null) {
                throw new IOException("Missing content for multipart request");
            }
            line = line.trim();
            while (line != null && !line.equals(boundary)) {
                if (!badFormatLogged) {
                    LOG.warn("Badly formatted multipart request", new Object[0]);
                    badFormatLogged = true;
                }
                line = (line = ((ReadLineInputStream)in).readLine()) == null ? line : line.trim();
            }
            if (line == null) {
                throw new IOException("Missing initial multi part boundary");
            }
            boolean lastPart = false;
            block10: while (!lastPart && params2.size() < this._maxFormKeys) {
                String type_content = null;
                String content_disposition = null;
                String content_transfer_encoding = null;
                while ((line = ((ReadLineInputStream)in).readLine()) != null) {
                    if (!"".equals(line)) {
                        int c = line.indexOf(58, 0);
                        if (c <= 0) continue;
                        String key = line.substring(0, c).trim().toLowerCase(Locale.ENGLISH);
                        String value = line.substring(c + 1, line.length()).trim();
                        if (key.equals("content-disposition")) {
                            content_disposition = value;
                            continue;
                        }
                        if (key.equals("content-transfer-encoding")) {
                            content_transfer_encoding = value;
                            continue;
                        }
                        if (!key.equals("content-type")) continue;
                        type_content = value;
                        continue;
                    }
                    boolean form_data = false;
                    if (content_disposition == null) {
                        throw new IOException("Missing content-disposition");
                    }
                    LOG.debug("Content-Disposition: {}", content_disposition);
                    QuotedStringTokenizer tok = new QuotedStringTokenizer(content_disposition, ";", false, true);
                    String name = null;
                    String filename = null;
                    while (tok.hasMoreTokens()) {
                        String t = tok.nextToken().trim();
                        String tl = t.toLowerCase();
                        if (t.startsWith("form-data")) {
                            form_data = true;
                            continue;
                        }
                        if (tl.startsWith("name=")) {
                            name = this.value(t);
                            continue;
                        }
                        if (!tl.startsWith("filename=")) continue;
                        filename = this.filenameValue(t);
                    }
                    if (!form_data || name == null) continue block10;
                    OutputStream out = null;
                    File file2 = null;
                    try {
                        if (filename != null && filename.length() > 0) {
                            LOG.debug("filename = \"{}\"", filename);
                            file2 = File.createTempFile("MultiPart", "", this.tempdir);
                            out = new FileOutputStream(file2);
                            if (this._fileOutputBuffer > 0) {
                                out = new BufferedOutputStream(out, this._fileOutputBuffer);
                            }
                            request.setAttribute(name, (Object)file2);
                            params2.add(name, filename);
                            if (type_content != null) {
                                params2.add(name + CONTENT_TYPE_SUFFIX, type_content);
                            }
                            if (this._deleteFiles) {
                                file2.deleteOnExit();
                                ArrayList<File> files2 = (ArrayList<File>)request.getAttribute(FILES);
                                if (files2 == null) {
                                    files2 = new ArrayList<File>();
                                    request.setAttribute(FILES, files2);
                                }
                                files2.add(file2);
                            }
                        } else {
                            out = new ByteArrayOutputStream();
                        }
                        if ("base64".equalsIgnoreCase(content_transfer_encoding)) {
                            in = new Base64InputStream((ReadLineInputStream)in);
                        } else if ("quoted-printable".equalsIgnoreCase(content_transfer_encoding)) {
                            in = new FilterInputStream(in){

                                public int read() throws IOException {
                                    int c = this.in.read();
                                    if (c >= 0 && c == 61) {
                                        int hi = this.in.read();
                                        int lo = this.in.read();
                                        if (hi < 0 || lo < 0) {
                                            throw new IOException("Unexpected end to quoted-printable byte");
                                        }
                                        char[] chars = new char[]{(char)hi, (char)lo};
                                        c = Integer.parseInt(new String(chars), 16);
                                    }
                                    return c;
                                }
                            };
                        }
                        int state = -2;
                        boolean cr = false;
                        boolean lf = false;
                        while (true) {
                            int c;
                            int b = 0;
                            while ((c = state != -2 ? state : in.read()) != -1) {
                                state = -2;
                                if (c == 13 || c == 10) {
                                    if (c != 13) break;
                                    in.mark(1);
                                    int tmp = in.read();
                                    if (tmp != 10) {
                                        in.reset();
                                        break;
                                    }
                                    state = tmp;
                                    break;
                                }
                                if (b >= 0 && b < byteBoundary.length && c == byteBoundary[b]) {
                                    ++b;
                                    continue;
                                }
                                if (cr) {
                                    out.write(13);
                                }
                                if (lf) {
                                    out.write(10);
                                }
                                lf = false;
                                cr = false;
                                if (b > 0) {
                                    out.write(byteBoundary, 0, b);
                                }
                                b = -1;
                                out.write(c);
                            }
                            if (b > 0 && b < byteBoundary.length - 2 || b == byteBoundary.length - 1) {
                                if (cr) {
                                    out.write(13);
                                }
                                if (lf) {
                                    out.write(10);
                                }
                                lf = false;
                                cr = false;
                                out.write(byteBoundary, 0, b);
                                b = -1;
                            }
                            if (b > 0 || c == -1) {
                                if (b == byteBoundary.length) {
                                    lastPart = true;
                                }
                                if (state == 10) {
                                    state = -2;
                                }
                                break;
                            }
                            if (cr) {
                                out.write(13);
                            }
                            if (lf) {
                                out.write(10);
                            }
                            cr = c == 13;
                            boolean bl = lf = c == 10 || state == 10;
                            if (state != 10) continue;
                            state = -2;
                        }
                    }
                    finally {
                        out.close();
                    }
                    if (file2 != null) continue block10;
                    byte[] bytes = ((ByteArrayOutputStream)out).toByteArray();
                    params2.add(name, bytes);
                    if (type_content == null) continue block10;
                    params2.add(name + CONTENT_TYPE_SUFFIX, type_content);
                    continue block10;
                }
                break block10;
            }
            chain.doFilter((ServletRequest)new Wrapper(srequest, params2), response2);
        }
        catch (IOException e) {
            if (!badFormatLogged) {
                LOG.warn("Badly formatted multipart request", new Object[0]);
            }
            throw e;
        }
        finally {
            this.deleteFiles(request);
        }
    }

    private void deleteFiles(ServletRequest request) {
        ArrayList files2 = (ArrayList)request.getAttribute(FILES);
        if (files2 != null) {
            for (File file2 : files2) {
                try {
                    file2.delete();
                }
                catch (Exception e) {
                    this._context.log("failed to delete " + file2, (Throwable)e);
                }
            }
        }
    }

    private String value(String nameEqualsValue) {
        int idx = nameEqualsValue.indexOf(61);
        String value = nameEqualsValue.substring(idx + 1).trim();
        return QuotedStringTokenizer.unquoteOnly(value);
    }

    private String filenameValue(String nameEqualsValue) {
        int idx = nameEqualsValue.indexOf(61);
        String value = nameEqualsValue.substring(idx + 1).trim();
        if (value.matches(".??[a-z,A-Z]\\:\\\\[^\\\\].*")) {
            char last;
            char first = value.charAt(0);
            if (first == '\"' || first == '\'') {
                value = value.substring(1);
            }
            if ((last = value.charAt(value.length() - 1)) == '\"' || last == '\'') {
                value = value.substring(0, value.length() - 1);
            }
            return value;
        }
        return QuotedStringTokenizer.unquoteOnly(value, true);
    }

    public void destroy() {
    }

    private static class Base64InputStream
    extends InputStream {
        ReadLineInputStream _in;
        String _line;
        byte[] _buffer;
        int _pos;

        public Base64InputStream(ReadLineInputStream in) {
            this._in = in;
        }

        public int read() throws IOException {
            if (this._buffer == null || this._pos >= this._buffer.length) {
                this._line = this._in.readLine();
                System.err.println("LINE: " + this._line);
                if (this._line == null) {
                    return -1;
                }
                if (this._line.startsWith("--")) {
                    this._buffer = (this._line + "\r\n").getBytes();
                } else if (this._line.length() == 0) {
                    this._buffer = "\r\n".getBytes();
                } else {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream(4 * this._line.length() / 3);
                    B64Code.decode(this._line, bout);
                    bout.write(13);
                    bout.write(10);
                    this._buffer = bout.toByteArray();
                }
                this._pos = 0;
            }
            return this._buffer[this._pos++];
        }
    }

    private static class Wrapper
    extends HttpServletRequestWrapper {
        String _encoding = "UTF-8";
        MultiMap _params;

        public Wrapper(HttpServletRequest request, MultiMap map) {
            super(request);
            this._params = map;
        }

        public int getContentLength() {
            return 0;
        }

        public String getParameter(String name) {
            Object o = this._params.get(name);
            if (!(o instanceof byte[]) && LazyList.size(o) > 0) {
                o = LazyList.get(o, 0);
            }
            if (o instanceof byte[]) {
                try {
                    return this.getParameterBytesAsString(name, (byte[])o);
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            } else if (o != null) {
                return String.valueOf(o);
            }
            return null;
        }

        public Map getParameterMap() {
            HashMap<String, String[]> cmap = new HashMap<String, String[]>();
            for (Object key : this._params.keySet()) {
                cmap.put((String)key, this.getParameterValues((String)key));
            }
            return Collections.unmodifiableMap(cmap);
        }

        public Enumeration getParameterNames() {
            return Collections.enumeration(this._params.keySet());
        }

        public String[] getParameterValues(String name) {
            List<Object> l = this._params.getValues(name);
            if (l == null || l.size() == 0) {
                return new String[0];
            }
            String[] v = new String[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                Object o = l.get(i);
                if (o instanceof byte[]) {
                    try {
                        v[i] = this.getParameterBytesAsString(name, (byte[])o);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!(o instanceof String)) continue;
                v[i] = (String)o;
            }
            return v;
        }

        public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
            this._encoding = enc;
        }

        private String getParameterBytesAsString(String name, byte[] bytes) throws UnsupportedEncodingException {
            Object ct = this._params.get(name + MultiPartFilter.CONTENT_TYPE_SUFFIX);
            String contentType = this._encoding;
            if (ct != null) {
                String tmp = MimeTypes.getCharsetFromContentType(new ByteArrayBuffer((String)ct));
                contentType = tmp == null ? this._encoding : tmp;
            }
            return new String(bytes, contentType);
        }
    }
}

