/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.servlet.listener;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.storm.shade.org.eclipse.jetty.util.Loader;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Log;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Logger;

public class ELContextCleaner
implements ServletContextListener {
    private static final Logger LOG = Log.getLogger(ELContextCleaner.class);

    public void contextInitialized(ServletContextEvent sce) {
    }

    public void contextDestroyed(ServletContextEvent sce) {
        try {
            Class beanELResolver = Loader.loadClass(this.getClass(), "javax.el.BeanELResolver");
            Field field = this.getField(beanELResolver);
            this.purgeEntries(field);
            LOG.info("javax.el.BeanELResolver purged", new Object[0]);
        }
        catch (ClassNotFoundException e) {
        }
        catch (SecurityException e) {
            LOG.warn("Cannot purge classes from javax.el.BeanELResolver", e);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Cannot purge classes from javax.el.BeanELResolver", e);
        }
        catch (IllegalAccessException e) {
            LOG.warn("Cannot purge classes from javax.el.BeanELResolver", e);
        }
        catch (NoSuchFieldException e) {
            LOG.info("Not cleaning cached beans: no such field javax.el.BeanELResolver.properties", new Object[0]);
        }
    }

    protected Field getField(Class beanELResolver) throws SecurityException, NoSuchFieldException {
        if (beanELResolver == null) {
            return null;
        }
        return beanELResolver.getDeclaredField("properties");
    }

    protected void purgeEntries(Field properties) throws IllegalArgumentException, IllegalAccessException {
        ConcurrentHashMap map;
        if (properties == null) {
            return;
        }
        if (!properties.isAccessible()) {
            properties.setAccessible(true);
        }
        if ((map = (ConcurrentHashMap)properties.get(null)) == null) {
            return;
        }
        Iterator itor = map.keySet().iterator();
        while (itor.hasNext()) {
            Class clazz = (Class)itor.next();
            LOG.info("Clazz: " + clazz + " loaded by " + clazz.getClassLoader(), new Object[0]);
            if (Thread.currentThread().getContextClassLoader().equals(clazz.getClassLoader())) {
                itor.remove();
                LOG.info("removed", new Object[0]);
                continue;
            }
            LOG.info("not removed: contextclassloader=" + Thread.currentThread().getContextClassLoader() + "clazz's classloader=" + clazz.getClassLoader(), new Object[0]);
        }
    }
}

