/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.storm.shade.org.eclipse.jetty.server.Connector;
import org.apache.storm.shade.org.eclipse.jetty.server.Server;
import org.apache.storm.shade.org.eclipse.jetty.server.handler.ContextHandler;
import org.apache.storm.shade.org.eclipse.jetty.server.handler.StatisticsHandler;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Log;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Logger;

public class StatisticsServlet
extends HttpServlet {
    private static final Logger LOG = Log.getLogger(StatisticsServlet.class);
    boolean _restrictToLocalhost = true;
    private StatisticsHandler _statsHandler;
    private MemoryMXBean _memoryBean;
    private Connector[] _connectors;

    public void init() throws ServletException {
        ServletContext context2 = this.getServletContext();
        ContextHandler.Context scontext = (ContextHandler.Context)context2;
        Server _server = scontext.getContextHandler().getServer();
        StatisticsHandler handler2 = _server.getChildHandlerByClass(StatisticsHandler.class);
        if (handler2 == null) {
            LOG.warn("Statistics Handler not installed!", new Object[0]);
            return;
        }
        this._statsHandler = handler2;
        this._memoryBean = ManagementFactory.getMemoryMXBean();
        this._connectors = _server.getConnectors();
        if (this.getInitParameter("restrictToLocalhost") != null) {
            this._restrictToLocalhost = "true".equals(this.getInitParameter("restrictToLocalhost"));
        }
    }

    public void doPost(HttpServletRequest sreq, HttpServletResponse sres) throws ServletException, IOException {
        this.doGet(sreq, sres);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this._statsHandler == null) {
            LOG.warn("Statistics Handler not installed!", new Object[0]);
            resp.sendError(503);
            return;
        }
        if (this._restrictToLocalhost && !this.isLoopbackAddress(req.getRemoteAddr())) {
            resp.sendError(503);
            return;
        }
        String wantXml = req.getParameter("xml");
        if (wantXml == null) {
            wantXml = req.getParameter("XML");
        }
        if (wantXml != null && "true".equalsIgnoreCase(wantXml)) {
            this.sendXmlResponse(resp);
        } else {
            this.sendTextResponse(resp);
        }
    }

    private boolean isLoopbackAddress(String address) {
        try {
            InetAddress addr = InetAddress.getByName(address);
            return addr.isLoopbackAddress();
        }
        catch (UnknownHostException e) {
            LOG.warn("Warning: attempt to access statistics servlet from " + address, e);
            return false;
        }
    }

    private void sendXmlResponse(HttpServletResponse response2) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<statistics>\n");
        sb.append("  <requests>\n");
        sb.append("    <statsOnMs>").append(this._statsHandler.getStatsOnMs()).append("</statsOnMs>\n");
        sb.append("    <requests>").append(this._statsHandler.getRequests()).append("</requests>\n");
        sb.append("    <requestsActive>").append(this._statsHandler.getRequestsActive()).append("</requestsActive>\n");
        sb.append("    <requestsActiveMax>").append(this._statsHandler.getRequestsActiveMax()).append("</requestsActiveMax>\n");
        sb.append("    <requestsTimeTotal>").append(this._statsHandler.getRequestTimeTotal()).append("</requestsTimeTotal>\n");
        sb.append("    <requestsTimeMean>").append(this._statsHandler.getRequestTimeMean()).append("</requestsTimeMean>\n");
        sb.append("    <requestsTimeMax>").append(this._statsHandler.getRequestTimeMax()).append("</requestsTimeMax>\n");
        sb.append("    <requestsTimeStdDev>").append(this._statsHandler.getRequestTimeStdDev()).append("</requestsTimeStdDev>\n");
        sb.append("    <dispatched>").append(this._statsHandler.getDispatched()).append("</dispatched>\n");
        sb.append("    <dispatchedActive>").append(this._statsHandler.getDispatchedActive()).append("</dispatchedActive>\n");
        sb.append("    <dispatchedActiveMax>").append(this._statsHandler.getDispatchedActiveMax()).append("</dispatchedActiveMax>\n");
        sb.append("    <dispatchedTimeTotal>").append(this._statsHandler.getDispatchedTimeTotal()).append("</dispatchedTimeTotal>\n");
        sb.append("    <dispatchedTimeMean>").append(this._statsHandler.getDispatchedTimeMean()).append("</dispatchedTimeMean>\n");
        sb.append("    <dispatchedTimeMax>").append(this._statsHandler.getDispatchedTimeMax()).append("</dispatchedTimeMax>\n");
        sb.append("    <dispatchedTimeStdDev").append(this._statsHandler.getDispatchedTimeStdDev()).append("</dispatchedTimeStdDev>\n");
        sb.append("    <requestsSuspended>").append(this._statsHandler.getSuspends()).append("</requestsSuspended>\n");
        sb.append("    <requestsExpired>").append(this._statsHandler.getExpires()).append("</requestsExpired>\n");
        sb.append("    <requestsResumed>").append(this._statsHandler.getResumes()).append("</requestsResumed>\n");
        sb.append("  </requests>\n");
        sb.append("  <responses>\n");
        sb.append("    <responses1xx>").append(this._statsHandler.getResponses1xx()).append("</responses1xx>\n");
        sb.append("    <responses2xx>").append(this._statsHandler.getResponses2xx()).append("</responses2xx>\n");
        sb.append("    <responses3xx>").append(this._statsHandler.getResponses3xx()).append("</responses3xx>\n");
        sb.append("    <responses4xx>").append(this._statsHandler.getResponses4xx()).append("</responses4xx>\n");
        sb.append("    <responses5xx>").append(this._statsHandler.getResponses5xx()).append("</responses5xx>\n");
        sb.append("    <responsesBytesTotal>").append(this._statsHandler.getResponsesBytesTotal()).append("</responsesBytesTotal>\n");
        sb.append("  </responses>\n");
        sb.append("  <connections>\n");
        for (Connector connector : this._connectors) {
            sb.append("    <connector>\n");
            sb.append("      <name>").append(connector.getName()).append("</name>\n");
            sb.append("      <statsOn>").append(connector.getStatsOn()).append("</statsOn>\n");
            if (connector.getStatsOn()) {
                sb.append("    <statsOnMs>").append(connector.getStatsOnMs()).append("</statsOnMs>\n");
                sb.append("    <connections>").append(connector.getConnections()).append("</connections>\n");
                sb.append("    <connectionsOpen>").append(connector.getConnectionsOpen()).append("</connectionsOpen>\n");
                sb.append("    <connectionsOpenMax>").append(connector.getConnectionsOpenMax()).append("</connectionsOpenMax>\n");
                sb.append("    <connectionsDurationTotal>").append(connector.getConnectionsDurationTotal()).append("</connectionsDurationTotal>\n");
                sb.append("    <connectionsDurationMean>").append(connector.getConnectionsDurationMean()).append("</connectionsDurationMean>\n");
                sb.append("    <connectionsDurationMax>").append(connector.getConnectionsDurationMax()).append("</connectionsDurationMax>\n");
                sb.append("    <connectionsDurationStdDev>").append(connector.getConnectionsDurationStdDev()).append("</connectionsDurationStdDev>\n");
                sb.append("    <requests>").append(connector.getRequests()).append("</requests>\n");
                sb.append("    <connectionsRequestsMean>").append(connector.getConnectionsRequestsMean()).append("</connectionsRequestsMean>\n");
                sb.append("    <connectionsRequestsMax>").append(connector.getConnectionsRequestsMax()).append("</connectionsRequestsMax>\n");
                sb.append("    <connectionsRequestsStdDev>").append(connector.getConnectionsRequestsStdDev()).append("</connectionsRequestsStdDev>\n");
            }
            sb.append("    </connector>\n");
        }
        sb.append("  </connections>\n");
        sb.append("  <memory>\n");
        sb.append("    <heapMemoryUsage>").append(this._memoryBean.getHeapMemoryUsage().getUsed()).append("</heapMemoryUsage>\n");
        sb.append("    <nonHeapMemoryUsage>").append(this._memoryBean.getNonHeapMemoryUsage().getUsed()).append("</nonHeapMemoryUsage>\n");
        sb.append("  </memory>\n");
        sb.append("</statistics>\n");
        response2.setContentType("text/xml");
        PrintWriter pout = response2.getWriter();
        pout.write(sb.toString());
    }

    private void sendTextResponse(HttpServletResponse response2) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(this._statsHandler.toStatsHTML());
        sb.append("<h2>Connections:</h2>\n");
        for (Connector connector : this._connectors) {
            sb.append("<h3>").append(connector.getName()).append("</h3>");
            if (connector.getStatsOn()) {
                sb.append("Statistics gathering started ").append(connector.getStatsOnMs()).append("ms ago").append("<br />\n");
                sb.append("Total connections: ").append(connector.getConnections()).append("<br />\n");
                sb.append("Current connections open: ").append(connector.getConnectionsOpen()).append("<br />\n");
                sb.append("Max concurrent connections open: ").append(connector.getConnectionsOpenMax()).append("<br />\n");
                sb.append("Total connections duration: ").append(connector.getConnectionsDurationTotal()).append("<br />\n");
                sb.append("Mean connection duration: ").append(connector.getConnectionsDurationMean()).append("<br />\n");
                sb.append("Max connection duration: ").append(connector.getConnectionsDurationMax()).append("<br />\n");
                sb.append("Connection duration standard deviation: ").append(connector.getConnectionsDurationStdDev()).append("<br />\n");
                sb.append("Total requests: ").append(connector.getRequests()).append("<br />\n");
                sb.append("Mean requests per connection: ").append(connector.getConnectionsRequestsMean()).append("<br />\n");
                sb.append("Max requests per connection: ").append(connector.getConnectionsRequestsMax()).append("<br />\n");
                sb.append("Requests per connection standard deviation: ").append(connector.getConnectionsRequestsStdDev()).append("<br />\n");
                continue;
            }
            sb.append("Statistics gathering off.\n");
        }
        sb.append("<h2>Memory:</h2>\n");
        sb.append("Heap memory usage: ").append(this._memoryBean.getHeapMemoryUsage().getUsed()).append(" bytes").append("<br />\n");
        sb.append("Non-heap memory usage: ").append(this._memoryBean.getNonHeapMemoryUsage().getUsed()).append(" bytes").append("<br />\n");
        response2.setContentType("text/html");
        PrintWriter pout = response2.getWriter();
        pout.write(sb.toString());
    }
}

