/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.server.session;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.storm.shade.org.eclipse.jetty.server.session.AbstractSession;
import org.apache.storm.shade.org.eclipse.jetty.server.session.HashSessionManager;
import org.apache.storm.shade.org.eclipse.jetty.util.IO;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Log;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Logger;

public class HashedSession
extends AbstractSession {
    private static final Logger LOG = Log.getLogger(HashedSession.class);
    private final HashSessionManager _hashSessionManager;
    private transient boolean _idled = false;
    private transient boolean _saveFailed = false;

    protected HashedSession(HashSessionManager hashSessionManager, HttpServletRequest request) {
        super(hashSessionManager, request);
        this._hashSessionManager = hashSessionManager;
    }

    protected HashedSession(HashSessionManager hashSessionManager, long created, long accessed, String clusterId) {
        super(hashSessionManager, created, accessed, clusterId);
        this._hashSessionManager = hashSessionManager;
    }

    protected void checkValid() {
        if (this._hashSessionManager._idleSavePeriodMs != 0L) {
            this.deIdle();
        }
        super.checkValid();
    }

    public void setMaxInactiveInterval(int secs2) {
        super.setMaxInactiveInterval(secs2);
        if (this.getMaxInactiveInterval() > 0 && (long)this.getMaxInactiveInterval() * 1000L / 10L < this._hashSessionManager._scavengePeriodMs) {
            this._hashSessionManager.setScavengePeriod((secs2 + 9) / 10);
        }
    }

    protected void doInvalidate() throws IllegalStateException {
        super.doInvalidate();
        if (this._hashSessionManager._storeDir != null && this.getId() != null) {
            String id = this.getId();
            File f = new File(this._hashSessionManager._storeDir, id);
            f.delete();
        }
    }

    synchronized void save(boolean reactivate) throws Exception {
        if (!this.isIdled() && !this._saveFailed) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Saving {} {}", super.getId(), reactivate);
            }
            File file2 = null;
            FileOutputStream fos = null;
            try {
                file2 = new File(this._hashSessionManager._storeDir, super.getId());
                if (file2.exists()) {
                    file2.delete();
                }
                file2.createNewFile();
                fos = new FileOutputStream(file2);
                this.willPassivate();
                this.save(fos);
                IO.close(fos);
                if (reactivate) {
                    this.didActivate();
                } else {
                    this.clearAttributes();
                }
            }
            catch (Exception e) {
                this.saveFailed();
                if (fos != null) {
                    IO.close(fos);
                }
                if (file2 != null) {
                    file2.delete();
                }
                throw e;
            }
        }
    }

    public synchronized void save(OutputStream os) throws IOException {
        DataOutputStream out = new DataOutputStream(os);
        out.writeUTF(this.getClusterId());
        out.writeUTF(this.getNodeId());
        out.writeLong(this.getCreationTime());
        out.writeLong(this.getAccessed());
        out.writeInt(this.getRequests());
        out.writeInt(this.getAttributes());
        ObjectOutputStream oos = new ObjectOutputStream(out);
        Enumeration<String> e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            oos.writeUTF(key);
            oos.writeObject(this.doGet(key));
        }
        oos.close();
    }

    public synchronized void deIdle() {
        if (this.isIdled()) {
            this.access(System.currentTimeMillis());
            if (LOG.isDebugEnabled()) {
                LOG.debug("De-idling " + super.getId(), new Object[0]);
            }
            FileInputStream fis = null;
            try {
                File file2 = new File(this._hashSessionManager._storeDir, super.getId());
                if (!file2.exists() || !file2.canRead()) {
                    throw new FileNotFoundException(file2.getName());
                }
                fis = new FileInputStream(file2);
                this._idled = false;
                this._hashSessionManager.restoreSession(fis, this);
                IO.close(fis);
                this.didActivate();
                if (this._hashSessionManager._savePeriodMs == 0L) {
                    file2.delete();
                }
            }
            catch (Exception e) {
                LOG.warn("Problem de-idling session " + super.getId(), e);
                if (fis != null) {
                    IO.close(fis);
                }
                this.invalidate();
            }
        }
    }

    public synchronized void idle() throws Exception {
        this.save(false);
        this._idled = true;
    }

    public synchronized boolean isIdled() {
        return this._idled;
    }

    public synchronized boolean isSaveFailed() {
        return this._saveFailed;
    }

    public synchronized void saveFailed() {
        this._saveFailed = true;
    }
}

