/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.server.session;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.storm.shade.org.eclipse.jetty.server.handler.ContextHandler;
import org.apache.storm.shade.org.eclipse.jetty.server.session.AbstractSession;
import org.apache.storm.shade.org.eclipse.jetty.server.session.AbstractSessionManager;
import org.apache.storm.shade.org.eclipse.jetty.server.session.HashedSession;
import org.apache.storm.shade.org.eclipse.jetty.server.session.SessionHandler;
import org.apache.storm.shade.org.eclipse.jetty.util.IO;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Logger;

public class HashSessionManager
extends AbstractSessionManager {
    static final Logger __log = SessionHandler.LOG;
    protected final ConcurrentMap<String, HashedSession> _sessions = new ConcurrentHashMap<String, HashedSession>();
    private static int __id;
    private Timer _timer;
    private boolean _timerStop = false;
    private TimerTask _task;
    long _scavengePeriodMs = 30000L;
    long _savePeriodMs = 0L;
    long _idleSavePeriodMs = 0L;
    private TimerTask _saveTask;
    File _storeDir;
    private boolean _lazyLoad = false;
    private volatile boolean _sessionsLoaded = false;
    private boolean _deleteUnrestorableSessions = false;

    public void doStart() throws Exception {
        super.doStart();
        this._timerStop = false;
        ContextHandler.Context context2 = ContextHandler.getCurrentContext();
        if (context2 != null) {
            this._timer = (Timer)context2.getAttribute("org.apache.storm.shade.org.eclipse.jetty.server.session.timer");
        }
        if (this._timer == null) {
            this._timerStop = true;
            this._timer = new Timer("HashSessionScavenger-" + __id++, true);
        }
        this.setScavengePeriod(this.getScavengePeriod());
        if (this._storeDir != null) {
            if (!this._storeDir.exists()) {
                this._storeDir.mkdirs();
            }
            if (!this._lazyLoad) {
                this.restoreSessions();
            }
        }
        this.setSavePeriod(this.getSavePeriod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() throws Exception {
        HashSessionManager hashSessionManager = this;
        synchronized (hashSessionManager) {
            if (this._saveTask != null) {
                this._saveTask.cancel();
            }
            this._saveTask = null;
            if (this._task != null) {
                this._task.cancel();
            }
            this._task = null;
            if (this._timer != null && this._timerStop) {
                this._timer.cancel();
            }
            this._timer = null;
        }
        super.doStop();
        this._sessions.clear();
    }

    public int getScavengePeriod() {
        return (int)(this._scavengePeriodMs / 1000L);
    }

    public int getSessions() {
        int sessions = super.getSessions();
        if (__log.isDebugEnabled() && this._sessions.size() != sessions) {
            __log.warn("sessions: " + this._sessions.size() + "!=" + sessions, new Object[0]);
        }
        return sessions;
    }

    public int getIdleSavePeriod() {
        if (this._idleSavePeriodMs <= 0L) {
            return 0;
        }
        return (int)(this._idleSavePeriodMs / 1000L);
    }

    public void setIdleSavePeriod(int seconds2) {
        this._idleSavePeriodMs = (long)seconds2 * 1000L;
    }

    public void setMaxInactiveInterval(int seconds2) {
        super.setMaxInactiveInterval(seconds2);
        if (this._dftMaxIdleSecs > 0 && this._scavengePeriodMs > (long)this._dftMaxIdleSecs * 1000L) {
            this.setScavengePeriod((this._dftMaxIdleSecs + 9) / 10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSavePeriod(int seconds2) {
        long period = (long)seconds2 * 1000L;
        if (period < 0L) {
            period = 0L;
        }
        this._savePeriodMs = period;
        if (this._timer != null) {
            HashSessionManager hashSessionManager = this;
            synchronized (hashSessionManager) {
                if (this._saveTask != null) {
                    this._saveTask.cancel();
                }
                if (this._savePeriodMs > 0L && this._storeDir != null) {
                    this._saveTask = new TimerTask(){

                        public void run() {
                            try {
                                HashSessionManager.this.saveSessions(true);
                            }
                            catch (Exception e) {
                                __log.warn(e);
                            }
                        }
                    };
                    this._timer.schedule(this._saveTask, this._savePeriodMs, this._savePeriodMs);
                }
            }
        }
    }

    public int getSavePeriod() {
        if (this._savePeriodMs <= 0L) {
            return 0;
        }
        return (int)(this._savePeriodMs / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScavengePeriod(int seconds2) {
        if (seconds2 == 0) {
            seconds2 = 60;
        }
        long old_period = this._scavengePeriodMs;
        long period = (long)seconds2 * 1000L;
        if (period > 60000L) {
            period = 60000L;
        }
        if (period < 1000L) {
            period = 1000L;
        }
        this._scavengePeriodMs = period;
        if (this._timer != null && (period != old_period || this._task == null)) {
            HashSessionManager hashSessionManager = this;
            synchronized (hashSessionManager) {
                if (this._task != null) {
                    this._task.cancel();
                }
                this._task = new TimerTask(){

                    public void run() {
                        HashSessionManager.this.scavenge();
                    }
                };
                this._timer.schedule(this._task, this._scavengePeriodMs, this._scavengePeriodMs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scavenge() {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader old_loader = thread.getContextClassLoader();
        try {
            if (this._loader != null) {
                thread.setContextClassLoader(this._loader);
            }
            long now2 = System.currentTimeMillis();
            for (HashedSession session2 : this._sessions.values()) {
                long idleTime = (long)session2.getMaxInactiveInterval() * 1000L;
                if (idleTime > 0L && session2.getAccessed() + idleTime < now2) {
                    try {
                        session2.timeout();
                    }
                    catch (Exception e) {
                        __log.warn("Problem scavenging sessions", e);
                    }
                    continue;
                }
                if (this._idleSavePeriodMs <= 0L || session2.getAccessed() + this._idleSavePeriodMs >= now2) continue;
                try {
                    session2.idle();
                }
                catch (Exception e) {
                    __log.warn("Problem idling session " + session2.getId(), e);
                }
            }
            Object var11_10 = null;
            thread.setContextClassLoader(old_loader);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            thread.setContextClassLoader(old_loader);
            throw throwable;
        }
    }

    protected void addSession(AbstractSession session2) {
        if (this.isRunning()) {
            this._sessions.put(session2.getClusterId(), (HashedSession)session2);
        }
    }

    public AbstractSession getSession(String idInCluster) {
        ConcurrentMap<String, HashedSession> sessions;
        if (this._lazyLoad && !this._sessionsLoaded) {
            try {
                this.restoreSessions();
            }
            catch (Exception e) {
                __log.warn(e);
            }
        }
        if ((sessions = this._sessions) == null) {
            return null;
        }
        HashedSession session2 = (HashedSession)sessions.get(idInCluster);
        if (session2 == null && this._lazyLoad) {
            session2 = this.restoreSession(idInCluster);
        }
        if (session2 == null) {
            return null;
        }
        if (this._idleSavePeriodMs != 0L) {
            session2.deIdle();
        }
        return session2;
    }

    protected void invalidateSessions() throws Exception {
        ArrayList sessions = new ArrayList(this._sessions.values());
        int loop = 100;
        while (sessions.size() > 0 && loop-- > 0) {
            if (this.isStopping() && this._storeDir != null && this._storeDir.exists() && this._storeDir.canWrite()) {
                for (HashedSession session2 : sessions) {
                    session2.save(false);
                    this.removeSession(session2, false);
                }
            } else {
                for (HashedSession session2 : sessions) {
                    session2.invalidate();
                }
            }
            sessions = new ArrayList(this._sessions.values());
        }
    }

    protected AbstractSession newSession(HttpServletRequest request) {
        return new HashedSession(this, request);
    }

    protected AbstractSession newSession(long created, long accessed, String clusterId) {
        return new HashedSession(this, created, accessed, clusterId);
    }

    protected boolean removeSession(String clusterId) {
        return this._sessions.remove(clusterId) != null;
    }

    public void setStoreDirectory(File dir) throws IOException {
        this._storeDir = dir.getCanonicalFile();
    }

    public File getStoreDirectory() {
        return this._storeDir;
    }

    public void setLazyLoad(boolean lazyLoad) {
        this._lazyLoad = lazyLoad;
    }

    public boolean isLazyLoad() {
        return this._lazyLoad;
    }

    public boolean isDeleteUnrestorableSessions() {
        return this._deleteUnrestorableSessions;
    }

    public void setDeleteUnrestorableSessions(boolean deleteUnrestorableSessions) {
        this._deleteUnrestorableSessions = deleteUnrestorableSessions;
    }

    public void restoreSessions() throws Exception {
        this._sessionsLoaded = true;
        if (this._storeDir == null || !this._storeDir.exists()) {
            return;
        }
        if (!this._storeDir.canRead()) {
            __log.warn("Unable to restore Sessions: Cannot read from Session storage directory " + this._storeDir.getAbsolutePath(), new Object[0]);
            return;
        }
        String[] files2 = this._storeDir.list();
        for (int i = 0; files2 != null && i < files2.length; ++i) {
            this.restoreSession(files2[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized HashedSession restoreSession(String idInCuster) {
        Exception error2;
        FileInputStream in;
        File file2;
        block17: {
            HashedSession hashedSession;
            block18: {
                file2 = new File(this._storeDir, idInCuster);
                in = null;
                error2 = null;
                try {
                    try {
                        if (!file2.exists()) break block17;
                        in = new FileInputStream(file2);
                        HashedSession session2 = this.restoreSession(in, null);
                        this.addSession(session2, false);
                        session2.didActivate();
                        hashedSession = session2;
                        Object var8_8 = null;
                        if (in == null) break block18;
                    }
                    catch (Exception e) {
                        error2 = e;
                        Object var8_10 = null;
                        if (in != null) {
                            IO.close(in);
                        }
                        if (error2 == null) {
                            file2.delete();
                            return null;
                        }
                        if (this.isDeleteUnrestorableSessions() && file2.exists() && file2.getParentFile().equals(this._storeDir)) {
                            file2.delete();
                            __log.warn("Deleting file for unrestorable session " + idInCuster, error2);
                            return null;
                        }
                        __log.warn("Problem restoring session " + idInCuster, error2);
                        return null;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    if (in != null) {
                        IO.close(in);
                    }
                    if (error2 == null) {
                        file2.delete();
                        throw throwable;
                    }
                    if (this.isDeleteUnrestorableSessions() && file2.exists() && file2.getParentFile().equals(this._storeDir)) {
                        file2.delete();
                        __log.warn("Deleting file for unrestorable session " + idInCuster, error2);
                        throw throwable;
                    }
                    __log.warn("Problem restoring session " + idInCuster, error2);
                    throw throwable;
                }
                IO.close(in);
            }
            if (error2 != null) {
                if (this.isDeleteUnrestorableSessions() && file2.exists() && file2.getParentFile().equals(this._storeDir)) {
                    file2.delete();
                    __log.warn("Deleting file for unrestorable session " + idInCuster, error2);
                    return hashedSession;
                }
                __log.warn("Problem restoring session " + idInCuster, error2);
                return hashedSession;
            }
            file2.delete();
            return hashedSession;
        }
        Object var8_9 = null;
        if (in != null) {
            IO.close(in);
        }
        if (error2 != null) {
            if (this.isDeleteUnrestorableSessions() && file2.exists() && file2.getParentFile().equals(this._storeDir)) {
                file2.delete();
                __log.warn("Deleting file for unrestorable session " + idInCuster, error2);
                return null;
            }
            __log.warn("Problem restoring session " + idInCuster, error2);
            return null;
        }
        file2.delete();
        return null;
    }

    public void saveSessions(boolean reactivate) throws Exception {
        if (this._storeDir == null || !this._storeDir.exists()) {
            return;
        }
        if (!this._storeDir.canWrite()) {
            __log.warn("Unable to save Sessions: Session persistence storage directory " + this._storeDir.getAbsolutePath() + " is not writeable", new Object[0]);
            return;
        }
        for (HashedSession session2 : this._sessions.values()) {
            session2.save(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashedSession restoreSession(InputStream is, HashedSession session2) throws Exception {
        HashedSession hashedSession;
        DataInputStream in = new DataInputStream(is);
        try {
            String clusterId = in.readUTF();
            in.readUTF();
            long created = in.readLong();
            long accessed = in.readLong();
            int requests = in.readInt();
            if (session2 == null) {
                session2 = (HashedSession)this.newSession(created, accessed, clusterId);
            }
            session2.setRequests(requests);
            int size = in.readInt();
            if (size > 0) {
                ClassLoadingObjectInputStream ois = new ClassLoadingObjectInputStream(in);
                try {
                    for (int i = 0; i < size; ++i) {
                        String key = ois.readUTF();
                        Object value = ois.readObject();
                        session2.setAttribute(key, value);
                    }
                    Object var16_13 = null;
                }
                catch (Throwable throwable) {
                    Object var16_14 = null;
                    IO.close(ois);
                    throw throwable;
                }
                IO.close(ois);
                {
                }
            }
            hashedSession = session2;
            Object var18_16 = null;
        }
        catch (Throwable throwable) {
            Object var18_17 = null;
            IO.close(in);
            throw throwable;
        }
        IO.close(in);
        return hashedSession;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ClassLoadingObjectInputStream
    extends ObjectInputStream {
        public ClassLoadingObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        public ClassLoadingObjectInputStream() throws IOException {
        }

        @Override
        public Class<?> resolveClass(ObjectStreamClass cl) throws IOException, ClassNotFoundException {
            try {
                return Class.forName(cl.getName(), false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                return super.resolveClass(cl);
            }
        }
    }
}

