/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.server.handler.jmx;

import java.io.IOException;
import org.apache.storm.shade.org.eclipse.jetty.jmx.ObjectMBean;
import org.apache.storm.shade.org.eclipse.jetty.server.Server;
import org.apache.storm.shade.org.eclipse.jetty.server.handler.AbstractHandler;
import org.apache.storm.shade.org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.apache.storm.shade.org.eclipse.jetty.server.handler.ContextHandler;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Log;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Logger;

public class AbstractHandlerMBean
extends ObjectMBean {
    private static final Logger LOG = Log.getLogger(AbstractHandlerMBean.class);

    public AbstractHandlerMBean(Object managedObject) {
        super(managedObject);
    }

    public String getObjectContextBasis() {
        if (this._managed != null) {
            ContextHandler context2;
            AbstractHandler handler2;
            Server server;
            String basis = null;
            if (this._managed instanceof ContextHandler) {
                return null;
            }
            if (this._managed instanceof AbstractHandler && (server = (handler2 = (AbstractHandler)this._managed).getServer()) != null && (context2 = AbstractHandlerContainer.findContainerOf(server, ContextHandler.class, handler2)) != null) {
                basis = this.getContextName(context2);
            }
            if (basis != null) {
                return basis;
            }
        }
        return super.getObjectContextBasis();
    }

    public String getObjectNameBasis() {
        if (this._managed != null) {
            String name = null;
            if (this._managed instanceof ContextHandler) {
                ContextHandler context2 = (ContextHandler)this._managed;
                name = this.getContextName(context2);
            }
            if (name != null) {
                return name;
            }
        }
        return super.getObjectNameBasis();
    }

    protected String getContextName(ContextHandler context2) {
        String name = null;
        if (context2.getContextPath() != null && context2.getContextPath().length() > 0) {
            int idx = context2.getContextPath().lastIndexOf(47);
            String string = name = idx < 0 ? context2.getContextPath() : context2.getContextPath().substring(++idx);
            if (name == null || name.length() == 0) {
                name = "ROOT";
            }
        }
        if (name == null && context2.getBaseResource() != null) {
            try {
                if (context2.getBaseResource().getFile() != null) {
                    name = context2.getBaseResource().getFile().getName();
                }
            }
            catch (IOException e) {
                LOG.ignore(e);
                name = context2.getBaseResource().getName();
            }
        }
        return name;
    }
}

