/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.storm.shade.org.eclipse.jetty.http.HttpFields;
import org.apache.storm.shade.org.eclipse.jetty.http.HttpHeaders;
import org.apache.storm.shade.org.eclipse.jetty.http.MimeTypes;
import org.apache.storm.shade.org.eclipse.jetty.io.Buffer;
import org.apache.storm.shade.org.eclipse.jetty.io.ByteArrayBuffer;
import org.apache.storm.shade.org.eclipse.jetty.io.WriterOutputStream;
import org.apache.storm.shade.org.eclipse.jetty.server.AbstractHttpConnection;
import org.apache.storm.shade.org.eclipse.jetty.server.Request;
import org.apache.storm.shade.org.eclipse.jetty.server.Response;
import org.apache.storm.shade.org.eclipse.jetty.server.handler.ContextHandler;
import org.apache.storm.shade.org.eclipse.jetty.server.handler.HandlerWrapper;
import org.apache.storm.shade.org.eclipse.jetty.util.URIUtil;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Log;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Logger;
import org.apache.storm.shade.org.eclipse.jetty.util.resource.FileResource;
import org.apache.storm.shade.org.eclipse.jetty.util.resource.Resource;

public class ResourceHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(ResourceHandler.class);
    ContextHandler _context;
    Resource _baseResource;
    Resource _defaultStylesheet;
    Resource _stylesheet;
    String[] _welcomeFiles = new String[]{"index.html"};
    MimeTypes _mimeTypes = new MimeTypes();
    ByteArrayBuffer _cacheControl;
    boolean _aliases;
    boolean _directory;
    boolean _etags;

    public MimeTypes getMimeTypes() {
        return this._mimeTypes;
    }

    public void setMimeTypes(MimeTypes mimeTypes) {
        this._mimeTypes = mimeTypes;
    }

    public boolean isAliases() {
        return this._aliases;
    }

    public void setAliases(boolean aliases) {
        this._aliases = aliases;
    }

    public boolean isDirectoriesListed() {
        return this._directory;
    }

    public void setDirectoriesListed(boolean directory) {
        this._directory = directory;
    }

    public boolean isEtags() {
        return this._etags;
    }

    public void setEtags(boolean etags) {
        this._etags = etags;
    }

    public void doStart() throws Exception {
        ContextHandler.Context scontext = ContextHandler.getCurrentContext();
        ContextHandler contextHandler = this._context = scontext == null ? null : scontext.getContextHandler();
        if (this._context != null) {
            this._aliases = this._context.isAliases();
        }
        if (!this._aliases && !FileResource.getCheckAliases()) {
            throw new IllegalStateException("Alias checking disabled");
        }
        super.doStart();
    }

    public Resource getBaseResource() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource;
    }

    public String getResourceBase() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource.toString();
    }

    public void setBaseResource(Resource base) {
        this._baseResource = base;
    }

    public void setResourceBase(String resourceBase) {
        try {
            this.setBaseResource(Resource.newResource(resourceBase));
        }
        catch (Exception e) {
            LOG.warn(e.toString(), new Object[0]);
            LOG.debug(e);
            throw new IllegalArgumentException(resourceBase);
        }
    }

    public Resource getStylesheet() {
        if (this._stylesheet != null) {
            return this._stylesheet;
        }
        if (this._defaultStylesheet == null) {
            try {
                this._defaultStylesheet = Resource.newResource(this.getClass().getResource("/jetty-dir.css"));
            }
            catch (IOException e) {
                LOG.warn(e.toString(), new Object[0]);
                LOG.debug(e);
            }
        }
        return this._defaultStylesheet;
    }

    public void setStylesheet(String stylesheet) {
        try {
            this._stylesheet = Resource.newResource(stylesheet);
            if (!this._stylesheet.exists()) {
                LOG.warn("unable to find custom stylesheet: " + stylesheet, new Object[0]);
                this._stylesheet = null;
            }
        }
        catch (Exception e) {
            LOG.warn(e.toString(), new Object[0]);
            LOG.debug(e);
            throw new IllegalArgumentException(stylesheet.toString());
        }
    }

    public String getCacheControl() {
        return this._cacheControl.toString();
    }

    public void setCacheControl(String cacheControl) {
        this._cacheControl = cacheControl == null ? null : new ByteArrayBuffer(cacheControl);
    }

    public Resource getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException(path);
        }
        Resource base = this._baseResource;
        if (base == null) {
            if (this._context == null) {
                return null;
            }
            base = this._context.getBaseResource();
            if (base == null) {
                return null;
            }
        }
        try {
            path = URIUtil.canonicalPath(path);
            return base.addPath(path);
        }
        catch (Exception e) {
            LOG.ignore(e);
            return null;
        }
    }

    protected Resource getResource(HttpServletRequest request) throws MalformedURLException {
        String pathInfo;
        String servletPath;
        Boolean included = request.getAttribute("javax.servlet.include.request_uri") != null;
        if (included != null && included.booleanValue()) {
            servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            if (servletPath == null && pathInfo == null) {
                servletPath = request.getServletPath();
                pathInfo = request.getPathInfo();
            }
        } else {
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        }
        String pathInContext = URIUtil.addPaths(servletPath, pathInfo);
        return this.getResource(pathInContext);
    }

    public String[] getWelcomeFiles() {
        return this._welcomeFiles;
    }

    public void setWelcomeFiles(String[] welcomeFiles) {
        this._welcomeFiles = welcomeFiles;
    }

    protected Resource getWelcome(Resource directory) throws MalformedURLException, IOException {
        for (int i = 0; i < this._welcomeFiles.length; ++i) {
            Resource welcome = directory.addPath(this._welcomeFiles[i]);
            if (!welcome.exists() || welcome.isDirectory()) continue;
            return welcome;
        }
        return null;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response2) throws IOException, ServletException {
        long if_modified;
        Resource resource;
        if (baseRequest.isHandled()) {
            return;
        }
        boolean skipContentBody = false;
        if (!"GET".equals(request.getMethod())) {
            if (!"HEAD".equals(request.getMethod())) {
                super.handle(target, baseRequest, request, response2);
                return;
            }
            skipContentBody = true;
        }
        if ((resource = this.getResource(request)) == null || !resource.exists()) {
            if (target.endsWith("/jetty-dir.css")) {
                resource = this.getStylesheet();
                if (resource == null) {
                    return;
                }
                response2.setContentType("text/css");
            } else {
                super.handle(target, baseRequest, request, response2);
                return;
            }
        }
        if (!this._aliases && resource.getAlias() != null) {
            LOG.info(resource + " aliased to " + resource.getAlias(), new Object[0]);
            return;
        }
        baseRequest.setHandled(true);
        if (resource.isDirectory()) {
            if (!request.getPathInfo().endsWith("/")) {
                response2.sendRedirect(response2.encodeRedirectURL(URIUtil.addPaths(request.getRequestURI(), "/")));
                return;
            }
            Resource welcome = this.getWelcome(resource);
            if (welcome != null && welcome.exists()) {
                resource = welcome;
            } else {
                this.doDirectory(request, response2, resource);
                baseRequest.setHandled(true);
                return;
            }
        }
        long last_modified = resource.lastModified();
        String etag = null;
        if (this._etags) {
            String ifnm = request.getHeader("If-None-Match");
            etag = resource.getWeakETag();
            if (ifnm != null && resource != null && ifnm.equals(etag)) {
                response2.setStatus(304);
                baseRequest.getResponse().getHttpFields().put(HttpHeaders.ETAG_BUFFER, etag);
                return;
            }
        }
        if (last_modified > 0L && (if_modified = request.getDateHeader("If-Modified-Since")) > 0L && last_modified / 1000L <= if_modified / 1000L) {
            response2.setStatus(304);
            return;
        }
        Buffer mime = this._mimeTypes.getMimeByExtension(resource.toString());
        if (mime == null) {
            mime = this._mimeTypes.getMimeByExtension(request.getPathInfo());
        }
        this.doResponseHeaders(response2, resource, mime != null ? mime.toString() : null);
        response2.setDateHeader("Last-Modified", last_modified);
        if (this._etags) {
            baseRequest.getResponse().getHttpFields().put(HttpHeaders.ETAG_BUFFER, etag);
        }
        if (skipContentBody) {
            return;
        }
        Object out = null;
        try {
            out = response2.getOutputStream();
        }
        catch (IllegalStateException e) {
            out = new WriterOutputStream(response2.getWriter());
        }
        if (out instanceof AbstractHttpConnection.Output) {
            ((AbstractHttpConnection.Output)((Object)out)).sendContent(resource.getInputStream());
        } else {
            resource.writeTo((OutputStream)out, 0L, resource.length());
        }
    }

    protected void doDirectory(HttpServletRequest request, HttpServletResponse response2, Resource resource) throws IOException {
        if (this._directory) {
            String listing = resource.getListHTML(request.getRequestURI(), request.getPathInfo().lastIndexOf("/") > 0);
            response2.setContentType("text/html; charset=UTF-8");
            response2.getWriter().println(listing);
        } else {
            response2.sendError(403);
        }
    }

    protected void doResponseHeaders(HttpServletResponse response2, Resource resource, String mimeType) {
        if (mimeType != null) {
            response2.setContentType(mimeType);
        }
        long length = resource.length();
        if (response2 instanceof Response) {
            HttpFields fields2 = ((Response)response2).getHttpFields();
            if (length > 0L) {
                fields2.putLongField(HttpHeaders.CONTENT_LENGTH_BUFFER, length);
            }
            if (this._cacheControl != null) {
                fields2.put(HttpHeaders.CACHE_CONTROL_BUFFER, this._cacheControl);
            }
        } else {
            if (length > 0L) {
                response2.setHeader("Content-Length", Long.toString(length));
            }
            if (this._cacheControl != null) {
                response2.setHeader("Cache-Control", this._cacheControl.toString());
            }
        }
    }
}

