/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.server.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.storm.shade.org.eclipse.jetty.server.Handler;
import org.apache.storm.shade.org.eclipse.jetty.server.Request;
import org.apache.storm.shade.org.eclipse.jetty.server.Server;
import org.apache.storm.shade.org.eclipse.jetty.server.handler.AbstractHandlerContainer;

public class HotSwapHandler
extends AbstractHandlerContainer {
    private volatile Handler _handler;

    public Handler getHandler() {
        return this._handler;
    }

    public Handler[] getHandlers() {
        return new Handler[]{this._handler};
    }

    public void setHandler(Handler handler2) {
        if (handler2 == null) {
            throw new IllegalArgumentException("Parameter handler is null.");
        }
        try {
            Handler old_handler = this._handler;
            this._handler = handler2;
            Server server = this.getServer();
            handler2.setServer(server);
            this.addBean(handler2);
            if (server != null) {
                server.getContainer().update((Object)this, old_handler, handler2, "handler");
            }
            if (old_handler != null) {
                this.removeBean(old_handler);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response2) throws IOException, ServletException {
        if (this._handler != null && this.isStarted()) {
            this._handler.handle(target, baseRequest, request, response2);
        }
    }

    public void setServer(Server server) {
        Server old_server = this.getServer();
        if (server == old_server) {
            return;
        }
        if (this.isRunning()) {
            throw new IllegalStateException("RUNNING");
        }
        super.setServer(server);
        Handler h = this.getHandler();
        if (h != null) {
            h.setServer(server);
        }
        if (server != null && server != old_server) {
            server.getContainer().update((Object)this, null, this._handler, "handler");
        }
    }

    protected Object expandChildren(Object list2, Class byClass) {
        return this.expandHandler(this._handler, list2, byClass);
    }

    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        Handler child = this.getHandler();
        if (child != null) {
            this.setHandler(null);
            child.destroy();
        }
        super.destroy();
    }
}

