/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.storm.shade.org.eclipse.jetty.server.Handler;
import org.apache.storm.shade.org.eclipse.jetty.server.Request;
import org.apache.storm.shade.org.eclipse.jetty.server.Server;
import org.apache.storm.shade.org.eclipse.jetty.server.handler.AbstractHandler;
import org.apache.storm.shade.org.eclipse.jetty.server.handler.ContextHandler;
import org.apache.storm.shade.org.eclipse.jetty.util.ByteArrayISO8859Writer;
import org.apache.storm.shade.org.eclipse.jetty.util.IO;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Log;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Logger;
import org.apache.storm.shade.org.eclipse.jetty.util.resource.Resource;

public class DefaultHandler
extends AbstractHandler {
    private static final Logger LOG = Log.getLogger(DefaultHandler.class);
    final long _faviconModified = System.currentTimeMillis() / 1000L * 1000L;
    byte[] _favicon;
    boolean _serveIcon = true;
    boolean _showContexts = true;

    public DefaultHandler() {
        try {
            URL fav = this.getClass().getClassLoader().getResource("org/apache/storm/shade/org/eclipse/jetty/favicon.ico");
            if (fav != null) {
                Resource r = Resource.newResource(fav);
                this._favicon = IO.readBytes(r.getInputStream());
            }
        }
        catch (Exception e) {
            LOG.warn(e);
        }
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response2) throws IOException, ServletException {
        if (response2.isCommitted() || baseRequest.isHandled()) {
            return;
        }
        baseRequest.setHandled(true);
        String method = request.getMethod();
        if (this._serveIcon && this._favicon != null && method.equals("GET") && request.getRequestURI().equals("/favicon.ico")) {
            if (request.getDateHeader("If-Modified-Since") == this._faviconModified) {
                response2.setStatus(304);
            } else {
                response2.setStatus(200);
                response2.setContentType("image/x-icon");
                response2.setContentLength(this._favicon.length);
                response2.setDateHeader("Last-Modified", this._faviconModified);
                response2.setHeader("Cache-Control", "max-age=360000,public");
                response2.getOutputStream().write(this._favicon);
            }
            return;
        }
        if (!method.equals("GET") || !request.getRequestURI().equals("/")) {
            response2.sendError(404);
            return;
        }
        response2.setStatus(404);
        response2.setContentType("text/html");
        ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(1500);
        writer.write("<HTML>\n<HEAD>\n<TITLE>Error 404 - Not Found");
        writer.write("</TITLE>\n<BODY>\n<H2>Error 404 - Not Found.</H2>\n");
        writer.write("No context on this server matched or handled this request.<BR>");
        if (this._showContexts) {
            writer.write("Contexts known to this server are: <ul>");
            Server server = this.getServer();
            Handler[] handlers = server == null ? null : server.getChildHandlersByClass(ContextHandler.class);
            for (int i = 0; handlers != null && i < handlers.length; ++i) {
                ContextHandler context2 = (ContextHandler)handlers[i];
                if (context2.isRunning()) {
                    writer.write("<li><a href=\"");
                    if (context2.getVirtualHosts() != null && context2.getVirtualHosts().length > 0) {
                        writer.write("http://" + context2.getVirtualHosts()[0] + ":" + request.getLocalPort());
                    }
                    writer.write(context2.getContextPath());
                    if (context2.getContextPath().length() > 1 && context2.getContextPath().endsWith("/")) {
                        writer.write("/");
                    }
                    writer.write("\">");
                    writer.write(context2.getContextPath());
                    if (context2.getVirtualHosts() != null && context2.getVirtualHosts().length > 0) {
                        writer.write("&nbsp;@&nbsp;" + context2.getVirtualHosts()[0] + ":" + request.getLocalPort());
                    }
                    writer.write("&nbsp;--->&nbsp;");
                    writer.write(context2.toString());
                    writer.write("</a></li>\n");
                    continue;
                }
                writer.write("<li>");
                writer.write(context2.getContextPath());
                if (context2.getVirtualHosts() != null && context2.getVirtualHosts().length > 0) {
                    writer.write("&nbsp;@&nbsp;" + context2.getVirtualHosts()[0] + ":" + request.getLocalPort());
                }
                writer.write("&nbsp;--->&nbsp;");
                writer.write(context2.toString());
                if (context2.isFailed()) {
                    writer.write(" [failed]");
                }
                if (context2.isStopped()) {
                    writer.write(" [stopped]");
                }
                writer.write("</li>\n");
            }
        }
        for (int i = 0; i < 10; ++i) {
            writer.write("\n<!-- Padding for IE                  -->");
        }
        writer.write("\n</BODY>\n</HTML>\n");
        writer.flush();
        response2.setContentLength(writer.size());
        ServletOutputStream out = response2.getOutputStream();
        writer.writeTo((OutputStream)out);
        out.close();
    }

    public boolean getServeIcon() {
        return this._serveIcon;
    }

    public void setServeIcon(boolean serveIcon) {
        this._serveIcon = serveIcon;
    }

    public boolean getShowContexts() {
        return this._showContexts;
    }

    public void setShowContexts(boolean show) {
        this._showContexts = show;
    }
}

