/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.eclipse.jetty.server.handler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.storm.shade.org.eclipse.jetty.http.HttpException;
import org.apache.storm.shade.org.eclipse.jetty.http.MimeTypes;
import org.apache.storm.shade.org.eclipse.jetty.io.Buffer;
import org.apache.storm.shade.org.eclipse.jetty.server.AbstractHttpConnection;
import org.apache.storm.shade.org.eclipse.jetty.server.Dispatcher;
import org.apache.storm.shade.org.eclipse.jetty.server.DispatcherType;
import org.apache.storm.shade.org.eclipse.jetty.server.Handler;
import org.apache.storm.shade.org.eclipse.jetty.server.HandlerContainer;
import org.apache.storm.shade.org.eclipse.jetty.server.Request;
import org.apache.storm.shade.org.eclipse.jetty.server.Server;
import org.apache.storm.shade.org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.apache.storm.shade.org.eclipse.jetty.server.handler.ErrorHandler;
import org.apache.storm.shade.org.eclipse.jetty.server.handler.HandlerCollection;
import org.apache.storm.shade.org.eclipse.jetty.server.handler.HandlerWrapper;
import org.apache.storm.shade.org.eclipse.jetty.server.handler.ScopedHandler;
import org.apache.storm.shade.org.eclipse.jetty.util.Attributes;
import org.apache.storm.shade.org.eclipse.jetty.util.AttributesMap;
import org.apache.storm.shade.org.eclipse.jetty.util.LazyList;
import org.apache.storm.shade.org.eclipse.jetty.util.Loader;
import org.apache.storm.shade.org.eclipse.jetty.util.StringUtil;
import org.apache.storm.shade.org.eclipse.jetty.util.TypeUtil;
import org.apache.storm.shade.org.eclipse.jetty.util.URIUtil;
import org.apache.storm.shade.org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.apache.storm.shade.org.eclipse.jetty.util.component.Dumpable;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Log;
import org.apache.storm.shade.org.eclipse.jetty.util.log.Logger;
import org.apache.storm.shade.org.eclipse.jetty.util.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextHandler
extends ScopedHandler
implements Attributes,
Server.Graceful {
    private static final Logger LOG = Log.getLogger(ContextHandler.class);
    private static final ThreadLocal<Context> __context = new ThreadLocal();
    public static final String MANAGED_ATTRIBUTES = "org.apache.storm.shade.org.eclipse.jetty.server.context.ManagedAttributes";
    protected Context _scontext;
    private final AttributesMap _attributes;
    private final AttributesMap _contextAttributes;
    private final Map<String, String> _initParams;
    private ClassLoader _classLoader;
    private String _contextPath = "/";
    private String _displayName;
    private Resource _baseResource;
    private MimeTypes _mimeTypes;
    private Map<String, String> _localeEncodingMap;
    private String[] _welcomeFiles;
    private ErrorHandler _errorHandler;
    private String[] _vhosts;
    private Set<String> _connectors;
    private EventListener[] _eventListeners;
    private Logger _logger;
    private boolean _allowNullPathInfo;
    private int _maxFormKeys = Integer.getInteger("org.apache.storm.shade.org.eclipse.jetty.server.Request.maxFormKeys", -1);
    private int _maxFormContentSize = Integer.getInteger("org.apache.storm.shade.org.eclipse.jetty.server.Request.maxFormContentSize", -1);
    private boolean _compactPath = false;
    private boolean _aliases = false;
    private Object _contextListeners;
    private Object _contextAttributeListeners;
    private Object _requestListeners;
    private Object _requestAttributeListeners;
    private Map<String, Object> _managedAttributes;
    private String[] _protectedTargets;
    private final CopyOnWriteArrayList<AliasCheck> _aliasChecks = new CopyOnWriteArrayList();
    private boolean _shutdown = false;
    private boolean _available = true;
    private volatile int _availability;
    private static final int __STOPPED = 0;
    private static final int __AVAILABLE = 1;
    private static final int __SHUTDOWN = 2;
    private static final int __UNAVAILABLE = 3;

    public static Context getCurrentContext() {
        return __context.get();
    }

    public ContextHandler() {
        this._scontext = new Context();
        this._attributes = new AttributesMap();
        this._contextAttributes = new AttributesMap();
        this._initParams = new HashMap<String, String>();
        this.addAliasCheck(new ApproveNonExistentDirectoryAliases());
    }

    protected ContextHandler(Context context2) {
        this._scontext = context2;
        this._attributes = new AttributesMap();
        this._contextAttributes = new AttributesMap();
        this._initParams = new HashMap<String, String>();
        this.addAliasCheck(new ApproveNonExistentDirectoryAliases());
    }

    public ContextHandler(String contextPath) {
        this();
        this.setContextPath(contextPath);
    }

    public ContextHandler(HandlerContainer parent, String contextPath) {
        this();
        this.setContextPath(contextPath);
        if (parent instanceof HandlerWrapper) {
            ((HandlerWrapper)parent).setHandler(this);
        } else if (parent instanceof HandlerCollection) {
            ((HandlerCollection)parent).addHandler(this);
        }
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpThis(out);
        ContextHandler.dump(out, indent, Collections.singletonList(new CLDump(this.getClassLoader())), TypeUtil.asList(this.getHandlers()), this.getBeans(), this._initParams.entrySet(), this._attributes.getAttributeEntrySet(), this._contextAttributes.getAttributeEntrySet());
    }

    public Context getServletContext() {
        return this._scontext;
    }

    public boolean getAllowNullPathInfo() {
        return this._allowNullPathInfo;
    }

    public void setAllowNullPathInfo(boolean allowNullPathInfo) {
        this._allowNullPathInfo = allowNullPathInfo;
    }

    @Override
    public void setServer(Server server) {
        if (this._errorHandler != null) {
            Server old_server = this.getServer();
            if (old_server != null && old_server != server) {
                old_server.getContainer().update((Object)this, this._errorHandler, null, "error", true);
            }
            super.setServer(server);
            if (server != null && server != old_server) {
                server.getContainer().update((Object)this, null, this._errorHandler, "error", true);
            }
            this._errorHandler.setServer(server);
        } else {
            super.setServer(server);
        }
    }

    public void setVirtualHosts(String[] vhosts) {
        if (vhosts == null) {
            this._vhosts = vhosts;
        } else {
            this._vhosts = new String[vhosts.length];
            for (int i = 0; i < vhosts.length; ++i) {
                this._vhosts[i] = this.normalizeHostname(vhosts[i]);
            }
        }
    }

    public void addVirtualHosts(String[] virtualHosts) {
        if (virtualHosts == null) {
            return;
        }
        ArrayList<Object> currentVirtualHosts = null;
        currentVirtualHosts = this._vhosts != null ? new ArrayList<String>(Arrays.asList(this._vhosts)) : new ArrayList();
        for (int i = 0; i < virtualHosts.length; ++i) {
            String normVhost = this.normalizeHostname(virtualHosts[i]);
            if (currentVirtualHosts.contains(normVhost)) continue;
            currentVirtualHosts.add(normVhost);
        }
        this._vhosts = currentVirtualHosts.toArray(new String[0]);
    }

    public void removeVirtualHosts(String[] virtualHosts) {
        if (virtualHosts == null) {
            return;
        }
        if (this._vhosts == null || this._vhosts.length == 0) {
            return;
        }
        ArrayList<String> existingVirtualHosts = new ArrayList<String>(Arrays.asList(this._vhosts));
        for (int i = 0; i < virtualHosts.length; ++i) {
            String toRemoveVirtualHost = this.normalizeHostname(virtualHosts[i]);
            if (!existingVirtualHosts.contains(toRemoveVirtualHost)) continue;
            existingVirtualHosts.remove(toRemoveVirtualHost);
        }
        this._vhosts = existingVirtualHosts.isEmpty() ? null : existingVirtualHosts.toArray(new String[0]);
    }

    public String[] getVirtualHosts() {
        return this._vhosts;
    }

    public String[] getConnectorNames() {
        if (this._connectors == null || this._connectors.size() == 0) {
            return null;
        }
        return this._connectors.toArray(new String[this._connectors.size()]);
    }

    public void setConnectorNames(String[] connectors) {
        this._connectors = connectors == null || connectors.length == 0 ? null : new HashSet<String>(Arrays.asList(connectors));
    }

    @Override
    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return AttributesMap.getAttributeNamesCopy(this._attributes);
    }

    public Attributes getAttributes() {
        return this._attributes;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public String getClassPath() {
        if (this._classLoader == null || !(this._classLoader instanceof URLClassLoader)) {
            return null;
        }
        URLClassLoader loader2 = (URLClassLoader)this._classLoader;
        URL[] urls = loader2.getURLs();
        StringBuilder classpath = new StringBuilder();
        for (int i = 0; i < urls.length; ++i) {
            try {
                Resource resource = this.newResource(urls[i]);
                File file2 = resource.getFile();
                if (file2 == null || !file2.exists()) continue;
                if (classpath.length() > 0) {
                    classpath.append(File.pathSeparatorChar);
                }
                classpath.append(file2.getAbsolutePath());
                continue;
            }
            catch (IOException e) {
                LOG.debug(e);
            }
        }
        if (classpath.length() == 0) {
            return null;
        }
        return classpath.toString();
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getInitParameter(String name) {
        return this._initParams.get(name);
    }

    public String setInitParameter(String name, String value) {
        return this._initParams.put(name, value);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this._initParams.keySet());
    }

    public Map<String, String> getInitParams() {
        return this._initParams;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public EventListener[] getEventListeners() {
        return this._eventListeners;
    }

    public void setEventListeners(EventListener[] eventListeners) {
        this._contextListeners = null;
        this._contextAttributeListeners = null;
        this._requestListeners = null;
        this._requestAttributeListeners = null;
        this._eventListeners = eventListeners;
        for (int i = 0; eventListeners != null && i < eventListeners.length; ++i) {
            EventListener listener = this._eventListeners[i];
            if (listener instanceof ServletContextListener) {
                this._contextListeners = LazyList.add(this._contextListeners, listener);
            }
            if (listener instanceof ServletContextAttributeListener) {
                this._contextAttributeListeners = LazyList.add(this._contextAttributeListeners, listener);
            }
            if (listener instanceof ServletRequestListener) {
                this._requestListeners = LazyList.add(this._requestListeners, listener);
            }
            if (!(listener instanceof ServletRequestAttributeListener)) continue;
            this._requestAttributeListeners = LazyList.add(this._requestAttributeListeners, listener);
        }
    }

    public void addEventListener(EventListener listener) {
        this.setEventListeners(LazyList.addToArray(this.getEventListeners(), listener, EventListener.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShutdown() {
        ContextHandler contextHandler = this;
        synchronized (contextHandler) {
            return !this._shutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShutdown(boolean shutdown) {
        ContextHandler contextHandler = this;
        synchronized (contextHandler) {
            this._shutdown = shutdown;
            this._availability = this.isRunning() ? (this._shutdown ? 2 : (this._available ? 1 : 3)) : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable() {
        ContextHandler contextHandler = this;
        synchronized (contextHandler) {
            return this._available;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvailable(boolean available) {
        ContextHandler contextHandler = this;
        synchronized (contextHandler) {
            this._available = available;
            this._availability = this.isRunning() ? (this._shutdown ? 2 : (this._available ? 1 : 3)) : 0;
        }
    }

    public Logger getLogger() {
        return this._logger;
    }

    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() throws Exception {
        this._availability = 0;
        if (this._contextPath == null) {
            throw new IllegalStateException("Null contextPath");
        }
        this._logger = Log.getLogger(this.getDisplayName() == null ? this.getContextPath() : this.getDisplayName());
        ClassLoader old_classloader = null;
        Thread current_thread = null;
        Context old_context = null;
        try {
            if (this._classLoader != null) {
                current_thread = Thread.currentThread();
                old_classloader = current_thread.getContextClassLoader();
                current_thread.setContextClassLoader(this._classLoader);
            }
            if (this._mimeTypes == null) {
                this._mimeTypes = new MimeTypes();
            }
            old_context = __context.get();
            __context.set(this._scontext);
            this.startContext();
            ContextHandler contextHandler = this;
            synchronized (contextHandler) {
                this._availability = this._shutdown ? 2 : (this._available ? 1 : 3);
            }
            Object var7_6 = null;
            __context.set(old_context);
            if (this._classLoader != null) {
                current_thread.setContextClassLoader(old_classloader);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            __context.set(old_context);
            if (this._classLoader != null) {
                current_thread.setContextClassLoader(old_classloader);
            }
            throw throwable;
        }
    }

    protected void startContext() throws Exception {
        String managedAttributes = this._initParams.get(MANAGED_ATTRIBUTES);
        if (managedAttributes != null) {
            String[] attributes;
            this._managedAttributes = new HashMap<String, Object>();
            for (String attribute : attributes = managedAttributes.split(",")) {
                this._managedAttributes.put(attribute, null);
            }
            Enumeration e = this._scontext.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Object value = this._scontext.getAttribute(name);
                this.checkManagedAttribute(name, value);
            }
        }
        super.doStart();
        if (this._errorHandler != null) {
            this._errorHandler.start();
        }
        if (this._contextListeners != null) {
            ServletContextEvent event2 = new ServletContextEvent((ServletContext)this._scontext);
            for (int i = 0; i < LazyList.size(this._contextListeners); ++i) {
                ((ServletContextListener)LazyList.get(this._contextListeners, i)).contextInitialized(event2);
            }
        }
        LOG.info("started {}", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        this._availability = 0;
        ClassLoader old_classloader = null;
        Thread current_thread = null;
        Context old_context = __context.get();
        __context.set(this._scontext);
        try {
            if (this._classLoader != null) {
                current_thread = Thread.currentThread();
                old_classloader = current_thread.getContextClassLoader();
                current_thread.setContextClassLoader(this._classLoader);
            }
            super.doStop();
            if (this._contextListeners != null) {
                ServletContextEvent event2 = new ServletContextEvent((ServletContext)this._scontext);
                int i = LazyList.size(this._contextListeners);
                while (i-- > 0) {
                    ((ServletContextListener)LazyList.get(this._contextListeners, i)).contextDestroyed(event2);
                }
            }
            if (this._errorHandler != null) {
                this._errorHandler.stop();
            }
            Enumeration e = this._scontext.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                this.checkManagedAttribute(name, null);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            LOG.info("stopped {}", this);
            __context.set(old_context);
            if (this._classLoader != null) {
                current_thread.setContextClassLoader(old_classloader);
            }
            throw throwable;
        }
        LOG.info("stopped {}", this);
        __context.set(old_context);
        if (this._classLoader != null) {
            current_thread.setContextClassLoader(old_classloader);
        }
        this._contextAttributes.clearAttributes();
    }

    public boolean checkContext(String target, Request baseRequest, HttpServletResponse response2) throws IOException, ServletException {
        String connector;
        DispatcherType dispatch = baseRequest.getDispatcherType();
        switch (this._availability) {
            case 0: 
            case 2: {
                return false;
            }
            case 3: {
                baseRequest.setHandled(true);
                response2.sendError(503);
                return false;
            }
        }
        if (DispatcherType.REQUEST.equals((Object)dispatch) && baseRequest.isHandled()) {
            return false;
        }
        if (this._vhosts != null && this._vhosts.length > 0) {
            String vhost = this.normalizeHostname(baseRequest.getServerName());
            boolean match = false;
            for (int i = 0; !match && i < this._vhosts.length; ++i) {
                String contextVhost = this._vhosts[i];
                if (contextVhost == null) continue;
                match = contextVhost.startsWith("*.") ? contextVhost.regionMatches(true, 2, vhost, vhost.indexOf(".") + 1, contextVhost.length() - 2) : contextVhost.equalsIgnoreCase(vhost);
            }
            if (!match) {
                return false;
            }
        }
        if (!(this._connectors == null || this._connectors.size() <= 0 || (connector = AbstractHttpConnection.getCurrentConnection().getConnector().getName()) != null && this._connectors.contains(connector))) {
            return false;
        }
        if (this._contextPath.length() > 1) {
            if (!target.startsWith(this._contextPath)) {
                return false;
            }
            if (target.length() > this._contextPath.length() && target.charAt(this._contextPath.length()) != '/') {
                return false;
            }
            if (!this._allowNullPathInfo && this._contextPath.length() == target.length()) {
                baseRequest.setHandled(true);
                if (baseRequest.getQueryString() != null) {
                    response2.sendRedirect(URIUtil.addPaths(baseRequest.getRequestURI(), "/") + "?" + baseRequest.getQueryString());
                } else {
                    response2.sendRedirect(URIUtil.addPaths(baseRequest.getRequestURI(), "/"));
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response2) throws IOException, ServletException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("scope {}|{}|{} @ {}", baseRequest.getContextPath(), baseRequest.getServletPath(), baseRequest.getPathInfo(), this);
        }
        Context old_context = null;
        String old_context_path = null;
        String old_servlet_path = null;
        String old_path_info = null;
        ClassLoader old_classloader = null;
        Thread current_thread = null;
        String pathInfo = target;
        DispatcherType dispatch = baseRequest.getDispatcherType();
        old_context = baseRequest.getContext();
        if (old_context != this._scontext) {
            if (DispatcherType.REQUEST.equals((Object)dispatch) || DispatcherType.ASYNC.equals((Object)dispatch)) {
                if (this._compactPath) {
                    target = URIUtil.compactPath(target);
                }
                if (!this.checkContext(target, baseRequest, response2)) {
                    return;
                }
                if (target.length() > this._contextPath.length()) {
                    if (this._contextPath.length() > 1) {
                        target = target.substring(this._contextPath.length());
                    }
                    pathInfo = target;
                } else if (this._contextPath.length() == 1) {
                    target = "/";
                    pathInfo = "/";
                } else {
                    target = "/";
                    pathInfo = null;
                }
            }
            if (this._classLoader != null) {
                current_thread = Thread.currentThread();
                old_classloader = current_thread.getContextClassLoader();
                current_thread.setContextClassLoader(this._classLoader);
            }
        }
        try {
            old_context_path = baseRequest.getContextPath();
            old_servlet_path = baseRequest.getServletPath();
            old_path_info = baseRequest.getPathInfo();
            baseRequest.setContext(this._scontext);
            __context.set(this._scontext);
            if (!DispatcherType.INCLUDE.equals((Object)dispatch) && target.startsWith("/")) {
                if (this._contextPath.length() == 1) {
                    baseRequest.setContextPath("");
                } else {
                    baseRequest.setContextPath(this._contextPath);
                }
                baseRequest.setServletPath(null);
                baseRequest.setPathInfo(pathInfo);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("context={}|{}|{} @ {}", baseRequest.getContextPath(), baseRequest.getServletPath(), baseRequest.getPathInfo(), this);
            }
            if (this.never()) {
                this.nextScope(target, baseRequest, request, response2);
            } else if (this._nextScope != null) {
                this._nextScope.doScope(target, baseRequest, request, response2);
            } else if (this._outerScope != null) {
                this._outerScope.doHandle(target, baseRequest, request, response2);
            } else {
                this.doHandle(target, baseRequest, request, response2);
            }
            Object var14_13 = null;
            if (old_context != this._scontext) {
                if (this._classLoader != null) {
                    current_thread.setContextClassLoader(old_classloader);
                }
                baseRequest.setContext(old_context);
                __context.set(old_context);
                baseRequest.setContextPath(old_context_path);
                baseRequest.setServletPath(old_servlet_path);
                baseRequest.setPathInfo(old_path_info);
            }
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (old_context != this._scontext) {
                if (this._classLoader != null) {
                    current_thread.setContextClassLoader(old_classloader);
                }
                baseRequest.setContext(old_context);
                __context.set(old_context);
                baseRequest.setContextPath(old_context_path);
                baseRequest.setServletPath(old_servlet_path);
                baseRequest.setPathInfo(old_path_info);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response2) throws IOException, ServletException {
        block24: {
            DispatcherType dispatch = baseRequest.getDispatcherType();
            boolean new_context = baseRequest.takeNewContext();
            try {
                block23: {
                    try {
                        if (new_context) {
                            int s;
                            if (this._requestAttributeListeners != null) {
                                s = LazyList.size(this._requestAttributeListeners);
                                for (int i = 0; i < s; ++i) {
                                    baseRequest.addEventListener((EventListener)LazyList.get(this._requestAttributeListeners, i));
                                }
                            }
                            if (this._requestListeners != null) {
                                s = LazyList.size(this._requestListeners);
                                ServletRequestEvent sre = new ServletRequestEvent((ServletContext)this._scontext, (ServletRequest)request);
                                for (int i = 0; i < s; ++i) {
                                    ((ServletRequestListener)LazyList.get(this._requestListeners, i)).requestInitialized(sre);
                                }
                            }
                        }
                        if (DispatcherType.REQUEST.equals((Object)dispatch) && this.isProtectedTarget(target)) {
                            throw new HttpException(404);
                        }
                        if (this.never()) {
                            this.nextHandle(target, baseRequest, request, response2);
                            break block23;
                        }
                        if (this._nextScope != null && this._nextScope == this._handler) {
                            this._nextScope.doHandle(target, baseRequest, request, response2);
                            break block23;
                        }
                        if (this._handler == null) break block23;
                        this._handler.handle(target, baseRequest, request, response2);
                    }
                    catch (HttpException e) {
                        LOG.debug(e);
                        baseRequest.setHandled(true);
                        response2.sendError(e.getStatus(), e.getReason());
                        Object var11_13 = null;
                        if (!new_context) return;
                        if (this._requestListeners != null) {
                            ServletRequestEvent sre = new ServletRequestEvent((ServletContext)this._scontext, (ServletRequest)request);
                            int i2 = LazyList.size(this._requestListeners);
                            while (i2-- > 0) {
                                ((ServletRequestListener)LazyList.get(this._requestListeners, i2)).requestDestroyed(sre);
                            }
                        }
                        if (this._requestAttributeListeners == null) return;
                        int i = LazyList.size(this._requestAttributeListeners);
                        while (i-- > 0) {
                            baseRequest.removeEventListener((EventListener)LazyList.get(this._requestAttributeListeners, i));
                        }
                        return;
                    }
                }
                Object var11_12 = null;
                if (!new_context) return;
                if (this._requestListeners == null) break block24;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (!new_context) throw throwable;
                if (this._requestListeners != null) {
                    ServletRequestEvent sre = new ServletRequestEvent((ServletContext)this._scontext, (ServletRequest)request);
                    int i2 = LazyList.size(this._requestListeners);
                    while (i2-- > 0) {
                        ((ServletRequestListener)LazyList.get(this._requestListeners, i2)).requestDestroyed(sre);
                    }
                }
                if (this._requestAttributeListeners == null) throw throwable;
                int i = LazyList.size(this._requestAttributeListeners);
                while (i-- > 0) {
                    baseRequest.removeEventListener((EventListener)LazyList.get(this._requestAttributeListeners, i));
                }
                throw throwable;
            }
            ServletRequestEvent sre = new ServletRequestEvent((ServletContext)this._scontext, (ServletRequest)request);
            int i2 = LazyList.size(this._requestListeners);
            while (i2-- > 0) {
                ((ServletRequestListener)LazyList.get(this._requestListeners, i2)).requestDestroyed(sre);
            }
        }
        if (this._requestAttributeListeners == null) return;
        int i = LazyList.size(this._requestAttributeListeners);
        while (i-- > 0) {
            baseRequest.removeEventListener((EventListener)LazyList.get(this._requestAttributeListeners, i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Runnable runnable) {
        ClassLoader old_classloader = null;
        Thread current_thread = null;
        Context old_context = null;
        try {
            old_context = __context.get();
            __context.set(this._scontext);
            if (this._classLoader != null) {
                current_thread = Thread.currentThread();
                old_classloader = current_thread.getContextClassLoader();
                current_thread.setContextClassLoader(this._classLoader);
            }
            runnable.run();
            Object var6_5 = null;
            __context.set(old_context);
            if (old_classloader != null) {
                current_thread.setContextClassLoader(old_classloader);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            __context.set(old_context);
            if (old_classloader != null) {
                current_thread.setContextClassLoader(old_classloader);
            }
            throw throwable;
        }
    }

    public boolean isProtectedTarget(String target) {
        if (target == null || this._protectedTargets == null) {
            return false;
        }
        while (target.startsWith("//")) {
            target = URIUtil.compactPath(target);
        }
        boolean isProtected = false;
        int i = 0;
        while (!isProtected && i < this._protectedTargets.length) {
            isProtected = StringUtil.startsWithIgnoreCase(target, this._protectedTargets[i++]);
        }
        return isProtected;
    }

    public void setProtectedTargets(String[] targets) {
        if (targets == null) {
            this._protectedTargets = null;
            return;
        }
        this._protectedTargets = new String[targets.length];
        System.arraycopy(targets, 0, this._protectedTargets, 0, targets.length);
    }

    public String[] getProtectedTargets() {
        if (this._protectedTargets == null) {
            return null;
        }
        String[] tmp = new String[this._protectedTargets.length];
        System.arraycopy(this._protectedTargets, 0, tmp, 0, this._protectedTargets.length);
        return tmp;
    }

    @Override
    public void removeAttribute(String name) {
        this.checkManagedAttribute(name, null);
        this._attributes.removeAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.checkManagedAttribute(name, value);
        this._attributes.setAttribute(name, value);
    }

    public void setAttributes(Attributes attributes) {
        this._attributes.clearAttributes();
        this._attributes.addAll(attributes);
        Enumeration<String> e = this._attributes.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            this.checkManagedAttribute(name, attributes.getAttribute(name));
        }
    }

    @Override
    public void clearAttributes() {
        Enumeration<String> e = this._attributes.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            this.checkManagedAttribute(name, null);
        }
        this._attributes.clearAttributes();
    }

    public void checkManagedAttribute(String name, Object value) {
        if (this._managedAttributes != null && this._managedAttributes.containsKey(name)) {
            this.setManagedAttribute(name, value);
        }
    }

    public void setManagedAttribute(String name, Object value) {
        Object old = this._managedAttributes.put(name, value);
        this.getServer().getContainer().update((Object)this, old, value, name, true);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public void setContextPath(String contextPath) {
        if (contextPath != null && contextPath.length() > 1 && contextPath.endsWith("/")) {
            throw new IllegalArgumentException("ends with /");
        }
        this._contextPath = contextPath;
        if (this.getServer() != null && (this.getServer().isStarting() || this.getServer().isStarted())) {
            Handler[] contextCollections = this.getServer().getChildHandlersByClass(ContextHandlerCollection.class);
            for (int h = 0; contextCollections != null && h < contextCollections.length; ++h) {
                ((ContextHandlerCollection)contextCollections[h]).mapContexts();
            }
        }
    }

    public void setDisplayName(String servletContextName) {
        this._displayName = servletContextName;
    }

    public Resource getBaseResource() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource;
    }

    public String getResourceBase() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource.toString();
    }

    public void setBaseResource(Resource base) {
        this._baseResource = base;
    }

    public void setResourceBase(String resourceBase) {
        try {
            this.setBaseResource(this.newResource(resourceBase));
        }
        catch (Exception e) {
            LOG.warn(e.toString(), new Object[0]);
            LOG.debug(e);
            throw new IllegalArgumentException(resourceBase);
        }
    }

    public boolean isAliases() {
        return this._aliases;
    }

    public void setAliases(boolean aliases) {
        this._aliases = aliases;
    }

    public MimeTypes getMimeTypes() {
        if (this._mimeTypes == null) {
            this._mimeTypes = new MimeTypes();
        }
        return this._mimeTypes;
    }

    public void setMimeTypes(MimeTypes mimeTypes) {
        this._mimeTypes = mimeTypes;
    }

    public void setWelcomeFiles(String[] files2) {
        this._welcomeFiles = files2;
    }

    public String[] getWelcomeFiles() {
        return this._welcomeFiles;
    }

    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler != null) {
            errorHandler.setServer(this.getServer());
        }
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, this._errorHandler, errorHandler, "errorHandler", true);
        }
        this._errorHandler = errorHandler;
    }

    public int getMaxFormContentSize() {
        return this._maxFormContentSize;
    }

    public void setMaxFormContentSize(int maxSize) {
        this._maxFormContentSize = maxSize;
    }

    public int getMaxFormKeys() {
        return this._maxFormKeys;
    }

    public void setMaxFormKeys(int max) {
        this._maxFormKeys = max;
    }

    public boolean isCompactPath() {
        return this._compactPath;
    }

    public void setCompactPath(boolean compactPath) {
        this._compactPath = compactPath;
    }

    public String toString() {
        String p;
        String[] vhosts = this.getVirtualHosts();
        StringBuilder b = new StringBuilder();
        Package pkg = this.getClass().getPackage();
        if (pkg != null && (p = pkg.getName()) != null && p.length() > 0) {
            String[] ss;
            for (String s : ss = p.split("\\.")) {
                b.append(s.charAt(0)).append('.');
            }
        }
        b.append(this.getClass().getSimpleName());
        b.append('{').append(this.getContextPath()).append(',').append(this.getBaseResource());
        if (vhosts != null && vhosts.length > 0) {
            b.append(',').append(vhosts[0]);
        }
        b.append('}');
        return b.toString();
    }

    public synchronized Class<?> loadClass(String className) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        if (this._classLoader == null) {
            return Loader.loadClass(this.getClass(), className);
        }
        return this._classLoader.loadClass(className);
    }

    public void addLocaleEncoding(String locale, String encoding) {
        if (this._localeEncodingMap == null) {
            this._localeEncodingMap = new HashMap<String, String>();
        }
        this._localeEncodingMap.put(locale, encoding);
    }

    public String getLocaleEncoding(String locale) {
        if (this._localeEncodingMap == null) {
            return null;
        }
        String encoding = this._localeEncodingMap.get(locale);
        return encoding;
    }

    public String getLocaleEncoding(Locale locale) {
        if (this._localeEncodingMap == null) {
            return null;
        }
        String encoding = this._localeEncodingMap.get(locale.toString());
        if (encoding == null) {
            encoding = this._localeEncodingMap.get(locale.getLanguage());
        }
        return encoding;
    }

    public Resource getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException(path);
        }
        if (this._baseResource == null) {
            return null;
        }
        try {
            path = URIUtil.canonicalPath(path);
            Resource resource = this._baseResource.addPath(path);
            if (!this._aliases && resource.getAlias() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Aliased resource: " + resource + "~=" + resource.getAlias(), new Object[0]);
                }
                for (AliasCheck check : this._aliasChecks) {
                    if (!check.check(path, resource)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Aliased resource: " + resource + " approved by " + check, new Object[0]);
                    }
                    return resource;
                }
                return null;
            }
            return resource;
        }
        catch (Exception e) {
            LOG.ignore(e);
            return null;
        }
    }

    public Resource newResource(URL url2) throws IOException {
        return Resource.newResource(url2);
    }

    public Resource newResource(String urlOrPath) throws IOException {
        return Resource.newResource(urlOrPath);
    }

    public Set<String> getResourcePaths(String path) {
        try {
            path = URIUtil.canonicalPath(path);
            Resource resource = this.getResource(path);
            if (resource != null && resource.exists()) {
                String[] l;
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                if ((l = resource.list()) != null) {
                    HashSet<String> set = new HashSet<String>();
                    for (int i = 0; i < l.length; ++i) {
                        set.add(path + l[i]);
                    }
                    return set;
                }
            }
        }
        catch (Exception e) {
            LOG.ignore(e);
        }
        return Collections.emptySet();
    }

    private String normalizeHostname(String host) {
        if (host == null) {
            return null;
        }
        if (host.endsWith(".")) {
            return host.substring(0, host.length() - 1);
        }
        return host;
    }

    public void addAliasCheck(AliasCheck check) {
        this._aliasChecks.add(check);
    }

    public List<AliasCheck> getAliasChecks() {
        return this._aliasChecks;
    }

    public static class ApproveNonExistentDirectoryAliases
    implements AliasCheck {
        public boolean check(String path, Resource resource) {
            if (resource.exists()) {
                return false;
            }
            String a = resource.getAlias().toString();
            String r = resource.getURL().toString();
            if (a.length() > r.length()) {
                return a.startsWith(r) && a.length() == r.length() + 1 && a.endsWith("/");
            }
            return r.startsWith(a) && r.length() == a.length() + 1 && r.endsWith("/");
        }
    }

    @Deprecated
    public static class ApprovePathPrefixAliases
    implements AliasCheck {
        public ApprovePathPrefixAliases() {
            LOG.warn("ApprovePathPrefixAliases is not safe for production", new Object[0]);
        }

        public boolean check(String path, Resource resource) {
            int slash = path.lastIndexOf(47);
            if (slash < 0 || slash == path.length() - 1) {
                return false;
            }
            String suffix = path.substring(slash);
            return resource.toString().endsWith(suffix);
        }
    }

    @Deprecated
    public static class ApproveSameSuffixAliases
    implements AliasCheck {
        public ApproveSameSuffixAliases() {
            LOG.warn("ApproveSameSuffixAlias is not safe for production", new Object[0]);
        }

        public boolean check(String path, Resource resource) {
            int dot = path.lastIndexOf(46);
            if (dot < 0) {
                return false;
            }
            String suffix = path.substring(dot);
            return resource.toString().endsWith(suffix);
        }
    }

    public static interface AliasCheck {
        public boolean check(String var1, Resource var2);
    }

    private static class CLDump
    implements Dumpable {
        final ClassLoader _loader;

        CLDump(ClassLoader loader2) {
            this._loader = loader2;
        }

        public String dump() {
            return AggregateLifeCycle.dump(this);
        }

        public void dump(Appendable out, String indent) throws IOException {
            Object parent;
            out.append(String.valueOf(this._loader)).append("\n");
            if (this._loader != null && (parent = this._loader.getParent()) != null) {
                if (!(parent instanceof Dumpable)) {
                    parent = new CLDump((ClassLoader)parent);
                }
                if (this._loader instanceof URLClassLoader) {
                    AggregateLifeCycle.dump(out, indent, TypeUtil.asList(((URLClassLoader)this._loader).getURLs()), Collections.singleton(parent));
                } else {
                    AggregateLifeCycle.dump(out, indent, Collections.singleton(parent));
                }
            }
        }
    }

    public class Context
    implements ServletContext {
        protected Context() {
        }

        public ContextHandler getContextHandler() {
            return ContextHandler.this;
        }

        public ServletContext getContext(String uripath) {
            ContextHandler ch;
            String context_path;
            ArrayList<ContextHandler> contexts = new ArrayList<ContextHandler>();
            Handler[] handlers = ContextHandler.this.getServer().getChildHandlersByClass(ContextHandler.class);
            String matched_path = null;
            for (Handler handler2 : handlers) {
                if (handler2 == null || !uripath.equals(context_path = (ch = (ContextHandler)handler2).getContextPath()) && (!uripath.startsWith(context_path) || uripath.charAt(context_path.length()) != '/') && !"/".equals(context_path)) continue;
                if (ContextHandler.this.getVirtualHosts() != null && ContextHandler.this.getVirtualHosts().length > 0) {
                    if (ch.getVirtualHosts() == null || ch.getVirtualHosts().length <= 0) continue;
                    for (String h1 : ContextHandler.this.getVirtualHosts()) {
                        for (String h2 : ch.getVirtualHosts()) {
                            if (!h1.equals(h2)) continue;
                            if (matched_path == null || context_path.length() > matched_path.length()) {
                                contexts.clear();
                                matched_path = context_path;
                            }
                            if (!matched_path.equals(context_path)) continue;
                            contexts.add(ch);
                        }
                    }
                    continue;
                }
                if (matched_path == null || context_path.length() > matched_path.length()) {
                    contexts.clear();
                    matched_path = context_path;
                }
                if (!matched_path.equals(context_path)) continue;
                contexts.add(ch);
            }
            if (contexts.size() > 0) {
                return ((ContextHandler)contexts.get((int)0))._scontext;
            }
            matched_path = null;
            for (Handler handler2 : handlers) {
                if (handler2 == null || !uripath.equals(context_path = (ch = (ContextHandler)handler2).getContextPath()) && (!uripath.startsWith(context_path) || uripath.charAt(context_path.length()) != '/') && !"/".equals(context_path)) continue;
                if (matched_path == null || context_path.length() > matched_path.length()) {
                    contexts.clear();
                    matched_path = context_path;
                }
                if (!matched_path.equals(context_path)) continue;
                contexts.add(ch);
            }
            if (contexts.size() > 0) {
                return ((ContextHandler)contexts.get((int)0))._scontext;
            }
            return null;
        }

        public int getMajorVersion() {
            return 2;
        }

        public String getMimeType(String file2) {
            if (ContextHandler.this._mimeTypes == null) {
                return null;
            }
            Buffer mime = ContextHandler.this._mimeTypes.getMimeByExtension(file2);
            if (mime != null) {
                return mime.toString();
            }
            return null;
        }

        public int getMinorVersion() {
            return 5;
        }

        public RequestDispatcher getNamedDispatcher(String name) {
            return null;
        }

        public RequestDispatcher getRequestDispatcher(String uriInContext) {
            if (uriInContext == null) {
                return null;
            }
            if (!uriInContext.startsWith("/")) {
                return null;
            }
            try {
                String query = null;
                int q = 0;
                q = uriInContext.indexOf(63);
                if (q > 0) {
                    query = uriInContext.substring(q + 1);
                    uriInContext = uriInContext.substring(0, q);
                }
                String pathInContext = URIUtil.canonicalPath(URIUtil.decodePath(uriInContext));
                String uri = URIUtil.addPaths(this.getContextPath(), uriInContext);
                ContextHandler context2 = ContextHandler.this;
                return new Dispatcher(context2, uri, pathInContext, query);
            }
            catch (Exception e) {
                LOG.ignore(e);
                return null;
            }
        }

        public String getRealPath(String path) {
            if (path == null) {
                return null;
            }
            if (path.length() == 0) {
                path = "/";
            } else if (path.charAt(0) != '/') {
                path = "/" + path;
            }
            try {
                File file2;
                Resource resource = ContextHandler.this.getResource(path);
                if (resource != null && (file2 = resource.getFile()) != null) {
                    return file2.getCanonicalPath();
                }
            }
            catch (Exception e) {
                LOG.ignore(e);
            }
            return null;
        }

        public URL getResource(String path) throws MalformedURLException {
            Resource resource = ContextHandler.this.getResource(path);
            if (resource != null && resource.exists()) {
                return resource.getURL();
            }
            return null;
        }

        public InputStream getResourceAsStream(String path) {
            try {
                URL url2 = this.getResource(path);
                if (url2 == null) {
                    return null;
                }
                Resource r = Resource.newResource(url2);
                return r.getInputStream();
            }
            catch (Exception e) {
                LOG.ignore(e);
                return null;
            }
        }

        public Set getResourcePaths(String path) {
            return ContextHandler.this.getResourcePaths(path);
        }

        public String getServerInfo() {
            return "jetty/" + Server.getVersion();
        }

        public Servlet getServlet(String name) throws ServletException {
            return null;
        }

        public Enumeration getServletNames() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public Enumeration getServlets() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public void log(Exception exception, String msg) {
            ContextHandler.this._logger.warn(msg, exception);
        }

        public void log(String msg) {
            ContextHandler.this._logger.info(msg, new Object[0]);
        }

        public void log(String message, Throwable throwable) {
            ContextHandler.this._logger.warn(message, throwable);
        }

        public String getInitParameter(String name) {
            return ContextHandler.this.getInitParameter(name);
        }

        public Enumeration getInitParameterNames() {
            return ContextHandler.this.getInitParameterNames();
        }

        public synchronized Object getAttribute(String name) {
            Object o = ContextHandler.this.getAttribute(name);
            if (o == null && ContextHandler.this._contextAttributes != null) {
                o = ContextHandler.this._contextAttributes.getAttribute(name);
            }
            return o;
        }

        public synchronized Enumeration getAttributeNames() {
            Enumeration<String> e;
            HashSet<String> set = new HashSet<String>();
            if (ContextHandler.this._contextAttributes != null) {
                e = ContextHandler.this._contextAttributes.getAttributeNames();
                while (e.hasMoreElements()) {
                    set.add(e.nextElement());
                }
            }
            e = ContextHandler.this._attributes.getAttributeNames();
            while (e.hasMoreElements()) {
                set.add(e.nextElement());
            }
            return Collections.enumeration(set);
        }

        public synchronized void setAttribute(String name, Object value) {
            ContextHandler.this.checkManagedAttribute(name, value);
            Object old_value = ContextHandler.this._contextAttributes.getAttribute(name);
            if (value == null) {
                ContextHandler.this._contextAttributes.removeAttribute(name);
            } else {
                ContextHandler.this._contextAttributes.setAttribute(name, value);
            }
            if (ContextHandler.this._contextAttributeListeners != null) {
                ServletContextAttributeEvent event2 = new ServletContextAttributeEvent((ServletContext)ContextHandler.this._scontext, name, old_value == null ? value : old_value);
                for (int i = 0; i < LazyList.size(ContextHandler.this._contextAttributeListeners); ++i) {
                    ServletContextAttributeListener l = (ServletContextAttributeListener)LazyList.get(ContextHandler.this._contextAttributeListeners, i);
                    if (old_value == null) {
                        l.attributeAdded(event2);
                        continue;
                    }
                    if (value == null) {
                        l.attributeRemoved(event2);
                        continue;
                    }
                    l.attributeReplaced(event2);
                }
            }
        }

        public synchronized void removeAttribute(String name) {
            ContextHandler.this.checkManagedAttribute(name, null);
            if (ContextHandler.this._contextAttributes == null) {
                ContextHandler.this._attributes.removeAttribute(name);
                return;
            }
            Object old_value = ContextHandler.this._contextAttributes.getAttribute(name);
            ContextHandler.this._contextAttributes.removeAttribute(name);
            if (old_value != null && ContextHandler.this._contextAttributeListeners != null) {
                ServletContextAttributeEvent event2 = new ServletContextAttributeEvent((ServletContext)ContextHandler.this._scontext, name, old_value);
                for (int i = 0; i < LazyList.size(ContextHandler.this._contextAttributeListeners); ++i) {
                    ((ServletContextAttributeListener)LazyList.get(ContextHandler.this._contextAttributeListeners, i)).attributeRemoved(event2);
                }
            }
        }

        public String getServletContextName() {
            String name = ContextHandler.this.getDisplayName();
            if (name == null) {
                name = ContextHandler.this.getContextPath();
            }
            return name;
        }

        public String getContextPath() {
            if (ContextHandler.this._contextPath != null && ContextHandler.this._contextPath.equals("/")) {
                return "";
            }
            return ContextHandler.this._contextPath;
        }

        public String toString() {
            return "ServletContext@" + ContextHandler.this.toString();
        }

        public boolean setInitParameter(String name, String value) {
            if (ContextHandler.this.getInitParameter(name) != null) {
                return false;
            }
            ContextHandler.this.getInitParams().put(name, value);
            return true;
        }
    }
}

